package com.xunlei.niux.manager.template.builder.jinzuan;

import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.data.vipgame.vo.LinkInfo;
import com.xunlei.niux.manager.web.cache.GameCache;
import org.apache.commons.collections.CollectionUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by jamesjxin on 14-9-23.
 */
public class JinZuanUtil {

    public static List<Map<String,Object>> getRecommendGameList(String linklocid){
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();

        LinkInfo query = new LinkInfo();
        query.setLinklocid(linklocid);
        List<LinkInfo> linkinfoList = FacadeFactory.INSTANCE.getLinkInfoBo().find(query);
        if (CollectionUtils.isEmpty(linkinfoList)) {
            return list;
        }

        for (LinkInfo linkInfo : linkinfoList) {
            String gameid = linkInfo.getGameid();
            Games game = GameCache.getInstance().getGameByGameId(gameid);
            if (game == null) {
                continue;
            }

            Map<String, Object> map = new HashMap<String, Object>();
            map.put("gameId", gameid);
            map.put("gameNo", game.getGameNo() == null ? "" : game.getGameNo());
            map.put("gameName", game.getGameName() == null ? "" : game.getGameName());
            map.put("simpleName", game.getSimpleName() == null ? "" : game.getSimpleName());
            list.add(map);
        }

        return list;
    }
}
