package com.xunlei.niux.manager.template.builder.jinzuan;

import com.xunlei.niux.manager.template.builder.AbstractTemplateBuilder;
import org.apache.log4j.Logger;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

/**
 * Created with IntelliJ IDEA.
 * User: admin
 * Date: 14-3-10
 * Time: 下午4:56
 * 金钻官网页面生成模版
 */
public class JinZuanBuilder extends AbstractTemplateBuilder {
    private static final Logger logger = Logger.getLogger(JinZuanBuilder.class);
    private String inputPath;
    private String outputPath;
    private boolean isPreview;

    private ExecutorService executorService;

    @Override
    public void executeShcema() throws Exception {
        this.inputPath = htmlTemplate.getTemplateroot();
        this.outputPath = isPreView?htmlTemplate.getPreviewhtmlroot():htmlTemplate.getHtmlroot();
        this.isPreview = isPreView;

//        inputPath = "/Users/jamesjxin/Work/XL工作目录/20140311金钻/模版/1";
//        outputPath = "/Users/jamesjxin/Work/XL工作目录/20140311金钻/模版/output";
//        isPreView = false;

        executorService = Executors.newCachedThreadPool();

        String templateId = htmlTemplate.getTemplateid();
        logger.info(templateId+" JianZuanBuilder: start!");

        //首页模版 done
        Future future1 = executorService.submit(new IndexPageBuilder(inputPath, outputPath, isPreView));

        //公告列表页 done
        Future future2 = executorService.submit(new AdviceListPageBuilder(inputPath,outputPath,isPreView));

        //左侧公用模版
        Future future3 = executorService.submit(new LeftPartRankingPageBuilder(inputPath,outputPath,isPreview));

        //金钻抽奖模版 done
        Future future4 = executorService.submit(new LotteryPageBulider(inputPath,outputPath,isPreView));

        //金钻礼包模版 done
        Future future5 = executorService.submit(new GiftPackagePageBuilder(inputPath,outputPath,isPreView));

        //金钻活动模版 done
        Future future6 = executorService.submit(new ActivityPageBuilder(inputPath,outputPath,isPreView));

        //常见问题模版
        Future future7 = executorService.submit(new QuestionListPageBuilder(inputPath,outputPath,isPreview));

        //特权信息js文件
        Future future8 = executorService.submit(new AllServiceInfoBuilder(inputPath,outputPath,isPreview));

        //首充和兑换元宝
        Future future9 = executorService.submit(new FirstPayAndBonusExchangePageBuilder(inputPath,outputPath,isPreview));

        //游戏加成
        Future future10 = executorService.submit(new GameJiaChengBuilder(inputPath,outputPath,isPreview));


        //盒子-金钻礼包页面模版
        Future future11 = executorService.submit(new GiftPackagePageBuilder(inputPath + "/box/",outputPath + "/box/",isPreView));



        future1.get();
        logger.info(templateId+" JianZuanBuilder: IndexPageBuilder finished!");

        //公告列表页 done
        future2.get();
        logger.info(templateId+" JianZuanBuilder: AdviceListPageBuilder finished!");

        //左侧公用模版
        future3.get();
        logger.info(templateId+" JianZuanBuilder: LeftPartRankingPageBuilder finished!");

        //金钻抽奖模版 done
        future4.get();
        logger.info(templateId+" JianZuanBuilder: LotteryPageBulider finished!");

        //金钻礼包模版 done
        future5.get();
        logger.info(templateId+" JianZuanBuilder: GiftPackagePageBuilder finished!");

        //金钻活动模版 done
        future6.get();
        logger.info(templateId+" JianZuanBuilder: ActivityPageBuilder finished!");

        //常见问题模版
        future7.get();
        logger.info(templateId+" JianZuanBuilder: QuestionListPageBuilder finished!");

        //特权信息js文件
        future8.get();
        logger.info(templateId+" JianZuanBuilder: AllServiceInfoBuilder finished!");

        //首充和兑换元宝
        future9.get();
        logger.info(templateId+" JianZuanBuilder: FirstPayAndBonusExchangePageBuilder finished!");

        future10.get();
        logger.info(templateId+" JianZuanBuilder: FirstPayAndBonusExchangePageBuilder finished!");
        
        future11.get();

        logger.info(templateId+" JianZuanBuilder: All finished!");
    }
}
