package com.xunlei.niux.manager.template.builder.jinzuan;

import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.active.dto.commonactivity.ActivityExtendInfoDTO;
import com.xunlei.niux.data.active.facade.FacadeFactory;
import com.xunlei.niux.data.active.vo.commonactivity.ActivityGiftInfo;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.data.vipgame.vo.HtmlTemplate;
import com.xunlei.niux.data.vipgame.vo.gift.Gift;
import com.xunlei.niux.manager.web.cache.GameCache;
import com.xunlei.niux.manager.web.util.FreemarkerUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by jamesjxin on 14-4-21.
 */
public class GiftDetailBuilder {
    private String inputPath;
    private String outputPath;


    public String builder(ActivityGiftInfo activityGiftInfo){
        if (!activityGiftInfo.getHasDetail() || StringUtils.isEmpty(activityGiftInfo.getDetailContent())) {
            return "";
        }

        Map<String, Object> rootMap = new HashMap<String, Object>();
        rootMap.put("productMap",getGiftDetailData(activityGiftInfo));

        HtmlTemplate htmlTemplate= com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getHtmlTemplateBo().find("000052");
        inputPath = htmlTemplate.getTemplateroot();

        outputPath=htmlTemplate.getHtmlroot();
        if(outputPath.endsWith("/")){
            outputPath=outputPath.substring(0, outputPath.length()-1);
        }


//        inputPath = "/Users/jamesjxin/Work/XL工作目录/20140311金钻/模版/2";
//        outputPath = "/Users/jamesjxin/Work/XL工作目录/20140311金钻/模版/output";

        outputPath += "/gift/";

        String inputFileName = "giftDetail.html";

        String outputfileName = "";

        String url = activityGiftInfo.getDetailUrl();
        if(StringUtils.isNotEmpty(url)){
            outputfileName = url.substring(url.lastIndexOf("/")+1);
        }else {
            outputfileName = getArticeUrlName(activityGiftInfo);
        }

        FreemarkerUtil.buildHtml(inputPath, inputFileName, rootMap, outputPath, outputfileName);

        if(StringUtils.isEmpty(url)){
            url = "/gift/" + outputfileName;
        }

        return url;
    }

    private Map<String,Object> getGiftDetailData(ActivityGiftInfo activityGiftInfo){
        ActivityExtendInfoDTO activityDTO = FacadeFactory.INSTANCE.getActivityExtendBo()
                .getActivityInfo(activityGiftInfo.getActNo(), activityGiftInfo.getModuleId());
        if(activityDTO == null){
            return null;
        }

        int giftId = activityGiftInfo.getGiftId();
        Gift gift = getGiftByGiftId(giftId);
        if(gift == null){
            return null;
        }

        Map<String,Object> map = new HashMap<String, Object>();

        map.put("moduleId",activityGiftInfo.getModuleId()==null?"":activityGiftInfo.getModuleId());
        map.put("giftId",giftId);
        map.put("giftType",gift.getGiftType());
        map.put("giftName",gift.getGiftName());
        Games game = null;
        if(StringUtils.isNotEmpty(gift.getGameId())){
            game = GameCache.getInstance().getGameByGameId(gift.getGameId());
        }
        if(game != null){
            map.put("gameName",game.getGameName());
        }else {
            map.put("gameName","");
        }
        map.put("price", gift.getProductTotalPrice() == null ? 0 : gift.getProductTotalPrice());
        map.put("photo_list",activityGiftInfo.getPhoto()==null?"":activityGiftInfo.getPhoto());
        map.put("photo_left",activityGiftInfo.getSmallPic()==null?"":activityGiftInfo.getSmallPic());
        map.put("photo_index1",activityGiftInfo.getExt1()==null?"":activityGiftInfo.getExt1());
        map.put("photo_index2",activityGiftInfo.getExt2()==null?"":activityGiftInfo.getExt2());
        map.put("vipLevel",activityDTO.getJinkaLevelLimit());
        map.put("validPeriod",StringUtils.isEmpty(activityDTO.getEndTime())?"":activityDTO.getEndTime());
        map.put("desc",gift.getSimpleDesc());
        map.put("detail",getContent(activityGiftInfo));
        String rule = gift.getExt1()==null?"":gift.getExt1();
        if(rule.length()>15){
            rule= rule.substring(0,15);
        }
        map.put("rule",rule);

        return map;
    }

    private String getContent(final ActivityGiftInfo activityGiftInfo) {
        //替换静态图片访问地址
        String content = activityGiftInfo.getDetailContent() == null ? "" : activityGiftInfo.getDetailContent();
        content = content.replaceAll("src=\"/xlniuxmanager/userUploadFile/image", "src=\"http://img.smxj.webgame.kanimg.com/userUploadFile/image");
        content = content.replaceAll("src=\"/xlniumanager/userUploadFile/image", "src=\"http://img.smxj.webgame.kanimg.com/userUploadFile/image");

        return content;
    }

    private String getArticeUrlName(final ActivityGiftInfo activityGiftInfo){
        if(StringUtils.isEmpty(activityGiftInfo.getDetailUrl())){
            return System.currentTimeMillis()+".html";
        }
        String contentUrl=activityGiftInfo.getDetailUrl();
        if(contentUrl.contains("/gift/")){
            return contentUrl.substring(contentUrl.lastIndexOf("/")+1);
        }

        return System.currentTimeMillis()+".html";
    }

    private Gift getGiftByGiftId(int giftId){
        Gift query = new Gift();
        query.setGiftId((long)giftId);
        query.setIsValid(true);

        List<Gift> giftList = com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getBaseSo().findObjects(query, new Page());

        if(CollectionUtils.isEmpty(giftList)){
            return null;
        }
        return giftList.get(0);
    }

    public static void main(String[] args){
        String str = "/gift/abcdeft.html";
        str = str.substring(str.lastIndexOf("/gift/"));
        System.out.println(str);
    }
}
