package com.xunlei.niux.manager.template.builder.jinzuan;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.data.vipgame.vo.LinkInfo;
import com.xunlei.niux.manager.web.cache.GameCache;
import com.xunlei.niux.manager.web.util.FreemarkerUtil;
import org.apache.commons.collections.MapUtils;

import java.util.*;
import java.util.concurrent.Callable;

/**
 * Created by jamesjxin on 14-9-23.
 */
public class GameJiaChengBuilder implements Callable{

    private String inputPath;
    private String outputPath;
    private boolean isPreview;
    private Map<String,Map<String,Object>> gameOrderMap;

    public GameJiaChengBuilder(String inputPath, String outputPath, boolean isPreview) {
        this.inputPath = inputPath;
        this.outputPath = outputPath;
        this.isPreview = isPreview;
        this.gameOrderMap = new HashMap<String,Map<String,Object>>();
    }

    @Override
    public Object call() throws Exception {
        Map<String, Object> rootMap = new HashMap<String, Object>();
        rootMap.put("gameRewardList", getGameRewardList());
        rootMap.put("gameOrderList", getGameOrderList());
        rootMap.put("recommendGameList", JinZuanUtil.getRecommendGameList("673"));

        FreemarkerUtil.buildHtml(inputPath, "gamereward.html", rootMap, outputPath, "gamereward.html");
        return "";
    }

    private List<Map<String, Object>> getGameRewardList(){
        List<Map<String,Object>> result = new ArrayList<Map<String,Object>>();
        LinkInfo li = new LinkInfo();
        li.setLinklocid("674");
        li.setIstest(isPreview);
        Page page=new Page();
        page.addOrder("displaysort", OrderType.DESC);
        List<LinkInfo> lilist= FacadeFactory.INSTANCE.getLinkInfoBo().find(li,page);
        if(lilist == null||lilist.size()==0)return null;
        for(LinkInfo info:lilist){
            Map<String,Object> map = new HashMap<String,Object>();
            map.put("id", info.getLinkid());
            map.put("title", info.getLinktitle());
            map.put("content", info.getLinkdesc());
            map.put("img", info.getPicurl());
            map.put("gameId",info.getGameid());
            map.put("level", info.getExt1());
            map.put("baseNum", info.getExt2());
            result.add(map);

            String gameId = info.getGameid();
            Games game = GameCache.getInstance().getGameByGameId(gameId);

            map.put("gameId",game==null?"":game.getGameId());

            if(game!=null && !gameOrderMap.containsKey(game.getGameId())){
                Map<String,Object> orderMap = new HashMap<String, Object>();
                orderMap.put("gameId",game==null?"":game.getGameId());
                orderMap.put("gameNo",game==null?"":game.getGameNo());
                orderMap.put("gameName",game==null?"":game.getGameName());
                orderMap.put("simpleName",game==null?"":game.getSimpleName());
                gameOrderMap.put(game.getGameId(), orderMap);
            }

        }
        return result;
    }

    private List<Map<String, Object>> getGameOrderList(){
        if(MapUtils.isEmpty(gameOrderMap)){
            return new ArrayList<Map<String, Object>>();
        }
        List<Map<String,Object>> gameOrderList =new ArrayList<Map<String, Object>>(gameOrderMap.values());

        Collections.sort(gameOrderList, new Comparator<Map<String, Object>>() {
            @Override
            public int compare(Map<String, Object> map1, Map<String, Object> map2) {
                return map1.get("simpleName").toString().compareToIgnoreCase(map2.get("simpleName").toString());
            }
        });
        return gameOrderList;
    }
}
