package com.xunlei.niux.manager.template.builder.jinzuan;

import com.xunlei.niux.client.jinzuan.PrivilegeClient;
import com.xunlei.niux.client.jinzuan.dto.PrivilegeDTO;
import com.xunlei.niux.data.jinzuan.enums.PrivilegeType;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.data.vipgame.vo.LinkInfo;
import com.xunlei.niux.manager.web.cache.GameCache;
import com.xunlei.niux.manager.web.util.FreemarkerUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.log4j.Logger;

import java.util.*;
import java.util.concurrent.Callable;

/**
 * Created by jamesjxin on 14-3-25.
 */
public class FirstPayAndBonusExchangePageBuilder implements Callable {

    private static final Logger logger = Logger.getLogger(FirstPayAndBonusExchangePageBuilder.class);
    private String inputPath;
    private String outputPath;
    private boolean isPreview;

    public FirstPayAndBonusExchangePageBuilder(String inputPath, String outputPath, boolean isPreview) {
        this.inputPath = inputPath;
        this.outputPath = outputPath;
        this.isPreview = isPreview;
    }

    @Override
    public Object call() throws Exception {
        buildFirstPayPage();
        buildBonusExchangePage();
        return "";
    }

    /**
     * @see  com.xunlei.niux.manager.template.builder.jinzuan.BoxBuilder
     */
    void buildFirstPayPage() {
        Map<String, Object> rootMap = new HashMap<String, Object>();
        rootMap.put("exchangeGameList", getGameList("668"));
        rootMap.put("exchangeCount", getAllPrivilegeCount(PrivilegeType.FreeFirstGamePay));

        FreemarkerUtil.buildHtml(inputPath, "firstpay.html", rootMap, outputPath, "firstpay.html");
    }

    /**
     * @see com.xunlei.niux.manager.template.builder.jinzuan.BoxBuilder
     */
    void buildFreeCoinPage() {
        Map<String, Object> rootMap = getBonusExchangePageData();
        FreemarkerUtil.buildHtml(inputPath, "freecoin.html", rootMap, outputPath, "freecoin.html");
    }

    private Map<String, Object> getBonusExchangePageData(){
        Map<String, Object> rootMap = new HashMap<String, Object>();
        rootMap.put("exchangeGameList", getGameList("669"));
        rootMap.put("exchangeCount", getAllPrivilegeCount(PrivilegeType.BonusExchangeCoin));

        return rootMap;
    }

    @Deprecated
    private void buildBonusExchangePage() {
        Map<String, Object> rootMap = new HashMap<String, Object>();
        rootMap.put("exchangeGameList", getGameList("669"));
        rootMap.put("exchangeCount", getAllPrivilegeCount(PrivilegeType.BonusExchangeCoin));

        FreemarkerUtil.buildHtml(inputPath, "freecoin.html", rootMap, outputPath, "freecoin.html");
        FreemarkerUtil.buildHtml(inputPath, "redpacket.html", rootMap, outputPath, "redpacket.html");
    }

    private List<Map<String, Object>> getGameList(String linklocId) {
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();

        LinkInfo query = new LinkInfo();
        query.setLinklocid(linklocId);
        List<LinkInfo> linkinfoList = FacadeFactory.INSTANCE.getLinkInfoBo().find(query);
        if (CollectionUtils.isEmpty(linkinfoList)) {
            return list;
        }

        for (LinkInfo linkInfo : linkinfoList) {
            String gameid = linkInfo.getGameid();
            Games game = GameCache.getInstance().getGameByGameId(gameid);
            if (game == null) {
                continue;
            }

            Map<String, Object> map = new HashMap<String, Object>();
            map.put("gameId", gameid);
            map.put("gameNo", game.getGameNo() == null ? "" : game.getGameNo());
            map.put("gameName", game.getGameName() == null ? "" : game.getGameName());
            map.put("simpleName", game.getSimpleName() == null ? "" : game.getSimpleName());
            list.add(map);
        }

        Collections.sort(list,new Comparator<Map<String, Object>>() {
            @Override
            public int compare(Map<String, Object> map1, Map<String, Object> map2) {
                return map1.get("simpleName").toString().compareToIgnoreCase(map2.get("simpleName").toString());
            }
        });

        return list;
    }

    public Map<String, Object> getAllPrivilegeCount(PrivilegeType privilegeType) {
        Map<String, Object> resultMap = new HashMap<String, Object>();

        Map<String, Object> map = PrivilegeClient.getPrivilegeLevelInfo(privilegeType);
        int code = Integer.parseInt(map.get("code").toString());
        Object obj = map.get("data");
        if (code != 0) {
            logger.error("getPrivilegeLevelInfo get wrong result: " + map.toString());
            return resultMap;
        }

        List<PrivilegeDTO> privilegeDTOList = (List<PrivilegeDTO>) obj;
        if (CollectionUtils.isEmpty(privilegeDTOList)) {
            return resultMap;
        }

        List<Long> annualList = new ArrayList<Long>();
        List<Long> notAnnualList = new ArrayList<Long>();

        Collections.sort(privilegeDTOList, new Comparator<PrivilegeDTO>() {
            @Override
            public int compare(PrivilegeDTO o1, PrivilegeDTO o2) {
                return o1.getLevelNum() - o2.getLevelNum();
            }
        });

        for (PrivilegeDTO privilegeDTO : privilegeDTOList) {
            if (privilegeDTO.getIsAnnual() == 0) {
                notAnnualList.add(privilegeDTO.getValue());
            } else {
                annualList.add(privilegeDTO.getValue());
            }
        }

        resultMap.put("annual", annualList);
        resultMap.put("noAnnual", notAnnualList);

        return resultMap;
    }

}
