package com.xunlei.niux.manager.template.builder.jinzuan;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.active.dto.commonactivity.ActivityExtendInfoDTO;
import com.xunlei.niux.data.active.dto.commonactivity.ActivityGiftInfoDTO;
import com.xunlei.niux.data.active.vo.commonactivity.ActivityExtendInfo;
import com.xunlei.niux.data.active.vo.commonactivity.ActivityGiftInfo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.data.vipgame.vo.LinkInfo;
import com.xunlei.niux.data.vipgame.vo.gift.Gift;
import com.xunlei.niux.manager.template.builder.AbstractTemplateBuilder;
import com.xunlei.niux.manager.web.util.FreemarkerUtil;
import org.apache.log4j.Logger;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.xunlei.niux.manager.web.cache.GameCache;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * 盒子专属页面模板生成
 * Created by ljm on 15-5-27.
 */
public class BoxBuilder  extends AbstractTemplateBuilder {
    private static final Logger logger = Logger.getLogger(BoxBuilder.class);
    private static final DateFormat sdf_time = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private String inputPath;
    private String outputPath;
    private boolean isPreview;

    @Override
    public void executeShcema() throws Exception {
        this.inputPath = htmlTemplate.getTemplateroot();
        this.outputPath = isPreView?htmlTemplate.getPreviewhtmlroot():htmlTemplate.getHtmlroot();
        this.isPreview = isPreView;
        

        String templateId = htmlTemplate.getTemplateid();
        logger.info(templateId+" BoxBuilder: start!");
        
        Map<String, Object> rootMap = new HashMap<String, Object>();
        rootMap.put("boxLunBoList", getLunBoList());
        rootMap.put("boxAdvSlotList", getAdvSlotList());
        rootMap.put("boxTuiJianPrivilegeList", getTuiJianPrivilegeList());
        rootMap.put("boxGiftList", getGiftList());
        rootMap.put("boxJiaChengList", getJiaChengList());
        rootMap.put("boxHotActivityList", getHotActivityList());

        FreemarkerUtil.buildHtml(inputPath, "boxvip.html", rootMap, outputPath, "boxvip.html");

        FirstPayAndBonusExchangePageBuilder payBuilder = new FirstPayAndBonusExchangePageBuilder(inputPath, outputPath, isPreview);
        payBuilder.buildFirstPayPage();
        payBuilder.buildFreeCoinPage();

        Map<String, Object> rootMap2 = new HashMap<String, Object>();
        rootMap2.put("channelProductList", getChannelProductList("qudaolibao"));
        FreemarkerUtil.buildHtml(inputPath, "channel_gift.html", rootMap2, outputPath, "channel_gift.html");


    }

    /**
     * 轮播图
     * @return
     */
    private List<Map<String, Object>> getLunBoList(){
    	return getList("401");
    }
    
    /**
     * 广告位
     * @return
     */
    private List<Map<String, Object>> getAdvSlotList(){
    	return getList("402");
    }
    
    /**
     * 推荐特权
     * @return
     */
    private List<Map<String, Object>> getTuiJianPrivilegeList(){
    	return getList("403");
    }
    
    /**
     * 专属礼包
     * @return
     */
    private List<Map<String, Object>> getGiftList(){
    	return getList("404");
    }
    
    /**
     * 游戏加成
     * @return
     */
    private List<Map<String, Object>> getJiaChengList(){
    	return getList("405");
    }
    
    /**
     * 热门活动
     * @return
     */
    private List<Map<String, Object>> getHotActivityList(){
    	return getList("406");
    }
    
    private List<Map<String, Object>> getList(String linklocid){
    	List<Map<String,Object>> result = new ArrayList<Map<String,Object>>();
    	LinkInfo li = new LinkInfo();
    	li.setLinklocid(linklocid);
    	li.setIstest(isPreview);
    	Page page=new Page();
    	page.addOrder("displaysort", OrderType.DESC);
    	List<LinkInfo> lilist= FacadeFactory.INSTANCE.getLinkInfoBo().find(li,page);
    	if(lilist == null||lilist.size()==0)return null;
    	for(LinkInfo info:lilist){
    		Map<String,Object> map = new HashMap<String,Object>();
    		map.put("id", info.getLinkid());
    		map.put("title", info.getLinktitle());
    		map.put("desc", info.getLinkdesc());
    		map.put("content", info.getLinkurl());
    		map.put("img", info.getPicurl());
    		map.put("isbig", info.getIsredtitle());//是否大图
    		result.add(map);
    	}
    	return result;
    }



    public List<Map<String, Object>> getChannelProductList(String srcActNo) {

        List<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        Map<String,ActivityExtendInfoDTO> activityMap = getActivityMap(srcActNo);

        ActivityGiftInfo query = new ActivityGiftInfo();
        query.setActNo(srcActNo);
        query.setIsValid(true);
        List<ActivityGiftInfoDTO>  actGiftList = com.xunlei.niux.data.active.facade.FacadeFactory.INSTANCE
                .getActivityGiftBo().getActivityGiftList(query);

        if(CollectionUtils.isEmpty(actGiftList)){
            return null;
        }

        for(ActivityGiftInfoDTO activityGiftInfoDTO : actGiftList){
            String moduleId = activityGiftInfoDTO.getModuleId();
            if(StringUtils.isEmpty(moduleId)){
                continue;
            }

            if(!activityMap.containsKey(moduleId)){
                continue;
            }


            ActivityExtendInfoDTO activityDTO = activityMap.get(moduleId);
            if(activityDTO == null){
                continue;
            }

            int giftId = activityGiftInfoDTO.getGiftId();
            Gift gift = getGiftByGiftId(giftId);
            if(gift == null){
                continue;
            }

            Map<String,Object> map = new HashMap<String, Object>();

            map.put("moduleId",moduleId);
            map.put("giftId",giftId);
            map.put("giftType",gift.getGiftType());
            map.put("giftName",gift.getGiftName());
            map.put("price", gift.getProductTotalPrice() == null ? 0 : gift.getProductTotalPrice());
            map.put("photo_list",activityGiftInfoDTO.getPhoto()==null?"":activityGiftInfoDTO.getPhoto());
            map.put("photo_left",activityGiftInfoDTO.getSmallPic()==null?"":activityGiftInfoDTO.getSmallPic());
            map.put("photo_index1",activityGiftInfoDTO.getExt1()==null?"":activityGiftInfoDTO.getExt1());
            map.put("photo_index2",activityGiftInfoDTO.getExt2()==null?"":activityGiftInfoDTO.getExt2());
            map.put("vipLevel",activityDTO.getJinkaLevelLimit());
            map.put("validPeriod",StringUtils.isEmpty(activityDTO.getEndTime())?"":activityDTO.getEndTime());
            map.put("desc",gift.getSimpleDesc());
            map.put("detailUrl",activityGiftInfoDTO.getDetailUrl()==null?"":activityGiftInfoDTO.getDetailUrl());
            String rule = gift.getExt1()==null?"":gift.getExt1();
            rule = rule.replaceAll("\\n","").replaceAll("\\|","<br>");
            map.put("rule",rule);

            String gameId = gift.getGameId();
            Games game = GameCache.getInstance().getGameByGameId(gameId);

            map.put("gameId",game==null?"":game.getGameId());

            resultList.add(map);
        }

        return resultList;
    }
    private Map<String,ActivityExtendInfoDTO> getActivityMap(String actNo){
        Map<String,ActivityExtendInfoDTO> resultMap = new HashMap<String, ActivityExtendInfoDTO>();
        ActivityExtendInfo query = new ActivityExtendInfo();
        query.setActNo(actNo);

        List<ActivityExtendInfoDTO> list = com.xunlei.niux.data.active.facade.FacadeFactory.INSTANCE
                .getActivityExtendBo().getActivityInfoList(actNo);

        if(CollectionUtils.isEmpty(list)){
            return resultMap;
        }

        Date now = new Date();
        for(ActivityExtendInfoDTO activityDTO : list){
            if(StringUtils.isEmpty(activityDTO.getModuleId())){
                continue;
            }
            if(StringUtils.isNotEmpty(activityDTO.getStartTime())){
                try {
                    Date startTime = sdf_time.parse(activityDTO.getStartTime());
                    if(startTime.after(now)){
                        continue;
                    }
                } catch (ParseException e) {
                    logger.error("日期格式转化错误",e);
                }
            }

            if(StringUtils.isNotEmpty(activityDTO.getEndTime())){
                try {
                    Date endTime = sdf_time.parse(activityDTO.getEndTime());
                    if(endTime.before(now)){
                        continue;
                    }
                } catch (ParseException e) {
                    logger.error("日期格式转化错误",e);
                }
            }

            resultMap.put(activityDTO.getModuleId(),activityDTO);
        }
        return resultMap;
    }

    private Gift getGiftByGiftId(int giftId){
        Gift query = new Gift();
        query.setGiftId((long)giftId);
        query.setIsValid(true);

        List<Gift> giftList = com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getBaseSo().findObjects(query, new Page());

        if(CollectionUtils.isEmpty(giftList)){
            return null;
        }
        return giftList.get(0);
    }



}
