package com.xunlei.niux.manager.template.builder.jinzuan;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import com.xunlei.niux.client.jinzuan.PrivilegeClient;
import com.xunlei.niux.client.jinzuan.dto.PrivilegeDTO;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.LinkInfo;
import com.xunlei.niux.manager.constant.LinkLocationIdConstant;
import com.xunlei.niux.manager.web.util.FreemarkerUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.log4j.Logger;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;

/**
 * Created by jamesjxin on 14-3-25.
 */
public class AllServiceInfoBuilder implements Callable {
    private static final Logger logger = Logger.getLogger(AllServiceInfoBuilder.class);
    private String inputPath;
    private String outputPath;
    private boolean isPreview;

    public AllServiceInfoBuilder(String inputPath, String outputPath, boolean isPreview) {
        this.inputPath = inputPath;
        this.outputPath = outputPath;
        this.isPreview = isPreview;
    }

    @Override
    public Object call() throws Exception {
        buildAllServiceInfo();
        logger.info("buildAllServiceInfo done!");

        buildMorePrivelegePage();
        logger.info("buildMorePrivelegePage done!");
        return "";
    }

    private void buildAllServiceInfo() {
        Map<String, Object> rootMap = new HashMap<String, Object>();
        rootMap.put("allServiceList", getAllServiceList());
        FreemarkerUtil.buildHtml(inputPath + "/include", "allServiceInfo.html", rootMap, outputPath + "/include", "allServiceInfo.html");
    }

    private void buildMorePrivelegePage() {
        Map<String, Object> rootMap = new HashMap<String, Object>();
        rootMap.put("moreServiceList", getMoreServiceList());
        FreemarkerUtil.buildHtml(inputPath, "more.html", rootMap, outputPath, "more.html");
        FreemarkerUtil.buildHtml(inputPath, "me.html", rootMap, outputPath, "me.html");
    }

    private List<Map<String, Object>> getAllServiceList() {

        logger.info("开始获取AllPrivilegeInfo");
        String resultresp = PrivilegeClient.getAllPrivilegeInfo();

        JsonObject jsonObject = new JsonParser().parse(resultresp).getAsJsonObject();
        int rtnCode = jsonObject.get("rtn").getAsInt();

        if (rtnCode != 0) {
            String msg = jsonObject.get("data").getAsString();
            logger.error("调用PrivilegeClient错误：" + msg);
            return null;
        }

        Gson gson = new Gson();
        Type type = new TypeToken<List<PrivilegeDTO>>(){}.getType();
        List<PrivilegeDTO> priList = gson.fromJson(jsonObject.get("data"), type);

        if (CollectionUtils.isEmpty(priList)) {
            return null;
        }

        List<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        for (PrivilegeDTO privilegeDTO : priList) {
            Map<String, Object> map = new HashMap<String, Object>();
            map.put("key", privilegeDTO.getSimpleName() == null ? "" : privilegeDTO.getSimpleName());
            map.put("name", privilegeDTO.getPrivilegeDesc() == null ? "" : privilegeDTO.getPrivilegeDesc());
            resultList.add(map);
        }

        return resultList;
    }

    private List<Map<String, Object>> getMoreServiceList() {
        List<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        List<LinkInfo> lilist = FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoListByLinkLocId_V2(LinkLocationIdConstant.NIUX_JINZUAN_MOREPRIVILEGE, 30, isPreview);
        if (lilist == null || lilist.size() == 0) return null;
        for (LinkInfo info : lilist) {
            Map<String, Object> map = new HashMap<String, Object>();
            map.put("title", info.getLinktitle() == null ? "" : info.getLinktitle());
            map.put("content", info.getLinkdesc() == null ? "" : info.getLinkdesc());
            map.put("img", info.getPicurl() == null ? "" : info.getPicurl());

            result.add(map);
        }
        return result;
    }
}
