package com.xunlei.niux.manager.template.builder.jinzuan;

import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.Advice;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.manager.web.util.FreemarkerUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

import java.text.SimpleDateFormat;
import java.util.*;
import java.util.concurrent.Callable;

/**
 * Created by jamesjxin on 14-3-20.
 */
public class AdviceListPageBuilder implements Callable{
    private static final Logger logger = Logger.getLogger(AdviceListPageBuilder.class);
    private static SimpleDateFormat sdf_time = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private String inputPath;
    private String outputPath;
    private boolean isPreview;

    public AdviceListPageBuilder(String inputPath, String outputPath, boolean isPreview) {
        this.inputPath = inputPath;
        this.outputPath = outputPath;
        this.isPreview = isPreview;
    }

    @Override
    public Object call() throws Exception {
        Map<String, List<Advice>> resultMap = getActivityAndActList();
        if (MapUtils.isEmpty(resultMap)) {
            return "";
        }
//        List<Advice> activityList = resultMap.get("activity");
        List<Advice> adviceList = resultMap.get("advice");

//        if(CollectionUtils.isNotEmpty(activityList)){
//            buildAdviceListPages(activityList,"act");
//        }
        if (CollectionUtils.isNotEmpty(adviceList)) {
            buildAdviceListPages(adviceList, "gg");
        }
        return "";
    }

    private void buildAdviceListPages(List<Advice> adviceList,String noticeType){
        int pageSize = 20;
        int pageCount = 0;

        List<Advice> printList = new ArrayList<Advice>();
        if(CollectionUtils.isNotEmpty(adviceList)){
            int totalCount = adviceList.size();
            int pageIndex = 0;
            if(totalCount%pageSize == 0){
                pageCount = totalCount/pageSize;
            }else {
                pageCount = totalCount/pageSize + 1;
            }
            String path = "/notice/";

            int startindex = 0, endIndex = 0;
            for(int i=0;i<pageCount;i++){
                startindex = i*pageSize;
                endIndex = (((i+1)*pageSize) > totalCount) ? totalCount : ((i+1)*pageSize);
                printList = adviceList.subList(startindex,endIndex);

                Map<String, Object> rootMap = new HashMap<String, Object>();
                rootMap.put("noticeType",noticeType);
                rootMap.put("articleList",getNoticeMapList(printList));
                rootMap.put("pageInfo", getPageInfoMap(pageCount,pageIndex+1));

//                String root = "/Users/jamesjxin/Work/XL工作目录/20131219官网1.2.2/模版/niuofficial/";
//                String roothtml = "/Users/jamesjxin/Work/XL工作目录/20131219官网1.2.2/模版/niuofficial/";
                pageIndex++;
                FreemarkerUtil.buildHtml(inputPath, "articleList.html", rootMap,
                        outputPath+path, String.valueOf(pageIndex) + ".html");
            }
        }



    }

    private Map<String,List<Advice>> getActivityAndActList(){
        Map<String,List<Advice>> resultMap = new HashMap<String, List<Advice>>();
        String sql = "select * from advice where platformno != 'question' and adviceType = '4' order by publishDate desc";
        List<Advice> list = FacadeFactory.INSTANCE.getAdviceBo().executeQuery(
                Advice.class, sql, new ArrayList());
        logger.info("getAdviceAdv.size=====================>" + list.size());

        if(CollectionUtils.isEmpty(list)){
            return resultMap;
        }

//        List<Advice> activityList = new ArrayList<Advice>();
//        List<Advice> adviceList = new ArrayList<Advice>();
//        for(Advice advice : list){
//            if(advice.getPlatformno().equals("activity")||advice.getPlatformno().equals("gameact")){
//                activityList.add(advice);
//            }else {
//                adviceList.add(advice);
//            }
//        }

//        resultMap.put("activity",activityList);
        resultMap.put("advice",list);

        return resultMap;
    }

    private List<Map<String,Object>> getNoticeMapList(List<Advice> adviceList){
        List<Map<String,Object>> resultList = new ArrayList<Map<String, Object>>();
        if(CollectionUtils.isEmpty(adviceList)){
            return resultList;
        }
        for(Advice advice : adviceList){
            Map<String,Object> map = new HashMap<String,Object>();
            String gameId = advice.getGameId();

            //游戏信息
            logger.info("gameid================>" + gameId);
            Games game = FacadeFactory.INSTANCE.getGamesBo().getGameByGameId(
                    gameId);
            map.put("gameName",game==null?"":game.getGameName());
            map.put("gameId",gameId);
            map.put("gameOfficialUrl",game==null?"":game.getOfficialWebSite());
            map.put("id",advice.getSeqId()==null?"":advice.getSeqId());
            map.put("title",advice.getTitle()==null?"":advice.getTitle());
            map.put("url",advice.getJumpUrl()==null?"":advice.getJumpUrl());
            map.put("date", StringUtils.isEmpty(advice.getPublishDate()) ? "" : advice.getPublishDate().substring(0, 10));

            map.put("isColor", advice.getRed()==false ? 0 : 1);
            map.put("isStrong", advice.getBold()==false ? 0 : 1);

            resultList.add(map);
        }

        return resultList;
    }

    private Map<String,Integer> getPageInfoMap(int totalNum,int curPage){
        Map<String,Integer> map = new HashMap<String, Integer>();
        map.put("totalNum",totalNum);
        map.put("curPage",curPage);
        return map;
    }
}
