package com.xunlei.niux.manager.template.builder.jinka;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.xunlei.common.facade.FacadeCommonImpl;
import com.xunlei.common.facade.IFacadeCommon;
import com.xunlei.common.vo.LibClassD;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.BonusProduct;
import com.xunlei.niux.data.vipgame.vo.CustomerGrade;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.data.vipgame.vo.LinkInfo;
import com.xunlei.niux.manager.template.builder.AbstractTemplateBuilder;
import com.xunlei.niux.manager.web.cache.GameCache;
import com.xunlei.niux.manager.web.util.FileUtil;
import com.xunlei.niux.manager.web.util.FreemarkerUtil;

public class JinKaBuilder extends AbstractTemplateBuilder {

	@Override
	public void executeShcema() throws Exception {
		Map<String,Object> rootMap=new HashMap<String,Object>();
		rootMap.put("sliderImgList", getsliderImgList());
		rootMap.put("vipAnnouncementList",getvipAnnouncementList());
		rootMap.put("adList",getAdvList());
		List<Map<String,Object>> jinkatequanlist=getJinKaTeQuan();
		Map<String,Object> gradeinfomap=getVIP_GRADE_INFOMap();
		rootMap.put("actList", getactList());
		rootMap.put("discountMap", getdiscountMap());
		rootMap.put("serviceList", getserviceList());
		rootMap.put("productList", getProductList());
		String htmlFilePath=isPreView?htmlTemplate.getPreviewhtmlroot():htmlTemplate.getHtmlroot();
		if(htmlFilePath.endsWith("/")){
			htmlFilePath=htmlFilePath.substring(0, htmlFilePath.length()-1);
		}
		FreemarkerUtil
		.buildHtml(htmlTemplate.getTemplateroot(),
				"vip.html", rootMap, htmlFilePath,
				"vip.html");
		FreemarkerUtil
		.buildHtml(htmlTemplate.getTemplateroot(),
				"vip_prize.html", rootMap, htmlFilePath,
				"vip_prize.html");
		FreemarkerUtil
		.buildHtml(htmlTemplate.getTemplateroot(),
				"vip_activity.html", rootMap, htmlFilePath,
				"vip_activity.html");
		FreemarkerUtil
		.buildHtml(htmlTemplate.getTemplateroot(),
				"vip_service.html", rootMap, htmlFilePath,
				"vip_service.html");
		FreemarkerUtil
		.buildHtml(htmlTemplate.getTemplateroot() + "/include",
				"vip_side.html", rootMap, htmlFilePath+"/include",
				"vip_side.html");
//		FreemarkerUtil
//		.buildHtml(htmlTemplate.getTemplateroot() + "/include",
//				"vip_sliderImg.html", rootMap, htmlFilePath+"/include",
//				"vip_sliderImg.html");
		String jsonStr=JsonObjectUtil.getDataJsonObject(jinkatequanlist);
		jsonStr="var VIP_SERVICE_INFO ="+jsonStr+";";
		jsonStr=jsonStr+"var  VIP_GRADE_INFO="+JsonObjectUtil.getDataJsonObject(gradeinfomap)+";";

        String niuOfficialJsPath = IFacadeCommon.INSTANCE.getLibconfigValueByConfigNo("niuOfficialJsPath");
        if (niuOfficialJsPath.endsWith("/")) {
            niuOfficialJsPath = niuOfficialJsPath.substring(0, niuOfficialJsPath.length() - 1);
        }

	    File file=FileUtil.createFile(niuOfficialJsPath+"/gamedata", "vip_grade_service_info.js");
	    FileUtil.writeByChar(file, jsonStr);
	}
	public List<Map<String,Object>> getProductList(){
		List<Map<String,Object>> list=new ArrayList<Map<String,Object>>();
		List<LinkInfo> lilist=FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoListByLinkLocId_V2("1263", 200, isPreView);
		for(LinkInfo li:lilist){
			BonusProduct product = FacadeFactory.INSTANCE.getBonusProductBo().findBonusProductById(Long.parseLong(li.getLinktitle()));
			if(product==null){
				continue;
			}
			Map<String,Object> map=new HashMap<String,Object>();
			map.put("productNo", product.getProductNo());
			map.put("productName", product.getProductName());
			map.put("photo", li.getPicurl()==null?"":li.getPicurl());
			map.put("watermark", li.getSmallpicurl()==null?"":li.getSmallpicurl());
			map.put("vipLevel", product.getMinJinKaLevel()==null?0:product.getMinJinKaLevel());
			map.put("pid",product.getSeqId());
			map.put("validPeriod", product.getValidPeriod()==null?"":product.getValidPeriod().substring(0, 10));
			map.put("desc", li.getLinkdesc()==null?"":li.getLinkdesc());
			map.put("minGameLevel", product.getMinGameLevel()==null?0:product.getMinGameLevel());
			map.put("giveOutType", product.getGiveOutType()==null?"":product.getGiveOutType());
			map.put("gameId", product.getGameId()==null?"":product.getGameId());
			Games game=GameCache.getInstance().getGameByGameId(product.getGameId());
			map.put("gameName", game==null?"":game.getGameName());
			map.put("isSelectServer", (product.getIsQuFenServer()!=null&&product.getIsQuFenServer())?"1":"0");
			map.put("vipPrice", product.getVipPrice()==null?"":product.getVipPrice());
			map.put("price", product.getPrice()==null?"":product.getPrice());
			map.put("exchangeDirect", product.getExchangeDirect()==null?"":product.getExchangeDirect());
			list.add(map);
		}
		return list;
	}
	public List<Map<String,Object>> getJinKaTeQuan(){
		List<Map<String,Object>> list=new ArrayList<Map<String,Object>>();
		List<LibClassD> libclasslist=FacadeCommonImpl.INSTANCE.getLibClassDByClassNo("JinKaTeQuan");
		for(LibClassD cz:libclasslist){
			Map<String,Object> map=new HashMap<String,Object>();
			map.put("id", cz.getItemno()+"");
			map.put("name", cz.getItemname()+"");
			list.add(map);
		}
		return list;
	}
	public List<Map<String,Object>> getserviceList(){
		List<Map<String,Object>> list=new ArrayList<Map<String,Object>>();
		Map<String,Object> tequanMap=new HashMap<String,Object>();
		//获取所有的等级
		List<CustomerGrade> datas = FacadeFactory.INSTANCE.getCustomerGradeBo().findCustomerGradeList();
		//获取等级
		List<LinkInfo> tequanlist=FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoListByLinkLocId_V2("265", 200, isPreView);
		Set<String> tequanSet=new HashSet<String>();
		for(LinkInfo li:tequanlist){
			tequanSet.add(li.getExt1()+"-"+li.getExt2());
		}
		//所有的特权
		List<LibClassD> libclasslist=FacadeCommonImpl.INSTANCE.getLibClassDByClassNo("JinKaTeQuan");
		for(LibClassD cz:libclasslist){
			//遍历特权
			Map<String,Object> tmap=new HashMap<String,Object>();
			tmap.put("name", cz.getItemname());
			tmap.put("id",cz.getItemno());
			tmap.put("desc",cz.getRemark()==null?"":cz.getRemark());
			Map<String,Object> tmap2=new HashMap<String,Object>();
			for(CustomerGrade cg:datas){
				if(tequanSet.contains(cg.getVipGrade()+"-"+cz.getItemno())){
					tmap2.put("v"+cg.getVipGrade(), 1);
				}else{
					tmap2.put("v"+cg.getVipGrade()+"", 0);
				}
			}
			tmap.put("vipMap", tmap2);
			list.add(tmap);
		}
		return list;
	}
	public Map<String,String> getdiscountMap(){
		Map<String,String> map=new HashMap<String,String>();
		Map<String,String> zheKouMap=getVipZheKouMap();
		List<CustomerGrade> datas = FacadeFactory.INSTANCE.getCustomerGradeBo().findCustomerGradeList();
		for(CustomerGrade cg:datas){
			map.put("v"+cg.getVipGrade(),zheKouMap.get(cg.getVipGrade()+"")==null?"":zheKouMap.get(cg.getVipGrade()+""));
		}
		return map;
	}
	public List<Map<String,Object>> getsliderImgList(){
		List<Map<String,Object>> list=new ArrayList<Map<String,Object>>();
		List<LinkInfo> lilist=FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoListByLinkLocId_V2("261", 3, isPreView);
		for(LinkInfo li:lilist){
			Map<String,Object> map=new HashMap<String,Object>();
			map.put("url", (li.getLinkurl()==null)?"":li.getLinkurl());
			map.put("img", (li.getPicurl()==null)?"":li.getPicurl());
			list.add(map);
		}
		return list;
	}
	public List<Map<String,Object>> getAdvList(){
		List<Map<String,Object>> list=new ArrayList<Map<String,Object>>();
		List<LinkInfo> lilist=FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoListByLinkLocId_V2("262", 2, isPreView);
		for(LinkInfo li:lilist){
			Map<String,Object> map=new HashMap<String,Object>();
			map.put("url", (li.getLinkurl()==null)?"":li.getLinkurl());
			map.put("img", (li.getPicurl()==null)?"":li.getPicurl());
			list.add(map);
		}
		return list;
	}
	public List<Map<String,Object>> getvipAnnouncementList(){
		List<Map<String,Object>> list=new ArrayList<Map<String,Object>>();
		List<LinkInfo> lilist=FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoListByLinkLocId_V2("263", 10, isPreView);
		for(LinkInfo li:lilist){
			Map<String,Object> map=new HashMap<String,Object>();
			Games games=GameCache.getInstance().getGameByGameId(li.getGameidbytuijian());
			if(games==null){
				map.put("gameName","");
				map.put("gameOfficialUrl", "");	
			}else{
				map.put("gameName", games.getGameName());
				map.put("gameOfficialUrl", games.getOfficialWebSite());	
			}
			map.put("url", (li.getLinkurl()==null)?"":li.getLinkurl());
			map.put("title", (li.getLinktitle()==null)?"":li.getLinktitle());
			map.put("date", (li.getValiddatetime()==null)?"":li.getValiddatetime().substring(5, 10));
			list.add(map);
		}
		return list;
	}
	public Map<String,Object> getVIP_GRADE_INFOMap(){
		Map<String,Object> rmap=new HashMap<String,Object>();
		List<CustomerGrade> datas = FacadeFactory.INSTANCE.getCustomerGradeBo().findCustomerGradeList();
		Map<String,String> zheKouMap=getVipZheKouMap();
		Map<String,List<String>> tequanmap=getTeQuanList();
		Map<String,List<Map<String,Object>>> customerMap=getCustomerList();
		Map<String,List<Map<String,Object>>> customerMangerMap=getCustomerManagerList();
		for(CustomerGrade cg:datas){
			Map<String,Object> map=new HashMap<String,Object>();
			map.put("name", "VIP"+cg.getVipGrade());
			map.put("discount",zheKouMap.get(cg.getVipGrade()+"")==null?"":zheKouMap.get(cg.getVipGrade()+""));
			map.put("service", tequanmap.get(cg.getVipGrade()+"")==null?new ArrayList<String>():tequanmap.get(cg.getVipGrade()+""));
			map.put("kf", customerMap.get(cg.getVipGrade()+"")==null?new ArrayList<Map<String,Object>>():customerMap.get(cg.getVipGrade()+""));
			map.put("dkhjl", customerMangerMap.get(cg.getVipGrade()+"")==null?new ArrayList<Map<String,Object>>():customerMangerMap.get(cg.getVipGrade()+""));
			rmap.put("v"+cg.getVipGrade(), map);
		}
		return rmap;
	}
	public Map<String,List<String>> getTeQuanList(){
		Map<String,List<String>> map=new HashMap<String,List<String>>();
		List<LinkInfo> lilist=FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoListByLinkLocId_V2("265", 200, isPreView);
		for(LinkInfo li:lilist){
			List<String> tlist=map.get(li.getExt1());
			tlist=tlist==null?new ArrayList<String>():tlist;
			tlist.add(li.getExt2()+"");
			map.put(li.getExt1(), tlist);
		}
		return map;
	}
	public Map<String,String> getVipZheKouMap(){
		Map<String,String> map=new HashMap<String,String>();
		List<LinkInfo> lilist=FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoListByLinkLocId_V2("266", 100, isPreView);
		for(LinkInfo li:lilist){
			map.put(li.getExt1(), li.getExt2());
		}
		return map;
	}
	public Map<String,List<Map<String,Object>>> getCustomerList(){
		Map<String,List<Map<String,Object>>> map=new HashMap<String,List<Map<String,Object>>>();
		List<LinkInfo> lilist=FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoListByLinkLocId_V2("264", 200, isPreView);
		for(LinkInfo li:lilist){
			List<Map<String,Object>> tlist=map.get(li.getExt1());
			tlist=tlist==null?new ArrayList<Map<String,Object>>():tlist;
			Map<String,Object> tmap=new HashMap<String,Object>();
			tmap.put("name", li.getLinktitle()==null?"":li.getLinktitle());
			tmap.put("tel", li.getExt2()==null?"":li.getExt2());
			tmap.put("qq", li.getExt3()==null?"":li.getExt3());
			tlist.add(tmap);
			map.put(li.getExt1(), tlist);
		}
		return map;
	}
	public Map<String,List<Map<String,Object>>> getCustomerManagerList(){
		Map<String,List<Map<String,Object>>> map=new HashMap<String,List<Map<String,Object>>>();
		List<LinkInfo> lilist=FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoListByLinkLocId_V2("273", 200, isPreView);
		for(LinkInfo li:lilist){
			List<Map<String,Object>> tlist=map.get(li.getExt1());
			tlist=tlist==null?new ArrayList<Map<String,Object>>():tlist;
			Map<String,Object> tmap=new HashMap<String,Object>();
			tmap.put("name", li.getLinktitle()==null?"":li.getLinktitle());
			tmap.put("tel", li.getExt2()==null?"":li.getExt2());
			tmap.put("qq", li.getExt3()==null?"":li.getExt3());
			tlist.add(tmap);
			map.put(li.getExt1(), tlist);
		}
		return map;
	}
	public List<Map<String,Object>> getactList(){
		List<Map<String,Object>> list=new ArrayList<Map<String,Object>>();
		List<LinkInfo> lilist=FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoListByLinkLocId_V2("267", 100, isPreView);
		for(LinkInfo li:lilist){
			Map<String,Object> tmap=new HashMap<String,Object>();
			tmap.put("grade", li.getExt1()+"");
			tmap.put("url", li.getLinkurl()+"");
			tmap.put("img", li.getPicurl()+"");
			tmap.put("title", li.getLinktitle());
			tmap.put("duration", li.getExt2()+"到"+li.getExt3());
			tmap.put("content", li.getLinkdesc()+"");
			list.add(tmap);
		}
		return list;
	}
}
