package com.xunlei.niux.manager.template.builder.gameofficial;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.util.CollectionUtils;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.Advice;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.data.vipgame.vo.HtmlTemplate;
import com.xunlei.niux.data.vipgame.vo.LinkInfo;
import com.xunlei.niux.data.vipgame.vo.version.GameVersion;
import com.xunlei.niux.data.vipgame.vo.version.VersionInfo;
import com.xunlei.niux.manager.template.builder.AbstractTemplateBuilder;
import com.xunlei.niux.manager.web.cache.GameCache;
import com.xunlei.niux.manager.web.util.FreemarkerUtil;
import com.xunlei.util.StringTools;

/**
 * 一次生成游戏官网的文章模板
 * @author lisu
 * 2014-08-13
 */
public class GameArticleBuilder extends AbstractTemplateBuilder{
	private static final Logger logger = Logger.getLogger(GameArticleBuilder.class.getName());
	private long timestamp=0;
	private static final String regEx = "<[^>]+>"; //定义HTML标签的正则表达式
	private static final SimpleDateFormat sdf=new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

	@Override
	public void executeShcema() throws Exception {
		makeAllGameAdvice();
	}
	
	private void makeNormalAdvice() throws Exception{
		String gameId = schema.getExt1();
		String sql = null;
		List<String> list =  new ArrayList<String>();
		if(StringTools.isEmpty(gameId)){//如果是生成所有游戏的文章
			sql = "select * from advice where adviceType='3' and  content<> '' and jumpurl  like '%/a/%' ";
		}else{			
			sql = "select * from advice where adviceType='3' and gameid=? and  content<> '' and jumpurl  like '%/a/%' ";
			list.add(gameId);
		}   	
    	List<Advice> advlist = FacadeFactory.INSTANCE.getBaseSo().executeQuery(Advice.class, sql,list);
    	for(Advice adv:advlist){
    		  if (StringUtils.isNotEmpty(adv.getGameId())) {
                  Games games = GameCache.getInstance().getGameByGameId(adv.getGameId());                  
                  if (games == null || games.getClientType().intValue() == 3 || games.getClientType().intValue() == 4) {//如果是手游
                      continue;
                  }
              }
    		  String articleName = getArticeUrlName(adv);
    		  if(StringTools.isEmpty(articleName)||"null".equals(articleName))continue;//如果没有生成地址，则不需要重新生成
    		  makeArticleBuilder(adv,articleName);    
    		  logger.info("makeGameAdvice  gameid:"+gameId+", seqid:"+adv.getSeqId());
    	}
    	
	}
	
	private void makeExceptionAdvice() throws Exception{
		
	}
	
    private void makeAllGameAdvice() throws Exception{
    	makeNormalAdvice();
    	makeExceptionAdvice();
    	synch();//同步文章
    }
    
    private void synch() throws Exception{
    	logger.info("builderaarticle timestamp["+timestamp+"]id开始同步");
		execRsync(htmlTemplate);
		logger.info("builderaarticle timestamp["+timestamp+"]id完成同步");
    }
	
	 /**
     * 去掉html格式
     * @param content
     * @return
     */
    private String removeHtml(String regEx, String content){   	    
        Pattern pattern = Pattern.compile(regEx,Pattern.CASE_INSENSITIVE);    
        Matcher  matcher = pattern.matcher(content);    
        content = matcher.replaceAll(""); //过滤html标签    
    	return content;
    }
	
	
	/**
	 * 获取文章的url访问名字
	 * @param advice
	 * @return
	 */
	private String getArticeUrlName(final Advice advice){
		String contentUrl = advice.getJumpUrl();
		if(StringTools.isEmpty(contentUrl)){//如果没有生成地址
			return null;
		}
		if(contentUrl.contains("/a/")){
			return contentUrl.substring(contentUrl.lastIndexOf("/")+1);
		}
		return System.currentTimeMillis()+".shtml";
	}
   private Map<String, String> getHeadData(String gameId) {
	    Map<String,String> headMap = new HashMap<String,String>();

	    LinkInfo linkinfo = FacadeFactory.INSTANCE.getLinkInfoBo().getGameValidteLinkInfoByLinkLocId(
	      "302", gameId, false);
	    headMap.put("title", 
	      (linkinfo == null) || (linkinfo.getLinktitle() == null) ? "" : linkinfo.getLinktitle());
	    headMap.put("description", 
	      (linkinfo == null) || (linkinfo.getLinkdesc() == null) ? "" : linkinfo.getLinkdesc());
	    Games games = GameCache.getInstance().getGameByGameId(gameId);
	    headMap.put("gameName", games==null?"":games.getGameName());
	    return headMap;
	  }
   
	public void makeArticleBuilder(final Advice advice,String articleName){
		timestamp=System.currentTimeMillis();
		logger.info("builderaarticle timestamp["+timestamp+"]id["+advice.getGameId()+"开始生成");
		Games game=GameCache.getInstance().getGameByGameId(advice.getGameId());
        if(game == null){
            logger.error("gameid "+advice.getGameId()+" 对应的游戏信息不存在！");
        }
        int gameClientType = game.getClientType();

		Map<String,String> articleInfoMap=new HashMap<String,String>();
		articleInfoMap.put("typeId", advice.getPlatformno()+"");
		articleInfoMap.put("title", advice.getTitle()+"");
		articleInfoMap.put("red", advice.getRed()+"");
		articleInfoMap.put("bold", advice.getBold()+"");
		articleInfoMap.put("content", getContent(game, advice));
		articleInfoMap.put("date", advice.getPublishDate().substring(0, 10));
		
		//找出上一篇，下一篇
		Advice advicePre = null;//上一篇
		Advice adviceSur = null;//下一篇
		Advice ad = new Advice();
		try{
			ad.setGameId(advice.getGameId());
			ad.setAdviceType(advice.getAdviceType());
			Page page = new Page();
			page.addOrder("publishDate", OrderType.DESC);
			List<Advice> alladvices = FacadeFactory.INSTANCE.getAdviceBo().findAdvice(ad, page);
			int thisAdIndex = -1;
			for(int i = 0; i < alladvices.size(); i++){
				Advice adtmp = alladvices.get(i);
				if(advice.getTitle().equals(adtmp.getTitle()) && advice.getPlatformno().equals(adtmp.getPlatformno())){//找到这篇文章
					thisAdIndex = i;
					break;
				}
			}
			
			if(thisAdIndex > 0){
				adviceSur = alladvices.get(thisAdIndex - 1);
			}
			
			if(thisAdIndex < alladvices.size() - 1){
				advicePre = alladvices.get(thisAdIndex + 1);
			}
		}
		catch(Exception e){
            logger.error("gameid "+advice.getGameId()+" 对应的游戏信息不存在！",e);
		}
		articleInfoMap.put("title_sur", adviceSur == null ? "" : adviceSur.getTitle());
		articleInfoMap.put("contenturl_sur", adviceSur == null ? "" : adviceSur.getContenturl());
		articleInfoMap.put("title_pre", advicePre == null ? "" : advicePre.getTitle());
		articleInfoMap.put("contenturl_pre", advicePre == null ? "" : advicePre.getContenturl());

		logger.info("builderaarticle timestamp["+timestamp+"]id["+advice.getGameId()+",articleInfoMap:"+articleInfoMap);
			
		
		//seo标题
		String content = advice.getContent();
		content = removeHtml(regEx,content);
		if(content !=null ){
    		content = content.replaceAll("\n", "");
    		content = content.replaceAll("\r","");
    		content = content.replaceAll("\t","");
    		content = content.replaceAll("&nbsp;", "");
    		content = content.trim();
    		if(content.length()>80)
    		   content = content.substring(0,80);
    	}
		articleInfoMap.put("description", content);
		String previewhtmlFilePath=htmlTemplate.getPreviewhtmlroot();
		if(previewhtmlFilePath.endsWith("/")){
			previewhtmlFilePath=previewhtmlFilePath.substring(0, previewhtmlFilePath.length()-1);
		}
		previewhtmlFilePath=previewhtmlFilePath+"/tv3/official/"+game.getGameNo()+"/a";
		
		String htmlFilePath=htmlTemplate.getHtmlroot();
		if(htmlFilePath.endsWith("/")){
			htmlFilePath=htmlFilePath.substring(0, htmlFilePath.length()-1);
		}
		String gameBoxPath = htmlFilePath+"/tv3/official/"+game.getGameNo()+"/gamebox";
		htmlFilePath=htmlFilePath+"/tv3/official/"+game.getGameNo()+"/a";

		Map<String,Object> root=new HashMap<String,Object>();
		root.put("articleInfoMap", articleInfoMap);
		root.put("headMap", getHeadData(game.getGameId()));
		logger.info("builderaarticle timestamp["+timestamp+"]id["+advice.getGameId()+"开始生成正式模板");

        String templateFilePath = htmlTemplate.getTemplateroot();
//        if ("000180".equals(game.getGameId())){
//        	templateFilePath = templateFilePath + "_" + game.getGameNo();
//        }
//        String templateFilePath = "/Users/jamesjxin/Work/XLWork/xlniuxmanager/src/main/java/com/xunlei/niux/manager/template/builder/gameofficial";
        if(templateFilePath.endsWith("/")){
            templateFilePath = templateFilePath.substring(0,templateFilePath.length()-1);
        }
        if(gameClientType == 2 && game.getGameNo().equals("xyd")){
            templateFilePath = templateFilePath + "/" + game.getGameNo();
        }

        String versionCode = getGameVersionCode(advice.getGameId());
        if(!StringTools.isEmpty(versionCode)){
        	System.out.println("versionCode:"+versionCode);
        	if("V5".equalsIgnoreCase(versionCode)){//V3外网被简版官网占用了，V5表示游戏官网3.0
        		String gameId = advice.getGameId();
        		if(!StringTools.isEmpty(gameId)){
        			root.put("xinShouFirstArticleMap",getArticleMap("xinshou",gameId));
        			root.put("gaoShouFirstArticleMap",getArticleMap("gaoshou",gameId));
        			root.put("teSeFirstArticleMap",getArticleMap("tese",gameId));
        			root.put("articleList", getArticleList(advice.getPlatformno(),gameId));
        		}        		
        	}
        }
		FreemarkerUtil.buildHtml(templateFilePath,"article.shtml", root, htmlFilePath,articleName);
		
		FreemarkerUtil.buildHtml(templateFilePath,
				"article.shtml", root, previewhtmlFilePath,
				articleName);	
        if(!game.getGameNo().equals("xyd")){
            FreemarkerUtil.buildHtml(templateFilePath,"articleGameBox.shtml", root, gameBoxPath, articleName);
         }

	}
	
	private Map<String, String> getArticleMap(String articleType, String gameId) {	
		Advice advice = new Advice();
		advice.setAdviceType("3");
        if(StringUtils.isNotEmpty(articleType)){
            advice.setPlatformno(articleType);
        }
		advice.setGameId(gameId);
		advice.setLePublishDate(sdf.format(new Date()));
		Page page = new Page();
		page.setPageNo(1);
		page.setPageSize(1);
		page.addOrder("displayOrder", OrderType.ESC);
		page.addOrder("publishDate", OrderType.DESC);
		String nowStr=sdf.format(new Date());
		List<Advice> adviceList = FacadeFactory.INSTANCE.getAdviceBo().findAdvice(advice, page);
		if(CollectionUtils.isEmpty(adviceList))return null;
		Advice ad = adviceList.get(0);
		Map<String, String> map = new HashMap<String, String>();
		map.put("type", ad.getPlatformno());
		map.put("url", ad.getJumpUrl() == null ? "" : ad.getJumpUrl());
		map.put("aid", ad.getSeqId() + "");
		map.put("title", formatTitle(ad.getTitle()));
		boolean isRemoveRedBold=false;
        if(StringUtils.isNotEmpty(ad.getRemoveFlagTime())){
            isRemoveRedBold=nowStr.compareTo(ad.getRemoveFlagTime())>=0;
        }
		map.put("isColor", ad.getRed()&&isRemoveRedBold==false ? "yes" : "no");
		map.put("isStrong", ad.getBold()&&isRemoveRedBold==false ? "yes" : "no");
		map.put("date", ad.getPublishDate().substring(5, 10));
		map.put("hotVlaue", ad.getHotLevel()+"");
		return map;
	}
	
	private List<Map<String, String>> getArticleList(String articleType, String gameId) {
		List<Map<String, String>> articleList = new ArrayList<Map<String, String>>();
		Advice advice = new Advice();
		advice.setAdviceType("3");
        if(StringUtils.isNotEmpty(articleType)){
            advice.setPlatformno(articleType);
        }
		advice.setGameId(gameId);
		advice.setLePublishDate(sdf.format(new Date()));
		Page page = new Page();
		page.addOrder("displayOrder", OrderType.ESC);
		page.addOrder("publishDate", OrderType.DESC);
		String nowStr=sdf.format(new Date());
		List<Advice> adviceList = FacadeFactory.INSTANCE.getAdviceBo().findAdvice(advice, page);
		for (Advice ad : adviceList) {
			Map<String, String> map = new HashMap<String, String>();
			map.put("type", ad.getPlatformno());
			map.put("url", ad.getJumpUrl() == null ? "" : ad.getJumpUrl());
			map.put("aid", ad.getSeqId() + "");
			map.put("title", formatTitle(ad.getTitle()));
			boolean isRemoveRedBold=false;
            if(StringUtils.isNotEmpty(ad.getRemoveFlagTime())){
                isRemoveRedBold=nowStr.compareTo(ad.getRemoveFlagTime())>=0;
            }
			map.put("isColor", ad.getRed()&&isRemoveRedBold==false ? "yes" : "no");
			map.put("isStrong", ad.getBold()&&isRemoveRedBold==false ? "yes" : "no");
			map.put("date", ad.getPublishDate().substring(5, 10));
			map.put("hotVlaue", ad.getHotLevel()+"");
			articleList.add(map);
		}
		return articleList;
	}

	private String formatTitle(String title){
		if(StringTools.isEmpty(title))return "";
		return title.replaceAll("\"", "\\\\\"");
	}
	
    
	private String getGameVersionCode(String gameId){
		GameVersion query = new GameVersion();
		query.setGameId(gameId);
		GameVersion gameVersion = FacadeFactory.INSTANCE.getBaseSo().findObject(query);
		if(gameVersion == null) return null;
		VersionInfo info = new VersionInfo();
		info.setVersionNo(gameVersion.getVersionNo());
		VersionInfo version = FacadeFactory.INSTANCE.getBaseSo().findObject(info);
		if(version == null)return null;
		return version.getVersionCode();
	}
	

	private String getContent(final Games games,final Advice advice){
		logger.info("builderaarticle timestamp["+timestamp+"]id["+advice.getGameId()+"开始替换静态图片");
		//替换静态图片访问地址
		String content=advice.getContent()==null?"":advice.getContent();
		content=content.replaceAll("src=\"/xlniuxmanager/userUploadFile/image","src=\"http://img.smxj.webgame.kanimg.com/userUploadFile/image");
		content=content.replaceAll("src=\"/xlniumanager/userUploadFile/image","src=\"http://img.smxj.webgame.kanimg.com/userUploadFile/image");
		logger.info("builderaarticle timestamp["+timestamp+"]id["+advice.getGameId()+"开始替换关键字");
		//替换关键字
        if(games != null){
            List<LinkInfo> lilist=FacadeFactory.INSTANCE.getLinkInfoBo().getGameValidteLinkInfoListByLinkLocId("256", games.getGameId(), 10, false);
            for(LinkInfo li:lilist){
                if(li.getLinktitle()==null||"".equals(li.getLinktitle())){
                    continue;
                }
                content=content.replace(li.getLinktitle(), "<a href=\""+li.getLinkurl()+"\" target=\"_blank\">"+li.getLinktitle()+"</a>");
                logger.info("builderaarticle timestamp["+timestamp+"]id["+advice.getGameId()+"替换关键字"+li.getLinktitle());
            }
            logger.info("builderaarticle timestamp["+timestamp+"]id["+advice.getGameId()+"替换关键字完成");
        }

		return content;
	}
	private void execRsync(final HtmlTemplate htmlTemplate){
		String execCmd=htmlTemplate.getRsyncname();//执行命
		if(execCmd==null||"".equals(execCmd)){
			return;
		}
		try {
			Runtime.getRuntime().exec(execCmd);
			Runtime.getRuntime().exec(htmlTemplate.getPreviewrsyncname());
		} catch (IOException e) {
			throw new RuntimeException("执行同步脚本："+execCmd+"出现异常",e);
		}

	}


}
