package com.xunlei.niux.manager.template.builder.gameofficial;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.Advice;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.data.vipgame.vo.HtmlTemplate;
import com.xunlei.niux.data.vipgame.vo.LinkInfo;
import com.xunlei.niux.manager.template.builder.AbstractTemplateBuilder;
import com.xunlei.niux.manager.web.cache.GameCache;
import com.xunlei.niux.manager.web.util.FreemarkerUtil;
import com.xunlei.util.StringTools;

/**
 * 一次生成所有游戏官网的文章模板
 * @author lisu
 * 2014-08-13
 */
public class AllArticleBuilder extends AbstractTemplateBuilder{
	private static final Logger logger = Logger.getLogger(AllArticleBuilder.class.getName());
	private long timestamp=0;
	private static final String regEx = "<[^>]+>"; //定义HTML标签的正则表达式
	

	@Override
	public void executeShcema() throws Exception {
		makeAllGameAdvice();
	}
	
	private void makeNormalAdvice() throws Exception{
    	String sql = "select * from advice where adviceType='3' and  content<> '' and jumpurl  like '%/a/%' ";
    	List<Advice> advlist = FacadeFactory.INSTANCE.getBaseSo().executeQuery(Advice.class, sql, new ArrayList());
    	for(Advice adv:advlist){
    		  if (StringUtils.isNotEmpty(adv.getGameId())) {
                  Games games = GameCache.getInstance().getGameByGameId(adv.getGameId());                  
                  if (games == null || games.getClientType().intValue() == 3) {//如果是手游
                      continue;
                  }
              }
    		  String articleName = getArticeUrlName(adv);
    		  if(StringTools.isEmpty(articleName)||"null".equals(articleName))continue;//如果没有生成地址，则不需要重新生成
    		  makeArticleBuilder(adv,articleName);    
    		  logger.info("makeAllGameAdvice seqid:"+adv.getSeqId());
    	}
    	
	}
	
	private void makeExceptionAdvice() throws Exception{
		
	}
	
    private void makeAllGameAdvice() throws Exception{
    	makeNormalAdvice();
    	makeExceptionAdvice();
    	synch();//同步文章
    }
    
    private void synch() throws Exception{
    	logger.info("builderaarticle timestamp["+timestamp+"]id开始同步");
		execRsync(htmlTemplate);
		logger.info("builderaarticle timestamp["+timestamp+"]id完成同步");
    }
	
	 /**
     * 去掉html格式
     * @param content
     * @return
     */
    private String removeHtml(String regEx, String content){   	    
        Pattern pattern = Pattern.compile(regEx,Pattern.CASE_INSENSITIVE);    
        Matcher  matcher = pattern.matcher(content);    
        content = matcher.replaceAll(""); //过滤html标签    
    	return content;
    }
	
	
	/**
	 * 获取文章的url访问名字
	 * @param advice
	 * @return
	 */
	private String getArticeUrlName(final Advice advice){
		String contentUrl = advice.getJumpUrl();
		if(StringTools.isEmpty(contentUrl)){//如果没有生成地址
			return null;
		}
		if(contentUrl.contains("/a/")){
			return contentUrl.substring(contentUrl.lastIndexOf("/")+1);
		}
		return System.currentTimeMillis()+".shtml";
	}
   private Map<String, String> getHeadData(String gameId) {
	    Map<String,String> headMap = new HashMap<String,String>();

	    LinkInfo linkinfo = FacadeFactory.INSTANCE.getLinkInfoBo().getGameValidteLinkInfoByLinkLocId(
	      "302", gameId, false);
	    headMap.put("title", 
	      (linkinfo == null) || (linkinfo.getLinktitle() == null) ? "" : linkinfo.getLinktitle());
	    headMap.put("description", 
	      (linkinfo == null) || (linkinfo.getLinkdesc() == null) ? "" : linkinfo.getLinkdesc());
	    Games games = GameCache.getInstance().getGameByGameId(gameId);
	    headMap.put("gameName", games==null?"":games.getGameName());
	    return headMap;
	  }
   
	public void makeArticleBuilder(final Advice advice,String articleName){
		timestamp=System.currentTimeMillis();
		logger.info("builderaarticle timestamp["+timestamp+"]id["+advice.getGameId()+"开始生成");
		Games game=GameCache.getInstance().getGameByGameId(advice.getGameId());
        if(game == null){
            logger.error("gameid "+advice.getGameId()+" 对应的游戏信息不存在！");
        }
        int gameClientType = game.getClientType();

		Map<String,String> articleInfoMap=new HashMap<String,String>();
		articleInfoMap.put("typeId", advice.getPlatformno()+"");
		articleInfoMap.put("title", advice.getTitle()+"");
		articleInfoMap.put("red", advice.getRed()+"");
		articleInfoMap.put("bold", advice.getBold()+"");
		articleInfoMap.put("content", getContent(game, advice));
		articleInfoMap.put("date", advice.getPublishDate().substring(0, 10));
		
		//seo标题
		String content = advice.getContent();
		content = removeHtml(regEx,content);
		if(content !=null ){
    		content = content.replaceAll("\n", "");
    		content = content.replaceAll("\r","");
    		content = content.replaceAll("\t","");
    		content = content.replaceAll("&nbsp;", "");
    		content = content.trim();
    		if(content.length()>80)
    		   content = content.substring(0,80);
    	}
		articleInfoMap.put("description", content);
		
		String htmlFilePath=htmlTemplate.getHtmlroot();
		if(htmlFilePath.endsWith("/")){
			htmlFilePath=htmlFilePath.substring(0, htmlFilePath.length()-1);
		}
		
		htmlFilePath=htmlFilePath+"/tv3/official/"+game.getGameNo()+"/a";
		Map<String,Object> root=new HashMap<String,Object>();
		root.put("articleInfoMap", articleInfoMap);
		root.put("headMap", getHeadData(game.getGameId()));
		logger.info("builderaarticle timestamp["+timestamp+"]id["+advice.getGameId()+"开始生成正式模板");

        String templateFilePath = htmlTemplate.getTemplateroot();
//        String templateFilePath = "/Users/jamesjxin/Work/XLWork/xlniuxmanager/src/main/java/com/xunlei/niux/manager/template/builder/gameofficial";
        if(templateFilePath.endsWith("/")){
            templateFilePath = templateFilePath.substring(0,templateFilePath.length()-1);
        }
        if(gameClientType == 2 && game.getGameNo().equals("xyd")){
            templateFilePath = templateFilePath + "/" + game.getGameNo();
        }

		FreemarkerUtil.buildHtml(templateFilePath,"article.shtml", root, htmlFilePath,articleName);
	}
    

	private String getContent(final Games games,final Advice advice){
		logger.info("builderaarticle timestamp["+timestamp+"]id["+advice.getGameId()+"开始替换静态图片");
		//替换静态图片访问地址
		String content=advice.getContent()==null?"":advice.getContent();
		content=content.replaceAll("src=\"/xlniuxmanager/userUploadFile/image","src=\"http://img.smxj.webgame.kanimg.com/userUploadFile/image");
		content=content.replaceAll("src=\"/xlniumanager/userUploadFile/image","src=\"http://img.smxj.webgame.kanimg.com/userUploadFile/image");
		logger.info("builderaarticle timestamp["+timestamp+"]id["+advice.getGameId()+"开始替换关键字");
		//替换关键字
        if(games != null){
            List<LinkInfo> lilist=FacadeFactory.INSTANCE.getLinkInfoBo().getGameValidteLinkInfoListByLinkLocId("256", games.getGameId(), 10, false);
            for(LinkInfo li:lilist){
                if(li.getLinktitle()==null||"".equals(li.getLinktitle())){
                    continue;
                }
                content=content.replace(li.getLinktitle(), "<a href=\""+li.getLinkurl()+"\" target=\"_blank\">"+li.getLinktitle()+"</a>");
                logger.info("builderaarticle timestamp["+timestamp+"]id["+advice.getGameId()+"替换关键字"+li.getLinktitle());
            }
            logger.info("builderaarticle timestamp["+timestamp+"]id["+advice.getGameId()+"替换关键字完成");
        }

		return content;
	}
	private void execRsync(final HtmlTemplate htmlTemplate){
		String execCmd=htmlTemplate.getRsyncname();//执行命
		if(execCmd==null||"".equals(execCmd)){
			return;
		}
		try {
			Runtime.getRuntime().exec(execCmd);
			Runtime.getRuntime().exec(htmlTemplate.getPreviewrsyncname());
		} catch (IOException e) {
			throw new RuntimeException("执行同步脚本："+execCmd+"出现异常",e);
		}

	}


}
