package com.xunlei.niux.manager.template.builder.gamebox;

import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.niux.data.active.dto.commonactivity.ActivityGiftInfoDTO;
import com.xunlei.niux.data.active.facade.FacadeFactory;
import com.xunlei.niux.manager.template.builder.AbstractTemplateBuilder;
import com.xunlei.niux.manager.web.util.FreemarkerUtil;
import org.apache.commons.collections.CollectionUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created with IntelliJ IDEA.
 * User: admin
 * Date: 15-5-26
 * Time: 上午9:38
 * To change this template use File | Settings | File Templates.
 */
public class BoxJiFenGiftJSBuilder extends AbstractTemplateBuilder {

    private final static String JFJP_actNo = "boxjfjp";

    private final static String QDDJQ_actNo = "boxqddjq";

    private final static String QDLB_actNo = "boxqdlb";

    private String inputPath;
    private String outputPath;

    @Override
    public void executeShcema() throws Exception {
        inputPath = htmlTemplate.getTemplateroot();
        outputPath = htmlTemplate.getHtmlroot();

        buildBoxJFJP();
        buildBoxQDDJQ();
        buildBoxDQLB();
    }

    private void buildBoxJFJP(){
        Map<String,Object> rootMap = new HashMap<String, Object>();

        String gameData = "var giftdata = " + JsonObjectUtil.getDataJsonObject(getGiftInfoList(JFJP_actNo));
        rootMap.put("giftdata",gameData);

        FreemarkerUtil.buildHtml(inputPath, "giftdata.js", rootMap, outputPath, "giftdata.js");
    }

    private void buildBoxQDDJQ(){
        Map<String,Object> rootMap = new HashMap<String, Object>();

        String gameData = "var giftdata = " + JsonObjectUtil.getDataJsonObject(getGiftInfoList(QDDJQ_actNo));
        rootMap.put("giftdata",gameData);

        FreemarkerUtil.buildHtml(inputPath, "boxqddjq_giftdata.js", rootMap, outputPath, "boxqddjq_giftdata.js");
    }

    private void buildBoxDQLB(){
        Map<String,Object> rootMap = new HashMap<String, Object>();

        String gameData = "var giftdata = " + JsonObjectUtil.getDataJsonObject(getGiftInfoList(QDLB_actNo));
        rootMap.put("giftdata",gameData);

        FreemarkerUtil.buildHtml(inputPath, "boxqdlb_giftdata.js", rootMap, outputPath, "boxqdlb_giftdata.js");
    }

    private List<Map<String,Object>> getGiftInfoList(String actNo){
        List<ActivityGiftInfoDTO> giftInfoDTOList = FacadeFactory.INSTANCE.getActivityGiftBo().getAllActGiftListWithConsumeBonusAndGiftName(actNo);

        List<Map<String,Object>> resultList = new ArrayList<Map<String, Object>>();
        if(CollectionUtils.isEmpty(giftInfoDTOList)){
            return resultList;
        }

        for(ActivityGiftInfoDTO giftInfoDTO : giftInfoDTOList){
            Map<String,Object> map = new HashMap<String, Object>();
            map.put("actNo",giftInfoDTO.getActNo()==null?"":giftInfoDTO.getActNo());
            map.put("moduleId",giftInfoDTO.getModuleId()==null?"":giftInfoDTO.getModuleId());
            map.put("giftId",giftInfoDTO.getGiftId()==null?"":giftInfoDTO.getGiftId());
            map.put("giftName",giftInfoDTO.getGiftName()==null?"":giftInfoDTO.getGiftName());
            map.put("consumeBonus",giftInfoDTO.getConsumeBonus()==null?0:giftInfoDTO.getConsumeBonus());
            map.put("photo",giftInfoDTO.getPhoto()==null?"":giftInfoDTO.getPhoto());

            resultList.add(map);
        }

        return resultList;
    }
}
