package com.xunlei.niux.manager.template.builder.game;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import com.ferret.common.dao.vo.Page;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.GamePayInfo;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.data.vipgame.vo.LinkInfo;
import com.xunlei.niux.manager.template.builder.AbstractTemplateBuilder;
import com.xunlei.niux.manager.web.cache.GameCache;
import com.xunlei.niux.manager.web.proxy.GameBoxPicProxy;
import com.xunlei.niux.manager.web.util.FileUtil;
import com.xunlei.niux.manager.web.util.FreemarkerUtil;
import com.xunlei.util.StringTools;

public class GameInfoTemplateBuilder extends AbstractTemplateBuilder{

	
	public void executeShcema() throws Exception {
		allGameInfosBuilder();
	}
	private void allGameInfosBuilder(){
		Map<String,GamePayInfo> gamePayInfoMap=findAllGamePayInfoMap();
		
		List<Games> glist=GameCache.getInstance().getAllGames();
		List<Object> rList=new ArrayList<Object>();
		List<String> gameidList = new ArrayList<String>();
		for(Games game:glist){
			Map<String,Object> map=new HashMap<String,Object>();
			map.put("gameNo", game.getGameNo());
			map.put("gameId", game.getGameId());
			map.put("officialUrl", game.getOfficialWebSite()==null?"":game.getOfficialWebSite());
			map.put("forumUrl", game.getForumUrl()==null?"":game.getForumUrl());
			map.put("useTemplate", game.getUseTemplate()==null?"false":game.getUseTemplate()+"");
			map.put("logoUrl", "");
			map.put("gameName",game.getGameName());
			map.put("hasBigFenQu", game.getHasBigFenQu()==null?"false":game.getHasBigFenQu()+"");
			map.put("status", game.getStatus()+"");
			map.put("loadClientType", game.getLoadClientType());
			map.put("clientType", game.getClientType()+"");
			map.put("simpleName", game.getSimpleName()==null?"":game.getSimpleName());
			GamePayInfo gamePayInfo=gamePayInfoMap.get(game.getGameId());
			boolean isNeedSelectServer = gamePayInfo == null || gamePayInfo.getFormType().contains("s") ? true
							: false;
			boolean isNeedSelectRole = gamePayInfo == null || gamePayInfo.getFormType().contains("r") ? true
							: false;
			int isPay=gamePayInfo!=null&&gamePayInfo.getStatus()==1&&game.getStatus().equals("1")?1:0;
			map.put("isPay",String.valueOf(isPay));
			map.put("isNeedSelectServer", String.valueOf(isNeedSelectServer));
			map.put("isNeedSelectRole", String.valueOf(isNeedSelectRole));
//            map.put("picUrl",game.getPicUrl());
            map.put("smallPicUrl",game.getSmallPicUrl());
            map.put("runType",game.getRunType());
			rList.add(map);
			gameidList.add(game.getGameId());
		}
		Map<String,Object> root=new HashMap<String,Object>();
		root.put("allgameinfoslist", rList);
		String tempPath=htmlTemplate.getTemplateroot();
		String templateFileName="allgameinfos.ftl";
		String htmlFilePath=isPreView?htmlTemplate.getPreviewhtmlroot():htmlTemplate.getHtmlroot();
		String htmlFileName="allgameinfos.js";
		FreemarkerUtil.buildHtml(tempPath, templateFileName, root, htmlFilePath, htmlFileName);
		makeGamePicToBox(gameidList,glist,tempPath,templateFileName);//同步游戏图片给盒子
		buildGame(glist);
	}
	
	
	private void makeGamePicToBox(List<String> gameidList,List<Games> glist,String tempPath,String templateFileName){
		Collections.sort(gameidList);
		Collections.reverse(gameidList);
		Map<String,Object> result = new LinkedHashMap<String,Object>();
		for(String gameid:gameidList){
			Games game = GameCache.getInstance().getGameByGameId(gameid);
			if(!"1".equals(game.getStatus())||game.getClientType().intValue()==3)continue;//屏蔽掉手游和未接入的游戏	
			Map<String,String> map = new HashMap<String,String>();
			map.put("pic",game.getPicUrl()==null?"":game.getPicUrl());
			result.put(game.getGameId(), map);
		}
		 String htmlFilePath=isPreView?htmlTemplate.getPreviewhtmlroot():htmlTemplate.getHtmlroot();
		 String jsonStr=JsonObjectUtil.getDataJsonObject(result);
		 jsonStr = "var gamepics="+jsonStr;
		 File file = FileUtil.createFile(htmlFilePath + "/","gamepics.js");
		 FileUtil.writeByChar(file, jsonStr);
	}
	
	private void buildGame(List<Games> gameList){
		String htmlFilePath=isPreView?htmlTemplate.getPreviewhtmlroot():htmlTemplate.getHtmlroot();
		for(Games game:gameList){
			 String jsonStr=JsonObjectUtil.getDataJsonObject(game);
			 File file = FileUtil.createFile(htmlFilePath + "/game",game.getGameId()+".json");
			 FileUtil.writeByChar(file, jsonStr);
		}
	}
	private Map<String,GamePayInfo> findAllGamePayInfoMap(){
		Map<String,GamePayInfo> map=new HashMap<String, GamePayInfo>();
		List<GamePayInfo> list=FacadeFactory.INSTANCE.getBaseSo().findObjects(new GamePayInfo(),new Page());
		for(int i=0;i<list.size();i++){
			GamePayInfo gamePayInfo=list.get(i);
			map.put(gamePayInfo.getGameid(), gamePayInfo);
		}
		return map;
	}
}
