package com.xunlei.niux.manager.template.builder.fenqu;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.GameServers;
import com.xunlei.niux.data.vipgame.vo.LinkInfo;
import com.xunlei.niux.manager.template.builder.AbstractTemplateBuilder;



/**
 * 批量分区状态变化，只生成分区模版
 * @author lisu 
 * 2014-11-12
 */
public class FenQuStatusMoreChangeBuilder extends AbstractTemplateBuilder {

	private LinkInfo linkinfo;
	@Override
	public void executeShcema() throws Exception {
		//获取维护计划信息
		linkinfo=FacadeFactory.INSTANCE.getLinkInfoBo().find(Integer.valueOf(schema.getExt2()));
		if(linkinfo==null){
			throw new Exception("分区维护计划["+schema.getExt2()+"]不存在");
		}
		if("1".equals(schema.getExt3())){
			normaltoweihu();
		}else if("2".equals(schema.getExt3())){
			weihutonormal();
		}else{
			throw new Exception("未知状态");
		}
	}
	private void normaltoweihu()throws Exception{
		//判断是否在有效的时间内
		if(!schema.getSchematime().equals(linkinfo.getExt2())){
			throw new Exception("分区维护计划["+schema.getExt2()+"]的开始维护时间发生更改");
		}
		checkValidSchemaTime(linkinfo.getExt2());
		//查询分区
		GameServers gs=findGameServer(linkinfo.getGameid(), Integer.valueOf(linkinfo.getExt1()));
		if(gs==null){
			throw new Exception("游戏分区不存在");
		}
		//判断状态是否ok
		if(!"1".equals(gs.getOpenStatus())){
			throw new Exception("分区未处于已开区状态");
		}
		gs.setOpenStatus("3");

		FacadeFactory.INSTANCE.getGameServersBo().update(gs);
	}
    
  
	
	
	/**
	 * 维护状态到正常状态
	 * @throws Exception
	 */
	private void weihutonormal()throws Exception{
		//判断是否在有效的时间内
		if(!schema.getSchematime().equals(linkinfo.getExt3())){
			throw new Exception("分区维护计划["+schema.getExt3()+"]的结束维护时间发生更改");
		}
		checkValidSchemaTime(linkinfo.getExt3());
		//查询分区
		GameServers gs=findGameServer(linkinfo.getGameid(), Integer.valueOf(linkinfo.getExt1()));
		if(gs==null){
			throw new Exception("游戏分区不存在");
		}
		//判断状态是否ok
		if(!"3".equals(gs.getOpenStatus())){
			throw new Exception("分区未处于维护状态");
		}
		gs.setOpenStatus("1");
		FacadeFactory.INSTANCE.getGameServersBo().update(gs);
	}
	private void checkValidSchemaTime(String time)throws Exception{
		SimpleDateFormat mysdf=new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		Date now =new Date();
		long l1=now.getTime();
		long l2=l1-1*60*1000;
		Date date=mysdf.parse(time);
		if(l2>date.getTime()){
			throw new Exception("过期");
		}
	}
	private GameServers findGameServer(String gameId,int fenQuNum){
		GameServers qgs=new GameServers();
		qgs.setGameId(gameId);
		qgs.setFenQuNum(fenQuNum);
		List<GameServers> list=FacadeFactory.INSTANCE.getGameServersBo().find(qgs, new Page());
		return (list==null||list.size()==0)?null:list.get(0);
	}
}
