package com.xunlei.niux.manager.template.builder.fenqu;

import java.text.SimpleDateFormat;
import java.util.Date;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.HtmlTemplate;
import com.xunlei.niux.data.vipgame.vo.TemplateSchema;
import com.xunlei.niux.data.vipgame.vo.version.GameVersion;
import com.xunlei.niux.data.vipgame.vo.version.VersionInfo;
import com.xunlei.niux.manager.template.builder.AbstractTemplateBuilder;
import com.xunlei.niux.manager.template.constant.TemplateIdConstant;


/**
 * 批量变更分区状态后生成
 * 进入游戏页、游戏官网、通知盒子、通知骏网
 *   @author lisu 
 * 2014-11-12
 */
public class FenQuStatusGameChangeBuilder extends AbstractTemplateBuilder {
	private static SimpleDateFormat sdf=new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

	@Override
	public void executeShcema() throws Exception {
		String gameId  = schema.getExt1();
		//更新游戏分区
		addEnterGameTemplateSchema(gameId);
		addGameOfficialTemplateSchema(gameId);
		noticeniuxupdatecache(gameId);
		Runtime.getRuntime().exec("/usr/local/htdocs/JNetPayGenXml/startup.sh");
	}
	
	private void addEnterGameTemplateSchema(String gameId){
		String nowStr=sdf.format(new Date());
    	//添加执行计划
		TemplateSchema ts=new TemplateSchema();
		ts.setTemplateid("000027");
		ts.setSchematime(nowStr);
		ts.setIsexecuted(false);
		ts.setInputby("系统");
		ts.setInputtime(nowStr);
		ts.setIspreview(false);
		ts.setExt1(gameId);
		FacadeFactory.INSTANCE.getTemplateSchemaBo().insert(ts);
	}
	/**
	 * 添加游戏官网执行模板
	 * @param gameId
	 */
	private void addGameOfficialTemplateSchema(String gameId){
		GameVersion gameversion=FacadeFactory.INSTANCE.getGameVersionBo().find(gameId);
		if(gameversion==null){
			return;
		}
		VersionInfo versionInfo=FacadeFactory.INSTANCE.getVersionInfoBo().find(gameversion.getVersionNo());
		if(versionInfo==null){
			return;
		}
		TemplateSchema templateSchema=new TemplateSchema();
		templateSchema.setTemplateid(versionInfo.getTemplateId());
		templateSchema.setIspreview(false);
		templateSchema.setExecstatus(false);
		templateSchema.setSchematime(sdf.format(new Date()));
		templateSchema.setInputtime(sdf.format(new Date()));
		templateSchema.setInputby("系统");
		templateSchema.setExt1(gameId);
		templateSchema.setExt2(versionInfo.getColorCode());
		templateSchema.setIsexecuted(false);
		FacadeFactory.INSTANCE.getTemplateSchemaBo().insert(templateSchema);
		return;
	}
	/**
	 * 通知牛X平台更新分区缓存
	 * @param gameId
	 */
	private void noticeniuxupdatecache(String gameId){
		try{
			///String url="http://10.1.3.40:8080/cacheupdate.do?type=2&&gameId="+gameId;
			//HttpClientUtil.get(url);
			//通知模板更新
			HtmlTemplate ht=new HtmlTemplate();
			ht.setTemplateid(TemplateIdConstant.TEMPLATE_GAME_FENQU);
			ht.setExt1(gameId);
			FenQuBuilder fqb=new FenQuBuilder();
			fqb.addTeamplateSchema(ht, false);
		}catch(Exception e){
			throw new RuntimeException(e);
		}
	}
}
