package com.xunlei.niux.manager.template.builder.fenqu;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.EmergencyMessage;
import com.xunlei.niux.data.vipgame.vo.GameServers;
import com.xunlei.niux.data.vipgame.vo.HtmlTemplate;
import com.xunlei.niux.data.vipgame.vo.TemplateSchema;
import com.xunlei.niux.data.vipgame.vo.version.GameVersion;
import com.xunlei.niux.data.vipgame.vo.version.VersionInfo;
import com.xunlei.niux.manager.template.builder.AbstractTemplateBuilder;
import com.xunlei.niux.manager.template.constant.TemplateIdConstant;

/**
 * 分区状态变化
 * @author Administrator
 *
 */
public class FenQuStatusChangeBuilder2 extends AbstractTemplateBuilder {
	private static SimpleDateFormat sdf=new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
	EmergencyMessage message;
	@Override
	public void executeShcema() throws Exception {
		//获取维护计划信息
		message=FacadeFactory.INSTANCE.getBaseSo().findById(EmergencyMessage.class,Long.valueOf(schema.getExt2()));
		if(message==null){
			throw new Exception("分区维护计划["+schema.getExt2()+"]不存在");
		}
		if(message.getIsAutoChangeServerStatus()==false){
			throw new Exception("分区维护计划["+schema.getExt2()+"]不自动切换");
		}
		if("1".equals(schema.getExt3())){
			normaltoweihu();
		}else if("2".equals(schema.getExt3())){
			weihutonormal();
		}else{
			throw new Exception("未知状态");
		}
		//更新游戏分区
		addEnterGameTemplateSchema(message.getGameId());
		addGameOfficialTemplateSchema(message.getGameId());
		noticeniuxupdatecache(message.getGameId());
		Runtime.getRuntime().exec("/usr/local/htdocs/JNetPayGenXml/startup.sh");
	}
	private void normaltoweihu()throws Exception{
		//判断是否在有效的时间内
		if(!schema.getSchematime().equals(message.getBeginMaintainTime())){
			throw new Exception("分区维护计划["+schema.getExt2()+"]的开始维护时间发生更改");
		}
		checkValidSchemaTime(message.getBeginMaintainTime());
		//查询分区
		GameServers gs=findGameServer(message.getGameId(), Integer.valueOf(message.getFenQuNum()));
		if(gs==null){
			throw new Exception("游戏分区不存在");
		}
		//判断状态是否ok
		if(!"1".equals(gs.getOpenStatus())){
			throw new Exception("分区未处于已开区状态");
		}
		gs.setOpenStatus("3");
		FacadeFactory.INSTANCE.getGameServersBo().update(gs);
	}
	/**
	 * 维护状态到正常状态
	 * @throws Exception
	 */
	private void weihutonormal()throws Exception{
		//判断是否在有效的时间内
		if(!schema.getSchematime().equals(message.getEndMaintainTime())){
			throw new Exception("分区维护计划["+schema.getExt3()+"]的结束维护时间发生更改");
		}
		checkValidSchemaTime(message.getEndMaintainTime());
		//查询分区
		GameServers gs=findGameServer(message.getGameId(), Integer.valueOf(message.getFenQuNum()));
		if(gs==null){
			throw new Exception("游戏分区不存在");
		}
		//判断状态是否ok
		if(!"3".equals(gs.getOpenStatus())){
			throw new Exception("分区未处于维护状态");
		}
		gs.setOpenStatus("1");
		FacadeFactory.INSTANCE.getGameServersBo().update(gs);
	}
	private void checkValidSchemaTime(String time)throws Exception{
		Date now =new Date();
		long l1=now.getTime();
		long l2=l1-1*60*1000;
		Date date=sdf.parse(time);
		if(l2>date.getTime()){
			throw new Exception("过期");
		}
	}
	private GameServers findGameServer(String gameId,int fenQuNum){
		GameServers qgs=new GameServers();
		qgs.setGameId(gameId);
		qgs.setFenQuNum(fenQuNum);
		List<GameServers> list=FacadeFactory.INSTANCE.getGameServersBo().find(qgs, new Page());
		return (list==null||list.size()==0)?null:list.get(0);
	}
	private void addEnterGameTemplateSchema(String gameId){
		String nowStr=sdf.format(new Date());
    	//添加执行计划
		TemplateSchema ts=new TemplateSchema();
		ts.setTemplateid("000027");
		ts.setSchematime(nowStr);
		ts.setIsexecuted(false);
		ts.setInputby("系统");
		ts.setInputtime(nowStr);
		ts.setIspreview(false);
		ts.setExt1(gameId);
		FacadeFactory.INSTANCE.getTemplateSchemaBo().insert(ts);
	}
	/**
	 * 添加游戏官网执行模板
	 * @param gameId
	 */
	private void addGameOfficialTemplateSchema(String gameId){
		GameVersion gameversion=FacadeFactory.INSTANCE.getGameVersionBo().find(gameId);
		if(gameversion==null){
			return;
		}
		VersionInfo versionInfo=FacadeFactory.INSTANCE.getVersionInfoBo().find(gameversion.getVersionNo());
		if(versionInfo==null){
			return;
		}
		TemplateSchema templateSchema=new TemplateSchema();
		templateSchema.setTemplateid(versionInfo.getTemplateId());
		templateSchema.setIspreview(false);
		templateSchema.setExecstatus(false);
		templateSchema.setSchematime(sdf.format(new Date()));
		templateSchema.setInputtime(sdf.format(new Date()));
		templateSchema.setInputby("系统");
		templateSchema.setExt1(gameId);
		templateSchema.setExt2(versionInfo.getColorCode());
		templateSchema.setIsexecuted(false);
		FacadeFactory.INSTANCE.getTemplateSchemaBo().insert(templateSchema);
		return;
	}
	/**
	 * 通知牛X平台更新分区缓存
	 * @param gameId
	 */
	private void noticeniuxupdatecache(String gameId){
		try{
			HtmlTemplate ht=new HtmlTemplate();
			ht.setTemplateid(TemplateIdConstant.TEMPLATE_GAME_FENQU);
			ht.setExt1(gameId);
			FenQuBuilder fqb=new FenQuBuilder();
			fqb.addTeamplateSchema(ht, false);
		}catch(Exception e){
			throw new RuntimeException(e);
		}
	}
}
