package com.xunlei.niux.manager.template.builder.fenqu;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.GameServers;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.manager.template.builder.AbstractTemplateBuilder;
import com.xunlei.niux.manager.template.builder.fenqu.fenqubuiderthread.BuildGameFenQuJsonThread;
import com.xunlei.niux.manager.template.builder.fenqu.fenqubuiderthread.UpdateLatestFenquThread;
import com.xunlei.niux.manager.web.cache.GameCache;
import com.xunlei.niux.manager.web.proxy.ServerActivityCountProxy;
import com.xunlei.niux.manager.web.util.FreemarkerUtil;


/**
 * 分区数据生成
 * @author Administrator
 *
 */
public class FenQuBuilder extends AbstractTemplateBuilder {
	static SimpleDateFormat sdfdate=new SimpleDateFormat("yyyy-MM-dd");

	public void executeShcema() throws Exception {
        ExecutorService executorService = Executors.newFixedThreadPool(4);
        String gameId = schema.getExt1();
//        String gameId = "000069";
        String tempPath=htmlTemplate.getTemplateroot();
        String htmlFilePath=isPreView?htmlTemplate.getPreviewhtmlroot():htmlTemplate.getHtmlroot();
//        String tempPath="/Users/jamesjxin/Work/XL工作目录/20140718进入游戏分区模板优化/tmpfile";
//        String htmlFilePath="/Users/jamesjxin/Work/XL工作目录/20140718进入游戏分区模板优化/output";


        UpdateLatestFenquThread updateLatestFenquThread = new UpdateLatestFenquThread(gameId);
        BuildGameFenQuJsonThread buildGameFenQuJsonThread = new BuildGameFenQuJsonThread(gameId,tempPath,htmlFilePath);

        Future future1 = executorService.submit(updateLatestFenquThread);
        Future future2 = executorService.submit(buildGameFenQuJsonThread);

        future1.get();
        future2.get();

        executorService.shutdown();
		makeServerActivtyCountJs();//生成游戏最新区服数和活动数
	}
	
	private void makeServerActivtyCountJs(){
		ServerActivityCountProxy.getInstance().makeServerActivityCountJS();
	}

	public void updateLatestFenqu(String gameId){
		if(gameId==null||"".equals(gameId)){
			return;
		}
		GameServers gs=FacadeFactory.INSTANCE.getGameServersBo().getLatestGameServerByGameId(gameId, false);
		if(gs==null){
			return;
		}
		if(gs.getIsnew()){
			return;
		}
		//更新最新区服的状态
		gs.setIsnew(true);
		gs.setIsrecommand(true);
		gs.setRedtitle(true);
		FacadeFactory.INSTANCE.getGameServersBo().update(gs);

        GameServers query = new GameServers();
        query.setGameId(gameId);
		List<GameServers> gsList=FacadeFactory.INSTANCE.getGameServersBo().find(query, new Page());
		for(int i=0;i<gsList.size();i++){
			GameServers gserver=gsList.get(i);
			if(gserver.getIsnew()==false){
				continue;
			}
			if(gserver.getSeqId().longValue()==gs.getSeqId().longValue()){
				continue;
			}
			gserver.setIsnew(false);
			gserver.setIsrecommand(false);
			gserver.setRedtitle(false);
			FacadeFactory.INSTANCE.getGameServersBo().update(gserver);
		}
	}
	public void buildeTodayOpenFenQuServer(){
		String now=sdfdate.format(new Date());
		GameServers query=new GameServers();
		query.setFromopentime(now+" 00:00:00");
		query.setToopentime(now+" 23:59:59");
		Page page=new Page();
		page.addOrder("openTime", OrderType.ESC);
		page.addOrder("serverId", OrderType.ESC);
		List<GameServers> gsList=FacadeFactory.INSTANCE.getGameServersBo().find(query, page);
		List<Map<String,Object>> list=fliterGameServerInfo(gsList);
		String htmlFilePath=isPreView?htmlTemplate.getPreviewhtmlroot():htmlTemplate.getHtmlroot();
		String json=JsonObjectUtil.getDataJsonObject(list);
		File file = com.xunlei.niux.manager.web.util.FileUtil.createFile(htmlFilePath, "todayopenserver.js");
		com.xunlei.niux.manager.web.util.FileUtil.writeByChar(file, "todayopenserver="+json);
	}
	private static List<Map<String,Object>> fliterGameServerInfo(List<GameServers> gsList){
		List<Map<String,Object>> list=new ArrayList<Map<String,Object>>();
		if(gsList==null||gsList.size()==0){
			return list;
		}
		for(int i=0;i<gsList.size();i++){
			GameServers tgs=gsList.get(i);
			Games games=GameCache.getInstance().getGameByGameId(tgs.getGameId());
			Map<String,Object> map=new HashMap<String,Object>();
			map.put("seqId", tgs.getSeqId());
			map.put("gameId", tgs.getGameId());
			map.put("fenQuNum", tgs.getFenQuNum());
			map.put("fenQuName", tgs.getFenQuName());
			map.put("serverId", tgs.getServerId());
			map.put("openStatus", tgs.getOpenStatus());
			map.put("openTime", tgs.getOpenTime());
			map.put("isnew", tgs.getIsnew());
			map.put("fenQuNickName", tgs.getFenQuNickName());
			map.put("bigFenQuName", tgs.getBigFenQuName());
			map.put("gameNo", games.getGameNo());
			map.put("gameName", games.getGameName());
			list.add(map);
		}
		return list;
	}

	/**
	 * 最新区
	 */
	public void buildLatestFenQu(){
		Games qGame=new Games();
		List<Games> gameList=FacadeFactory.INSTANCE.getGamesBo().findGames(qGame, 0, 0);
		List<Object> list=new ArrayList<Object>();
		for(Games game:gameList){
			GameServers gs=FacadeFactory.INSTANCE.getGameServersBo().getLatestGameServerByGameId(game.getGameId(), isPreView);
			if(gs==null){
				continue;
			}
			Map<String,Object> map=new HashMap<String,Object>();
			map.put("seqId", gs.getSeqId());
			map.put("fenQuNum", gs.getFenQuNum());
			map.put("fenQuName", gs.getFenQuName()==null?"": gs.getFenQuName());
			map.put("fenQuNickName", (gs.getFenQuNickName()==null||"".equals(gs.getFenQuNickName())?gs.getFenQuName():gs.getFenQuNickName()));
			map.put("serverName", gs.getServerName()==null?"":gs.getServerName());
			map.put("serverId", gs.getServerId()==null?"":gs.getServerId());
			map.put("serverAddress", gs.getAddress()==null?"":gs.getAddress());
			map.put("gameId", gs.getGameId());
			map.put("gameNo", game.getGameNo());
			map.put("openTime",gs.getOpenTime()==null?"":gs.getOpenTime());
			list.add(map);
		}
		Map<String,Object> root=new HashMap<String,Object>();
		root.put("latestfenqulist", list);
		String tempPath=htmlTemplate.getTemplateroot();
		String templateFileName="latestfenquinfo.ftl";
		String htmlFilePath=isPreView?htmlTemplate.getPreviewhtmlroot():htmlTemplate.getHtmlroot();
		String htmlFileName="gamelatestfenquinfos.js";
		FreemarkerUtil.buildHtml(tempPath, templateFileName, root, htmlFilePath, htmlFileName);
	}
	public void buildGameFenQuJson(String gameId){
		if(gameId==null||"".equals(gameId)){
			return ;
		}
		GameServers query=new GameServers();
		query.setGameId(gameId);
		Page page=new Page();
		page.addOrder("openTime", OrderType.DESC);
		page.addOrder("serverId", OrderType.DESC);
		//查询全部
		List<GameServers> list=FacadeFactory.INSTANCE.getBaseSo().findObjects(query, page);
		List<Map<String,Object>> tlist=new ArrayList<Map<String,Object>>();
		for(GameServers gs:list){
			if("0".equals(gs.getOpenStatus())||"2".equals(gs.getOpenStatus())){
				continue;
			}
			Map<String,Object> map=new HashMap<String,Object>();
			map.put("fenQuNum",  String.valueOf(gs.getFenQuNum()));
			map.put("fenQuName", gs.getFenQuName());
			map.put("serverId",gs.getServerId());
			map.put("serverName", gs.getServerName());
			map.put("address", gs.getAddress());
			map.put("seqId", gs.getSeqId());
			map.put("openTime",gs.getOpenTime()==null?"":gs.getOpenTime());
			map.put("openStatus", gs.getOpenStatus());
			map.put("fenQuNickName", (gs.getFenQuNickName()==null||"".equals(gs.getFenQuNickName()))?gs.getFenQuName():gs.getFenQuNickName());
			map.put("bigFenQuName", gs.getBigFenQuName()==null?"":gs.getBigFenQuName());
			tlist.add(map);
		}
		String htmlFilePath=isPreView?htmlTemplate.getPreviewhtmlroot():htmlTemplate.getHtmlroot();
		String json=JsonObjectUtil.getDataJsonObject(tlist);
		File file = com.xunlei.niux.manager.web.util.FileUtil.createFile(htmlFilePath, gameId+".json");
		com.xunlei.niux.manager.web.util.FileUtil.writeByChar(file, "gamefenqus="+json);
	}
}
