package com.xunlei.niux.manager.template.builder.entergame.entergamethread;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.facade.IFacadeCommon;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.GameServers;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.data.vipgame.vo.LinkInfo;
import com.xunlei.niux.manager.web.util.FileUtil;

import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.concurrent.Callable;

/**
 * Created by jamesjxin on 14-8-22.
 */
public class GameServerJsonBuilderThread implements Callable {
    private static SimpleDateFormat sdfshort1=new SimpleDateFormat("MM月dd日  HH:mm");
    private static SimpleDateFormat sdf=new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    private String templatePath;
    private String htmlFilePath;
    private Games games;
    private boolean isPreView;


    public GameServerJsonBuilderThread(String templatePath, String htmlFilePath, Games games, boolean isPreView) {
        this.templatePath = templatePath;
        this.htmlFilePath = htmlFilePath;
        this.games = games;
        this.isPreView = isPreView;
    }

    @Override
    public Object call() throws Exception {
        String jsonStr = JsonObjectUtil.getDataJsonObject(getServerJsList());
        jsonStr = "var GAME_SERVER_INFO=" + jsonStr;

        String niuOfficialJsPath = IFacadeCommon.INSTANCE.getLibconfigValueByConfigNo("niuOfficialJsPath");
        if (niuOfficialJsPath.endsWith("/")) {
            niuOfficialJsPath = niuOfficialJsPath.substring(0, niuOfficialJsPath.length() - 1);
        }

        File file = FileUtil.createFile(niuOfficialJsPath + "/gamedata/fenqu", games.getGameId() + ".js");
        FileUtil.writeByChar(file, jsonStr);
//        buidlclosetips();
        return "";
    }

    private List<Map<String, String>> getServerJsList() {
        List<Map<String, String>> serverList = new ArrayList<Map<String, String>>();
        GameServers qgs = new GameServers();
        qgs.setGameId(games.getGameId());
        Page page = new Page();
        page.addOrder("openTime", OrderType.DESC);
        page.addOrder("fenQuNum", OrderType.DESC);
        List<GameServers> gsList = FacadeFactory.INSTANCE.getGameServersBo().find(qgs, page);
        gsList = gsList == null ? new ArrayList<GameServers>() : gsList;
        for (GameServers tgs : gsList) {
            if ("0".equals(tgs.getOpenStatus())) {
                continue;
            }
            if ("2".equals(tgs.getOpenStatus())) {
                continue;
            }
            String flag = "";
            if ("1".equals(tgs.getOpenStatus())) {
                flag = "2";// 顺畅
            } else if ("3".equals(tgs.getOpenStatus())) {
                flag = "4";// 维护中
            } else if ("4".equals(tgs.getOpenStatus())) {
                flag = "3";// 测试中，表示即将开始
            }
            Map<String, String> map = new HashMap<String, String>();
            map.put("name", tgs.getFenQuName());
            map.put("id", tgs.getFenQuNum() + "");
            map.put("flag", flag);
            map.put("serverId", tgs.getServerId()+"");
            map.put("isNew", (tgs.getIsnew()!=null&&tgs.getIsnew()==true)?"1":"0");
            serverList.add(map);
        }
        // 判断是否是推荐的服务器
        List<LinkInfo> list = FacadeFactory.INSTANCE.getLinkInfoBo()
                .getGameValidteLinkInfoListByLinkLocId_v2("240", games.getGameId(), 500, isPreView);
        Set<String> set = new HashSet<String>();
        for (LinkInfo li : list) {
            set.add(li.getExt1());
        }
        for (Map<String, String> tmap : serverList) {
            if (!"2".equals(tmap.get("flag"))) {
                continue;
            }
            if (set.contains(tmap.get("id"))) {
                tmap.put("flag", "1");
            }
        }
        // 判断测试的公告
        List<LinkInfo> ceshiList = FacadeFactory.INSTANCE.getLinkInfoBo()
                .getGameValidteLinkInfoListByLinkLocId_v2("252", games.getGameId(), 500, isPreView);
        Map<String, LinkInfo> ceshimap = new HashMap<String, LinkInfo>();
        for (LinkInfo li : ceshiList) {
            ceshimap.put(li.getExt1() + "", li);
        }
        // 判断维护公告
        List<LinkInfo> weihuList = FacadeFactory.INSTANCE.getLinkInfoBo()
                .getGameValidteLinkInfoListByLinkLocId_v2("253", games.getGameId(), 500, isPreView);
        Map<String, LinkInfo> weihumap = new HashMap<String, LinkInfo>();
        for (LinkInfo li : weihuList) {
            weihumap.put(li.getExt1() + "", li);
        }
        for (Map<String, String> tmap : serverList) {
            if ("3".equals(tmap.get("flag"))) {
                LinkInfo li = ceshimap.get(tmap.get("id"));
                tmap.put("date", (li == null || li.getExt2() == null) ? "" : formatTime(li.getExt2()));
                tmap.put("url", (li == null || li.getLinkurl() == null) ? "" : li.getLinkurl());
            } else if ("4".equals(tmap.get("flag"))) {
                LinkInfo li = weihumap.get(tmap.get("id"));

                tmap.put("date",
                        (li == null || li.getExt2() == null || li.getExt3() == null) ? "" : formatTime(li.getExt2())
                                + " 到 " + formatTime(li.getExt3()));
                tmap.put("url", (li == null || li.getLinkurl() == null) ? "" : li.getLinkurl());
            }
        }
        return serverList;
    }

    private static String formatTime(String timeStr){
        if(timeStr==null||"".equals(timeStr)){
            return "";
        }
        try {
            Date date=sdf.parse(timeStr);
            return sdfshort1.format(date);
        } catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }
}
