package com.xunlei.niux.manager.template.builder.entergame.entergamethread;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.facade.IFacadeCommon;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.*;
import com.xunlei.niux.manager.constant.LinkLocationIdConstant;
import com.xunlei.niux.manager.web.util.FreemarkerUtil;
import com.xunlei.util.StringTools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.util.CollectionUtils;

/**
 * Created by jamesjxin on 14-8-22.
 */
public class EnterGamePageBuilderThread implements Callable{
    private static final String wholePeopleGuestPath = IFacadeCommon.INSTANCE.getLibconfigValueByConfigNo("wholePeopleGuestPath");	  	
	private String templatePath;
    private String htmlFilePath;
    private Games games;
    private boolean isPreView;

    
    
    public EnterGamePageBuilderThread(String templatePath, String htmlFilePath, Games games, boolean isPreView) {
        this.templatePath = templatePath;
        this.htmlFilePath = htmlFilePath;
        this.games = games;
        this.isPreView = isPreView;
    }

    @Override
    public Object call() throws Exception {
        Map<String, Object> rootMap = new HashMap<String, Object>();
        rootMap.put("gameMap", getGameMap());
        rootMap.put("navTopAd", getNavTopAdvMap());
        rootMap.put("serverList", getSomeGameServerList());
        rootMap.put("allServerList", getAllGameServerList());
        List<Map<String, Object>> navList = getNavList();
        if (navList.size() == 0) {
            navList = null;
        }
        rootMap.put("navlist", navList);
        rootMap.put("pageMap", getPageMap());

        Map<String,String> bindMap = new HashMap<String,String>();
        Map<String,String> bindedMap = new HashMap<String,String>();
        initBindSettingMap(bindedMap,bindMap);
        rootMap.put("bindSetting", bindMap);
        rootMap.put("bindedSetting", bindedMap);
        
        FreemarkerUtil.buildHtml(templatePath, "index.html", rootMap, htmlFilePath
                + "/entergame/" + games.getGameNo(), "index.html");
        FreemarkerUtil.buildHtml(templatePath, "youke.html", rootMap, htmlFilePath
                + "/entergame/"+games.getGameNo(), "youke.html");

        return "";
    }
    
    private void initBindSettingMap(Map<String,String> bindedMap,Map<String,String> bindMap){
    	LinkInfo query = new LinkInfo();
    	query.setLinklocid("1525");//游客绑定页flash图片
        query.setGameidbytuijian(games.getGameId());
        Page page = new Page();
        page.setPageNo(1);
        page.setPageSize(1);
    	List<LinkInfo> linkinfolist = FacadeFactory.INSTANCE.getBaseSo().findObjects(query, page);
    	if(CollectionUtils.isEmpty(linkinfolist)){
    		return ;
    	}
    	LinkInfo info = linkinfolist.get(0);
    	if(info.getIstest()){//如果需要下线
    		return ;
    	}   	
    	query = new LinkInfo();
    	query.setLinklocid("1517");
    	query.setLinkid(Integer.parseInt(info.getExt1()));
    	 linkinfolist = FacadeFactory.INSTANCE.getBaseSo().findObjects(query, page);
     	 if(CollectionUtils.isEmpty(linkinfolist)){
     		  return ;
     	}
     	info = linkinfolist.get(0);
    	bindMap.put("bgImg", info.getExt1());
    	bindMap.put("flash", info.getPicurl());
    	bindMap.put("link", info.getLinkurl());   	
    	bindedMap.put("bgImg", info.getExt2());
    	bindedMap.put("flash", info.getExt3());
    	bindedMap.put("link", info.getExt4());
    }

    public Map<String, Object> getGameMap() {
        Map<String, Object> map = new HashMap<String, Object>();
        map.put("name", games.getGameName());
        map.put("nameLen", games.getGameName().length());
        map.put("id", games.getGameId());
        map.put("no", games.getGameNo());
        map.put("officialUrl", games.getOfficialWebSite() + "");
        map.put("bbsUrl", games.getForumUrl() + "");
        makeNewestServer(map);
        return map;
    }
    
    
    private void makeNewestServer(Map<String, Object> map){
    	 String serverId = checkJson();
         if(serverId != null){
         	  GameServers query = new GameServers();
         	  query.setGameId(games.getGameId());
         	  query.setServerId(serverId);
         	  GameServers server =  FacadeFactory.INSTANCE.getBaseSo().findObject(query);
         	  if(server != null){
             	  map.put("newestServer", server.getFenQuNum());
                   map.put("newestFenQuNum", server.getFenQuNum());     
                   map.put("newestServerId", serverId);
         	  }else{
         		 defaultNewestServer(map);
         	  }
         }else{
        	 defaultNewestServer(map);
         }
    }
    
    private void defaultNewestServer(Map<String, Object> map){
    	 GameServers gs= FacadeFactory.INSTANCE.getGameServersBo().getLatestGameServerByGameId(games.getGameId(), isPreView);
         String newestFenQuNum=gs==null?"":gs.getFenQuNum()+"";
         map.put("newestServer", newestFenQuNum);
         map.put("newestFenQuNum", newestFenQuNum);             
         map.put("newestServerId", gs==null?"":gs.getServerId());
    }
    
    
    private String checkJson(){
    	String serverId = null;
    	try{
    		File file = new File(wholePeopleGuestPath+"/gameimportserver.json");
        	String json = readByChar(file);
        	if(StringTools.isEmpty(json))return null;
        	try {			
    			JSONArray jsonObject = new JSONArray(json);
				for(int i=0;i<jsonObject.length();i++){
					JSONObject obj = (JSONObject)jsonObject.get(i);
					String myGameId = obj.getString("gameid");			
					if(StringTools.isEmpty(myGameId))continue;
					if(games.getGameId().trim().equals(myGameId.trim())){
						serverId = obj.getString("fenquno");
					}
				}					
    		} catch (JSONException e) {		
    			e.printStackTrace();
    		}
    	}catch(Exception e){
    	   e.printStackTrace();	
    	}
    
    	return serverId;
    }

    public  String readByChar(File file){
		BufferedReader reader=null;
		try{
			StringBuilder sb=new StringBuilder();
			reader=new BufferedReader(new InputStreamReader(new FileInputStream(file),"UTF-8"));
			char[] buf=new char[1024];
			int len=-1;
			while((len=reader.read(buf))!=-1){
				sb.append(buf,0,len);
			}
			return sb.toString();
		}catch(Exception e){
			e.printStackTrace();
		}finally{
			try{
				if(reader != null){
					reader.close();
					reader = null;
				}
			}catch(Exception e){
				e.printStackTrace();
			}
		}
		return "";
	}
    
    public List<Map<String, Object>> getSomeGameServerList() {
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        GameServers qgs = new GameServers();
        qgs.setGameId(games.getGameId());
        Page page = new Page();
        page.addOrder("fenQuNum", OrderType.DESC);
        List<GameServers> gsList = FacadeFactory.INSTANCE.getGameServersBo().find(qgs, page);
        int i = 1;
        for (GameServers gs : gsList) {
            if (i > 11) {
                break;
            }
            if ("0".equals(gs.getOpenStatus()) || "2".equals(gs.getOpenStatus())) {
                continue;
            }
            Map<String, Object> map = new HashMap<String, Object>();
            map.put("id", gs.getFenQuNum());
            map.put("name", gs.getFenQuName());
            list.add(map);
            i++;
        }
        return list;
    }
    public List<Map<String, Object>> getAllGameServerList() {
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        GameServers qgs = new GameServers();
        qgs.setGameId(games.getGameId());
        Page page = new Page();
        page.addOrder("fenQuNum", OrderType.DESC);
        List<GameServers> gsList = FacadeFactory.INSTANCE.getGameServersBo().find(qgs, page);
        for (GameServers gs : gsList) {
            if ("0".equals(gs.getOpenStatus()) || "2".equals(gs.getOpenStatus())) {
                continue;
            }
            Map<String, Object> map = new HashMap<String, Object>();
            map.put("id", gs.getFenQuNum());
            map.put("name", gs.getFenQuName());
            map.put("fenQuNum", gs.getFenQuNum());
            map.put("serverId", gs.getServerId());
            list.add(map);
        }
        return list;
    }

    /**
     * 进入游戏页左侧广告
     * @return
     */
    public Map<String,String> getNavTopAdvMap(){
        Map<String,String> navTopAdvMap=new HashMap<String,String>();
        LinkInfo li = FacadeFactory.INSTANCE.getLinkInfoBo().getGameValidteLinkInfoByLinkLocId_v2("625",games.getGameId(), isPreView);
        if(li==null){
            return null;                                          
        }
        String picUrl=li.getPicurl()==null?"":li.getPicurl();
        navTopAdvMap.put("src", picUrl);
        navTopAdvMap.put("type", picUrl.endsWith(".swf")?"flash":"img");
        navTopAdvMap.put("url", li.getLinkurl()==null?"":li.getLinkurl());
        return navTopAdvMap;
    }

    private List<Map<String, Object>> getNavList() {
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        // 获取收缩时间
        LinkInfo li = FacadeFactory.INSTANCE.getLinkInfoBo().getGameValidteLinkInfoByLinkLocId(
                LinkLocationIdConstant.NIUX_ENTERGAME_PIC, games.getGameId(), isPreView);
        if(li==null||li.getExt3()==null||"".equals(li.getExt3())||"false".equals(li.getExt3())){
            return list;
        }
        GameInsideplace gi = new GameInsideplace();
        gi.setGameid(games.getGameId());
        gi.setTitlepid("0");
        List<GameInsideplace> giplist = FacadeFactory.INSTANCE.getGameInsideplaceBo().find(gi, 1, 1000);
        for (GameInsideplace gip : giplist) {
            Map<String, Object> map = new HashMap<String, Object>();
            map.put("text", gip.getName());
            map.put("type", gip.getIsBold() ? 1 : 2);// 1：顶级菜单；2：一级菜单
            map.put("url", gip.getUrl() == null ? "" : gip.getUrl());
            map.put("subListStatus", gip.getChildexpand()?1:0);
            map.put("id", gip.getTitleid());
            // 获取二级菜单
            list.add(map);
            if (gip.getIsBold()) {
                continue;
            }
            if (gip.getUrl() != null && !"".equals(gip.getUrl())) {
                continue;
            }
            GameInsideplace pgi = new GameInsideplace();
            pgi.setGameid(games.getGameId());
            pgi.setTitlepid(gip.getTitleid());
            List<GameInsideplace> plist = FacadeFactory.INSTANCE.getGameInsideplaceBo().find(pgi, 1, 1000);
            List<Map<String, Object>> subList = new ArrayList<Map<String, Object>>();
            for (GameInsideplace cgip : plist) {
                Map<String, Object> cmap = new HashMap<String, Object>();
                cmap.put("text", cgip.getName());
                cmap.put("url", cgip.getUrl() == null ? "" : cgip.getUrl());
                cmap.put("id", cgip.getTitleid());
                subList.add(cmap);
            }
            map.put("subList", subList);
        }
        return list;
    }

    public Map<String, Object> getPageMap() {
        Map<String, Object> map = new HashMap<String, Object>();
        // 获取广告图片
        LinkInfo li=FacadeFactory.INSTANCE.getLinkInfoBo().getGameValidteLinkInfoByLinkLocId_v2(LinkLocationIdConstant.GAME_ENTERGAME,
                games.getGameId(), isPreView);
        map.put("adBigFlash", (li == null || li.getPicurl() == null) ? "" : li.getPicurl());
        map.put("adSmallImg", (li == null || li.getSmallpicurl() == null) ? "" : li.getSmallpicurl());
        map.put("adText",(li == null || li.getExt1() == null) ? "" : li.getExt1());
        map.put("adTextLink",(li == null || li.getExt2() == null) ? "" : li.getExt2());

        // 获取收缩时间
        li = FacadeFactory.INSTANCE.getLinkInfoBo().getGameValidteLinkInfoByLinkLocId(
                LinkLocationIdConstant.NIUX_ENTERGAME_PIC, games.getGameId(), isPreView);
        map.put("sideCloseTime", (li == null || li.getExt1() == null || "".equals(li.getExt1())) ? 0
                : Integer.valueOf(li.getExt1()));
        map.put("sideStatus", (li != null && li.getExt2() != null && "true".equals(li.getExt2())) ? 1 : 2);
        map.put("sideType", (li==null||li.getLinktitle()==null)?"0":li.getLinktitle());

        // 获取皮肤
        li = FacadeFactory.INSTANCE.getLinkInfoBo().getGameValidteLinkInfoByLinkLocId_v2("260",
                games.getGameId(), isPreView);
        map.put("headSkin", (li == null || li.getExt1() == null) ? "" : li.getExt1());
        map.put("sideSkin", (li == null || li.getExt2() == null) ? "" : li.getExt2());
        map.put("pageSkin", (li == null || li.getExt3() == null) ? "" : li.getExt3());
        map.put("bgImg", (li == null || li.getPicurl() == null) ? "" : li.getPicurl());
        map.put("bgColor", (li==null||li.getLinkdesc()==null)?"":li.getLinkdesc());
        PageStatisticsJs psjs=getStatisticsJsNo(games.getGameId());
        map.put("baiduId", (psjs==null||psjs.getBaiDuId()==null)?"":psjs.getBaiDuId());

        return map;
    }

    public PageStatisticsJs getStatisticsJsNo(String gameId){
        PageStatisticsJs psjs=new PageStatisticsJs();
        psjs.setGameId(gameId);
        List<PageStatisticsJs> list=FacadeFactory.INSTANCE.getPageStatisticsJsBo().findPageStatisticsJss(psjs, 1, 1);
        if(list==null||list.size()==0){
            return null;
        }
        return list.get(0);
    }
}
