package com.xunlei.niux.manager.template.builder.drawgift;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.GameServers;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.data.vipgame.vo.LinkInfo;
import com.xunlei.niux.data.vipgame.vo.activity.DrawGift;
import com.xunlei.niux.data.vipgame.vo.gift.Gift;
import com.xunlei.niux.manager.template.builder.AbstractTemplateBuilder;
import com.xunlei.niux.manager.web.cache.GameCache;
import com.xunlei.niux.manager.web.util.FreemarkerUtil;

public class DrawGiftBuilder extends AbstractTemplateBuilder{

	@Override
	public void executeShcema() throws Exception {
		Map<String,Object> rootMap=new HashMap<String,Object>();
		rootMap.put("giftList", getGiftList());
		initBgPic(rootMap);//初始化背景图
		initTuiJianGameServer(rootMap);
		String htmlFilePath = isPreView ? htmlTemplate.getPreviewhtmlroot() : htmlTemplate.getHtmlroot();
		if (htmlFilePath.endsWith("/")) {
			htmlFilePath = htmlFilePath.substring(0, htmlFilePath.length() - 1);
		}
		FreemarkerUtil.buildHtml(htmlTemplate.getTemplateroot(), "config.chouvip.php", rootMap, htmlFilePath, "config.chouvip.php");
	}
	private void initTuiJianGameServer(Map<String,Object> rootMap){
		LinkInfo li=FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoByLinkLocId_V2("617", this.isPreView);
		if(li==null){
			throw new RuntimeException("推荐区服不存在");
		}
		Games game=GameCache.getInstance().getGameByGameId(li.getGameidbytuijian());
		if(game==null){
			throw new RuntimeException("区服不存在");
		}
		Integer fenQuNum=Integer.valueOf(li.getExt1());
		GameServers query=new GameServers();
		query.setGameId(game.getGameId());
		query.setFenQuNum(fenQuNum);
		GameServers gameServer=FacadeFactory.INSTANCE.getBaseSo().findObject(query);
		if(gameServer==null){
			throw new RuntimeException("对应区服不存在");
		}
		rootMap.put("gameid", game.getGameId());
		rootMap.put("gameno", game.getGameNo());
		rootMap.put("gamename", game.getGameName());
		rootMap.put("serverid", gameServer.getServerId());
		rootMap.put("fenQuNum", gameServer.getFenQuNum());
		rootMap.put("fenQuName", gameServer.getFenQuName());
		rootMap.put("picUrl", li.getPicurl());
		rootMap.put("limitLevel",li.getExt2());
	}
	private void initBgPic(Map<String,Object> rootMap){
		LinkInfo li=FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoByLinkLocId_V2("616", this.isPreView);
		if(li==null){
			throw new RuntimeException("背景图不存在");
		}
		rootMap.put("chouPicUrl", li.getPicurl()==null?"":li.getPicurl());
		rootMap.put("urlMore", li.getLinkurl()==null?"":li.getLinkurl());
	}
	
	/**
	 * 礼包
	 * @return
	 */
	private List<Map<String,Object>> getGiftList(){
		List<Map<String,Object>> giftList=new ArrayList<Map<String,Object>>();
		List<DrawGift> list=FacadeFactory.INSTANCE.getBaseSo().findObjects(new DrawGift(), new Page());
		if(list==null||list.size()==0){
			return giftList;
		}
		Map<Integer,DrawGift> mapGift=new HashMap<Integer,DrawGift>();
		for(DrawGift drawGift:list){
			mapGift.put(drawGift.getDrawIndex(), drawGift);
		}
		double lastTotalRate=0;
		for(int i=1;i<8;i++){
			DrawGift drawGift=mapGift.get(i);
			if(drawGift==null){
				throw new RuntimeException("转盘第["+i+"]块没有礼包");
			}
			Gift gift=FacadeFactory.INSTANCE.getBaseSo().findById(Gift.class, drawGift.getGiftId());
			if(gift==null){
				throw new RuntimeException("礼包id["+drawGift.getGiftId()+"]对应礼包不存在");
			}
			lastTotalRate=lastTotalRate+drawGift.getDrawProbability();
			lastTotalRate=Double.valueOf(new DecimalFormat("#.000").format(lastTotalRate));
			if(lastTotalRate>1){
				throw new RuntimeException("总积分超过1");
			}
			Map<String,Object> map=new HashMap<String,Object>();
			map.put("drawIndex", drawGift.getDrawIndex());
			map.put("giftid", drawGift.getGiftId());
			map.put("giftname", gift.getGiftName());
			map.put("gifttype", gift.getGiftType());
			map.put("chouRateEnd", lastTotalRate+"");
			map.put("chouRate", drawGift.getDrawProbability());
			map.put("cntLimit", drawGift.getOneDayMaxDrawNum());
			giftList.add(map);
		}
		return giftList;
	}
}
