package com.xunlei.niux.manager.template.builder.daquan;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.GameServers;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.data.vipgame.vo.LinkInfo;
import com.xunlei.niux.manager.constant.LinkLocationIdConstant;
import com.xunlei.niux.manager.template.builder.AbstractTemplateBuilder;
import com.xunlei.niux.manager.web.cache.GameCache;
import com.xunlei.niux.manager.web.util.FileUploadUtil;
import com.xunlei.niux.manager.web.util.FileUtil;
import com.xunlei.niux.manager.web.util.FreemarkerUtil;
import com.xunlei.util.StringTools;

public class DaQuanTemplateBuilder extends AbstractTemplateBuilder {
	private boolean ispreview = false;//是否预览
	private static final String ENTERURL = "http://niu.xunlei.com/entergame/";
	
	public void executeShcema() throws Exception {
		Map<String,Object> rootMap=new HashMap<String,Object>();
		rootMap.put("lunbotulist", getLunBoTu());
		rootMap.put("weekgamelist", getWeekTuiJianGame());
		rootMap.put("tuijiangamelist", getTuiJianGame());
		rootMap.put("hotgamelist", getHotGame());
		rootMap.put("hotadvlist", getHotAdv());
		rootMap.put("latestgamelist", getLatestGame());
		//rootMap.put("latestfenqulist", getLatestFenQu());
		rootMap.put("latestfenqulist", getLatestServer());
		FreemarkerUtil.buildHtml(htmlTemplate.getTemplateroot(),"index.ftl", rootMap, getHtmlRoot()+"/daquan", "index.html");
		FreemarkerUtil.buildHtml(htmlTemplate.getTemplateroot(),"daquan.ftl", rootMap, getHtmlRoot()+"/actives/act_daquan/", "index.html");
		buildSearchGamesXml();
	}
	/**
	 * 生成大全搜索的游戏信息
	 */
	private void buildSearchGamesXml()throws Exception{
		List<LinkInfo> list=FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoListByLinkLocId("239", 500, isPreView);
		StringBuilder sb=new StringBuilder();
		sb.append("<games>");
		for(LinkInfo li:list){
			Games game=GameCache.getInstance().getGameByGameId(li.getGameidbytuijian());
			if(game==null){
				continue;
			}
			GameServers latestgameserver=FacadeFactory.INSTANCE.getGameServersBo().getLatestGameServerByGameId(game.getGameId(), false);
			
			sb.append("<game>");
			sb.append("<seqid>").append(game.getSeqId()).append("</seqid>");
			sb.append("<name>").append(game.getGameName()).append("</name>");
			sb.append("<img>").append(li.getPicurl()).append("</img>");
			String type="";
			if("1".equals(game.getGameType())){
				type="角色扮演";
			}else if ("2".equals(game.getGameType())){
				type="写实";
			}else if ("3".equals(game.getGameType())){
				type="Q版";
			}else if ("4".equals(game.getGameType())){
				type="战争策略";
			}
			sb.append("<type>").append(type).append("</type>");
			sb.append("<describe>").append(formatXml(game.getGameDesc())).append("</describe>");
			sb.append("<officialwebsite>").append(formatXml(game.getOfficialWebSite())).append("</officialwebsite>");
			sb.append("<displayorder>").append(game.getDisplayOrder()).append("</displayorder>");
			if(latestgameserver==null){
				sb.append("<latestfenquname>").append("").append("</latestfenquname>");
				sb.append("<latestfenquopentime>").append("").append("</latestfenquopentime>");
				sb.append("<latestfenquopenurl>").append("").append("</latestfenquopenurl>");
			}else{
				sb.append("<latestfenquname>").append(formatXml(latestgameserver.getFenQuName())).append("</latestfenquname>");
				sb.append("<latestfenquopentime>").append(latestgameserver.getOpenTime()).append("</latestfenquopentime>");
				sb.append("<latestfenquopenurl>http://niu.xunlei.com/entergame?gameNo=").append(game.getGameNo())
				.append("&amp;fenQuNum=").append(latestgameserver.getFenQuNum()).append("&amp;</latestfenquopenurl>");
			}
			sb.append("</game>");
		}
		sb.append("</games>");
		String htmlFilePath=isPreView?htmlTemplate.getPreviewhtmlroot():htmlTemplate.getHtmlroot();
	    File file=FileUtil.createFile(htmlFilePath+"/daquan", "searchgameinfo.xml");
	    FileUploadUtil.write(file, sb.toString());
	}
	private static String formatXml(String value){
		if(value==null){
			return null;
		}
		value=value.replaceAll("&", "&amp;");
		value=value.replaceAll("<", "&lt;");
		value=value.replaceAll(">", "&gt;");
		return value;
	}
	private List<Map<String,Object>> getLunBoTu(){
		List<Map<String,Object>> result=new ArrayList<Map<String,Object>>();
		List<LinkInfo> list=FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoListByLinkLocId("216", 5, isPreView);
		for(LinkInfo li:list){
			Map<String,Object> map=new HashMap<String,Object>();
			map.put("title", li.getLinktitle()==null?"":li.getLinktitle());
			map.put("picurl", li.getPicurl()==null?"":li.getPicurl());
			String gameid = li.getGameidbytuijian();
			if(!StringTools.isEmpty(gameid)){//如果选择了游戏，则取官网地址
				Games games = GameCache.getInstance().getGameByGameId(gameid);
				GameServers servers = new GameServers();
				servers.setGameId(gameid);
				servers.setOpenStatus("1");//已开区
				Page gspage = new Page();
				gspage.setPageNo(1);
				gspage.setPageSize(1);
				gspage.addOrder("openTime", OrderType.DESC);
				List<GameServers> gslist = FacadeFactory.INSTANCE.getGameServersBo().find(servers, gspage);
				if(gslist !=null){
					GameServers gs = gslist.get(0);//最新区
					map.put("linkurl",ENTERURL+games.getGameNo()+"/?fenQuNum="+gs.getFenQuNum());
				}				
			}else{
				map.put("linkurl", li.getLinkurl()==null?"":li.getLinkurl());
			}			
			result.add(map);
		}
		return result;
	}
	private List<Map<String,Object>> getHotAdv(){
		List<Map<String,Object>> result=new ArrayList<Map<String,Object>>();
		List<LinkInfo> list=FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoListByLinkLocId("220", 4, isPreView);
		for(LinkInfo li:list){
			Map<String,Object> map=new HashMap<String,Object>();
			map.put("title", li.getLinktitle()==null?"":li.getLinktitle());
			map.put("picurl", li.getPicurl()==null?"":li.getPicurl());
			map.put("linkurl", li.getLinkurl()==null?"":li.getLinkurl());
			result.add(map);
		}
		return result;
	}
	private List<Map<String,Object>> getWeekTuiJianGame(){
		List<Map<String,Object>> result=new ArrayList<Map<String,Object>>();
		LinkInfo li=FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoByLinkLocId("217", isPreView);
		if(li!=null){
			Map<String,Object> map=new HashMap<String,Object>();
			map.put("desc", li.getLinkdesc()==null?"":li.getLinkdesc());
			map.put("picurl", li.getPicurl()==null?"":li.getPicurl());
			Games game=GameCache.getInstance().getGameByGameId(li.getGameidbytuijian());
			map.put("gameno", game.getGameNo());
			map.put("clientType", game.getLoadClientType()==null?"0":game.getLoadClientType()+"");
			map.put("officialurl", game.getOfficialWebSite()==null?"":game.getOfficialWebSite());
			result.add(map);
		}
		return result;
	}
	private List<Map<String,Object>> getTuiJianGame(){
		List<Map<String,Object>> result=new ArrayList<Map<String,Object>>();
		List<LinkInfo> list=FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoListByLinkLocId("218", 4, isPreView);
		for(LinkInfo li:list){
			Map<String,Object> map=new HashMap<String,Object>();
			map.put("desc", li.getLinkdesc()==null?"":li.getLinkdesc());
			map.put("picurl", li.getPicurl()==null?"":li.getPicurl());
			Games game=GameCache.getInstance().getGameByGameId(li.getGameidbytuijian());
			map.put("gameno", game.getGameNo());
			map.put("gameName", game.getGameName());
			map.put("officialurl", game.getOfficialWebSite());
			map.put("clientType", game.getLoadClientType()==null?"0":game.getLoadClientType()+"");
			result.add(map);
		}
		return result;
	}
	private List<Map<String,Object>> getHotGame(){
		List<Map<String,Object>> result=new ArrayList<Map<String,Object>>();
		List<LinkInfo> list=FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoListByLinkLocId("219", 5000, isPreView);
		for(LinkInfo li:list){
			Map<String,Object> map=new HashMap<String,Object>();
			map.put("desc", li.getLinkdesc()==null?"":li.getLinkdesc());
			map.put("picurl", li.getPicurl()==null?"":li.getPicurl());
			Games game=GameCache.getInstance().getGameByGameId(li.getGameidbytuijian());
			map.put("gameno", game.getGameNo());
			map.put("gameName", game.getGameName());
			map.put("officialurl", game.getOfficialWebSite());
			map.put("clientType", game.getLoadClientType()==null?"0":game.getLoadClientType()+"");
			result.add(map);
		}
		return result;
	}
	private List<Map<String,Object>> getLatestGame(){
		List<Map<String,Object>> result=new ArrayList<Map<String,Object>>();
		List<LinkInfo> list=FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoListByLinkLocId("222", 10, isPreView);
		for(LinkInfo li:list){
			Map<String,Object> map=new HashMap<String,Object>();
			Games game=GameCache.getInstance().getGameByGameId(li.getGameidbytuijian());
			map.put("gameno", game.getGameNo());
			map.put("gameName", game.getGameName());
			map.put("officialurl", game.getOfficialWebSite());
			map.put("clientType", game.getLoadClientType()==null?"0":game.getLoadClientType()+"");
			LinkInfo picli=FacadeFactory.INSTANCE.getLinkInfoBo().getGameValidteLinkInfoByLinkLocId(LinkLocationIdConstant.GAME_LOGO, li.getGameidbytuijian(), isPreView);
			if(picli!=null){
				map.put("picurl", picli.getPicurl()==null?"":picli.getPicurl());
			}else{
				map.put("picurl", "");
			}
			result.add(map);
		}
		return result;
	}
	
	/**
	 * 获得最新区服数据，跟牛X官网一样
	 * @return add by lisu 2013-10-21
	 */
	private List<Map<String,Object>> getLatestServer(){
		List<Map<String,Object>> result=new ArrayList<Map<String,Object>>();
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		Calendar cal = Calendar.getInstance();
		cal.add(Calendar.DAY_OF_MONTH, 1);	
		String tomorrow = sdf.format(cal.getTime());//获得明天的日期	
		//获得后台录入的 首页最新开服列表中的数据
		LinkInfo linkInfo = new LinkInfo();
	    linkInfo.setLinklocid("1240");//牛x官网开服列表
	    Page page = new Page();
	    page.addOrder("validdatetime", OrderType.DESC);//按照生效时间逆序
	    List<LinkInfo> list = FacadeFactory.INSTANCE.getLinkInfoBo().find(linkInfo, page);	    
	    if(list == null||list.size()==0)return null;
	    
	    //获得游戏的区服信息
	    GameServers qgs=new GameServers();
	    qgs.setOpenStatus("1");//状态为 “已开区”
		qgs.setToopentime(tomorrow+" 00:00:00");//只取今天以前的数据，其中包含今天的
		Page page1 = new Page();
		page1.addOrder("openTime", OrderType.DESC);
		List<GameServers> serverList=FacadeFactory.INSTANCE.getGameServersBo().find(qgs, page1);
		int jj = 0;
		boolean flag = true;
		for(GameServers server:serverList){		
			if(flag){
				for(int i=0;i<list.size();i++){				
					LinkInfo li=list.get(i);
				    if(server.getGameId().trim().equals(li.getGameidbytuijian().trim())&&(server.getFenQuNum()+"").equals(li.getExt1().trim())){
				    	//获取logo图片
						LinkInfo logoli=FacadeFactory.INSTANCE.getLinkInfoBo().getGameValidteLinkInfoByLinkLocId(LinkLocationIdConstant.GAME_LOGO, li.getGameidbytuijian(), ispreview);
						//游戏信息
						Games game=FacadeFactory.INSTANCE.getGamesBo().getGameByGameId(li.getGameidbytuijian());		               					
						Map<String,Object> map=new HashMap<String,Object>();
						String opentime = server.getOpenTime();
						map.put("openTime", opentime);
						map.put("gameName", game.getGameName());
						map.put("gameno", game.getGameNo());
						map.put("officialurl",game.getOfficialWebSite());
						map.put("fenQuNum", server.getFenQuNum());
						map.put("clientType", game.getLoadClientType()==null?"0":game.getLoadClientType()+"");
						map.put("picurl", logoli==null?"":logoli.getPicurl());
						result.add(map);
						jj ++;
						if(jj>=20){
							flag = false;
							break;//取其中20条记录
						}
				    }												
				}
			}			
		}
		System.out.println("result:"+result);
		return result;
	}
	
	/**
	 * 获得最新区服数据，需要独自维护
	 * @return
	 */
	private List<Map<String,Object>> getLatestFenQu(){
		List<Map<String,Object>> result=new ArrayList<Map<String,Object>>();
		List<LinkInfo> list=FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoListByLinkLocId("221", 20, isPreView);
		int index=0;
		for(LinkInfo li:list){
			if(index>9){
				break;
			}
			GameServers gs=findGameServer(li.getGameidbytuijian(), Integer.valueOf(li.getExt1()));
			if(gs==null){
				continue;
			}
			if(!"1".equals(gs.getOpenStatus())){
				continue;
			}
			Games game=GameCache.getInstance().getGameByGameId(li.getGameidbytuijian());
			Map<String,Object> map=new HashMap<String,Object>();
			map.put("gameno", game.getGameNo());
			map.put("gameName", game.getGameName());
			map.put("officialurl", game.getOfficialWebSite());
			map.put("clientType", game.getLoadClientType()==null?"0":game.getLoadClientType()+"");
			LinkInfo picli=FacadeFactory.INSTANCE.getLinkInfoBo().getGameValidteLinkInfoByLinkLocId(LinkLocationIdConstant.GAME_LOGO, li.getGameidbytuijian(), isPreView);
			if(picli!=null){
				map.put("picurl", picli.getPicurl()==null?"":picli.getPicurl());
			}else{
				map.put("picurl", "");
			}
			map.put("fenQuNum", li.getExt1());
			map.put("openTime", gs.getOpenTime());
			result.add(map);
		}
		return result;
	}
	private GameServers findGameServer(String gameId,int fenQuNum){
		GameServers qgs=new GameServers();
		qgs.setGameId(gameId);
		qgs.setFenQuNum(fenQuNum);
		List<GameServers> list=FacadeFactory.INSTANCE.getGameServersBo().find(qgs, new Page());
		return (list==null||list.size()==0)?null:list.get(0);
	}
}
