
package com.xunlei.niux.manager.template.builder.coin;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.Advice;
import com.xunlei.niux.data.vipgame.vo.LinkInfo;
import com.xunlei.niux.manager.constant.LinkLocationIdConstant;
import com.xunlei.niux.manager.template.builder.AbstractTemplateBuilder;
import com.xunlei.niux.manager.web.util.FreemarkerUtil;

import org.apache.commons.lang.StringUtils;

/**
 * 生成游戏官网
 * 
 * @author Administrator
 * 
 */
public class CoinOfficialBuilder extends AbstractTemplateBuilder {
    private String templateRoot;
    private String htmlFilePath;
	private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

	@Override
	public void executeShcema() throws Exception {
        
        templateRoot = htmlTemplate.getTemplateroot();
        if(templateRoot.endsWith("/")){
            templateRoot = templateRoot.substring(0,templateRoot.length()-1);
        }
        
        htmlFilePath = isPreView ? htmlTemplate.getPreviewhtmlroot() : htmlTemplate.getHtmlroot();
        if (htmlFilePath.endsWith("/")) {
            htmlFilePath = htmlFilePath.substring(0, htmlFilePath.length() - 1);
        }

        executeWebGameTemplate();
	}
	
    private void executeWebGameTemplate(){
        Map<String, Object> rootMap = new HashMap<String, Object>();
        
        //轮播图
        rootMap.put("sliderImgList", getsliderImgList(LinkLocationIdConstant.NIUX_COIN));
        
        //公告
        rootMap.put("gongaoInfoMap", buildGonggaoList(LinkLocationIdConstant.NIUX_GONGAO));
        
        //文章
        rootMap.put("articleInfoMap", buildArticleList(1, 10000, null, false));
        
//		//测试
//        templateRoot="d:/templatefile/niuxhlg/";
//        htmlFilePath="d:/template/niuxhlg/";
        
        FreemarkerUtil.buildHtml(templateRoot+"/include/", "carousel.html", rootMap,
        		htmlFilePath+"/include/", "carousel.html");
        FreemarkerUtil.buildHtml(templateRoot+"/include/", "activity.html", rootMap,
        		htmlFilePath+"/include/", "activity.html");
        FreemarkerUtil.buildHtml(templateRoot, "articles.shtml", rootMap,
        		htmlFilePath, "articles.shtml");
    }
    
	/**
	 * 获取轮播图
	 * 
	 * @return
	 */
	private List<Map<String, String>> getsliderImgList(String linklocId) {
		List<Map<String, String>> list = new ArrayList<Map<String, String>>();
		List<LinkInfo> lilist = FacadeFactory.INSTANCE.getLinkInfoBo()
				.getValidteLinkInfoListByLinkLocId(linklocId, 6, false);
		for (LinkInfo li : lilist) {
			Map<String, String> map = new HashMap<String, String>();
			map.put("url", li.getLinkurl());
			map.put("img", li.getPicurl());
			list.add(map);
		}
		return list;
	}
	
	/**
	 * 获取轮播图
	 * 
	 * @return
	 */
	private List<Map<String, String>> buildGonggaoList(String linklocId) {
		List<Map<String, String>> list = new ArrayList<Map<String, String>>();
		List<LinkInfo> lilist = FacadeFactory.INSTANCE.getLinkInfoBo()
				.getValidteLinkInfoListByLinkLocId(linklocId, 6, false);
		for (LinkInfo li : lilist) {
			Map<String, String> map = new HashMap<String, String>();
			map.put("url", li.getLinkurl());
			map.put("img", li.getPicurl());
			list.add(map);
		}
		return list;
	}



	private List<Map<String, String>> buildArticleList(int pageNo, int pageSize, String type, boolean isSingle) {
		Advice advice = new Advice();
		advice.setAdviceType("5");
		if (isSingle) {
			advice.setPlatformno(type);
		} else {
			advice.setExt1(type);
		}
		advice.setLePublishDate(sdf.format(new Date()));
		Page page = new Page();
		page.setPageNo(pageNo);
		page.setPageSize(pageSize);
		page.addOrder("displayOrder", OrderType.ESC);
		page.addOrder("publishDate", OrderType.DESC);
		List<Advice> list = FacadeFactory.INSTANCE.getAdviceBo().findAdvice(advice, page);
		String nowStr=sdf.format(new Date());
		List<Map<String, String>> mapList = new ArrayList<Map<String, String>>();
		for (Advice ad : list) {
			Map<String, String> map = new HashMap<String, String>();
			map.put("typeId", ad.getPlatformno());
			map.put("aid", ad.getSeqId() + "");
			map.put("title", ad.getTitle());
			map.put("url", ad.getJumpUrl() + "");
			map.put("date", ad.getPublishDate().substring(0, 10));
            boolean isRemoveRedBold=false;
            if(StringUtils.isNotEmpty(ad.getRemoveFlagTime())){
                isRemoveRedBold=nowStr.compareTo(ad.getRemoveFlagTime())>=0;
            }
			
			map.put("isColor", ad.getRed()&&isRemoveRedBold==false ? "yes" : "no");
			map.put("isStrong", ad.getBold()&&isRemoveRedBold==false ? "yes" : "no");
			mapList.add(map);
		}
		return mapList;
	}

	
}

