package com.xunlei.niux.manager.template.builder.bonusmarket;

import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.LinkInfo;
import com.xunlei.niux.manager.constant.LinkLocationIdConstant;
import com.xunlei.niux.manager.web.util.FreemarkerUtil;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;

/**
 * Created by jamesjxin on 15-2-3.
 */
public class JIFenPageBuilder implements Callable {

    private String rootPath;
    private String htmlPath;
    private boolean isPreView;

    public JIFenPageBuilder(String rootPath, String htmlPath, boolean isPreView) {
        this.rootPath = rootPath;
        this.htmlPath = htmlPath;
        this.isPreView = isPreView;
    }

    @Override
    public Object call() throws Exception {
        Map<String, Object> rootMap = new HashMap<String, Object>();
        rootMap.put("actBonusMap", getJiFenAct());
        FreemarkerUtil.buildHtml(rootPath + "u/", "jifen.html", rootMap, htmlPath + "u/", "jifen.html");
        return "";
    }

    private Map<String, Object> getJiFenAct() {
        List<LinkInfo> lilist = FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoListByLinkLocId_V2(LinkLocationIdConstant.NIUX_MYAREA_JFFENACT, 1, false);
        if (lilist == null || lilist.size() == 0) return null;
        LinkInfo info = lilist.get(0);
        Map<String, Object> map = new HashMap<String, Object>();
        map.put("title", info.getLinktitle());
        map.put("url", info.getLinkurl());
        return map;
    }
}
