package com.xunlei.niux.manager.template.builder.bonusmarket;


import com.xunlei.niux.manager.template.builder.AbstractTemplateBuilder;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;


/**
 * 牛x平台积分商城模版
 *
 * @author lisu
 *         2015-01-26
 */
public class BonusMarketBuilder extends AbstractTemplateBuilder {

    private String rootPath;
    private String htmlPath;
    private boolean isPreView;

    private ExecutorService executorService;

    @Override
    public void executeShcema() throws Exception {
        executorService = Executors.newCachedThreadPool();

        String rootPath = htmlTemplate.getTemplateroot();
        if (!rootPath.endsWith("/")) {
            rootPath += "/";
        }
        String htmlPath = htmlTemplate.getHtmlroot();
        if (!htmlPath.endsWith("/")) {
            htmlPath += "/";
        }
        Future future1 = executorService.submit(new JiFenShopIndexPageBuilder(rootPath, htmlPath, false));
        Future future2 = executorService.submit(new BonusExchangeBuilder(rootPath, htmlPath, false));
        Future future3 = executorService.submit(new JIFenPageBuilder(rootPath,htmlPath,false));
        Future future4 = executorService.submit(new LotteryPageBuilder(rootPath,htmlPath,false));
        Future future5 = executorService.submit(new FAQPageBuilder(rootPath,htmlPath,false));
        Future future6 = executorService.submit(new BonusActivityBuilder(rootPath,htmlPath,false));

        future1.get();
        future2.get();
        future3.get();
        future4.get();
        future5.get();
        future6.get();

        executorService.shutdown();
    }




}
