package com.xunlei.niux.gameoffical.template.v2.builder;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import com.xunlei.niux.easyutils.propertyutils.EnvPropertyUtil;

import org.apache.log4j.Logger;

import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.GameContent;
import com.xunlei.niux.data.vipgame.vo.GameExpand;
import com.xunlei.niux.data.vipgame.vo.GameImg;
import com.xunlei.niux.data.vipgame.vo.GameScreenshotImage;
import com.xunlei.niux.data.vipgame.vo.GameServers;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.data.vipgame.vo.LinkInfo;
import com.xunlei.niux.data.vipgame.vo.PageStatisticsJs;
import com.xunlei.niux.gameoffical.template.v2.vo.GameBgVo;
import com.xunlei.niux.gameoffical.template.v2.vo.GameFenquVo;
import com.xunlei.niux.gameoffical.template.v2.vo.GameGongGaoVo;
import com.xunlei.niux.gameoffical.template.v2.vo.GameGongLueVo;
import com.xunlei.niux.gameoffical.template.v2.vo.GameInfoVo;
import com.xunlei.niux.gameoffical.template.v2.vo.GameJieTuVo;
import com.xunlei.niux.gameoffical.template.v2.vo.GameLunTangVo;
import com.xunlei.niux.gameoffical.template.v2.vo.GameScrollPicVo;
import com.xunlei.niux.gameoffical.template.v2.vo.GameTeSeVo;
import com.xunlei.niux.gameoffical.template.v2.vo.GameZiLiaoVo;
import com.xunlei.niux.manager.constant.LinkLocationIdConstant;
import com.xunlei.niux.manager.web.util.Base64Util;

/**
 * 获取模板需要的数据
 * @author lin
 * @date 2012-9-12
 * @Descripter:
 */
public class TempDataBuilder {
	private static final Logger logger=Logger.getLogger(TempDataBuilder.class.getName());
	private static final SimpleDateFormat sdf1=new SimpleDateFormat("yyyy-MM-dd mm:HH:ss");
	private static final SimpleDateFormat sdf2=new SimpleDateFormat("MM-dd");
	private static String payUrl=EnvPropertyUtil.loadProperty("GameOfficalTemplateV2","payUrl").trim();
	private static String IMG_DOMAIN=EnvPropertyUtil.loadProperty("GameOfficalTemplateV2","img_domain").trim();
	/**
	 * 获取背景图url
	 * @param gameFK
	 * @return
	 */
	public static String getBgUrl(long gameFK){
		GameImg gameImg=new GameImg();
		gameImg.setAlreadyDelete(false);
		gameImg.setImgType("BackgroudImg");
		gameImg.setGameFK(gameFK);
		List<GameImg> list=FacadeFactory.INSTANCE.getGameImgBo().findGameImg(gameImg, 1, 1);
		if(list==null||list.size()==0){
			return "";
		}
		GameImg gi=list.get(0);
		if(gi==null){
			return "";
		}
		return gi.getImgUrl();
	}
	public static String getFlashUrl(String gameId){
		LinkInfo li=FacadeFactory.INSTANCE.getLinkInfoBo().getGameValidteLinkInfoByLinkLocId(LinkLocationIdConstant.GAME_OFFICIAL_FLASH, gameId, false);
		if(li==null){
			return "";
		}
		return li.getPicurl()==null?"":li.getPicurl();
	}
	public static GameBgVo getGameBg(long gameFK){
		GameImg gameImg=new GameImg();
		gameImg.setAlreadyDelete(false);
		gameImg.setImgType("BackgroudImg");
		gameImg.setGameFK(gameFK);
		List<GameImg> list=FacadeFactory.INSTANCE.getGameImgBo().findGameImg(gameImg, 1, 1);
		GameBgVo gameBg=new GameBgVo();
		if(list==null||list.size()==0){
			return gameBg;
		}
		GameImg gi=list.get(0);
		if(gi.getImgUrl()!=null){
			gameBg.setBgImgUrl(IMG_DOMAIN+"/"+gi.getImgUrl());
		}else{
			gameBg.setBgImgUrl(IMG_DOMAIN+"/");
		}
		String bgcolorcode=gi.getRemark();
		bgcolorcode=Base64Util.decode(bgcolorcode);
		int index=bgcolorcode.indexOf("#");
		if(index>=0&&index+7<=bgcolorcode.length()){
			bgcolorcode=bgcolorcode.substring(index,index+7);
		}
		System.out.println("颜色："+bgcolorcode);
		if(bgcolorcode!=null&&bgcolorcode.startsWith("#")&&bgcolorcode.length()==7){
			gameBg.setBgColorCode(bgcolorcode);
		}
		return gameBg;
	}
	/**
	 * 获取游戏截图
	 * @param gameFK
	 * @return
	 */
	public static List<GameJieTuVo>  getGameJieTu(long gameFK){
		List<GameJieTuVo> list=new ArrayList<GameJieTuVo>();
		GameScreenshotImage qgssi=new GameScreenshotImage();
		qgssi.setAlreadyDelete(false);
		qgssi.setGameFK(gameFK);
		List<GameScreenshotImage> gssilist=FacadeFactory.INSTANCE.getGameScreenshotImageBo().findGameScreenshotImage(qgssi, 1, 4);
		for(GameScreenshotImage gssi:gssilist){
			GameJieTuVo jt=new GameJieTuVo();
			jt.setImgUrl(gssi.getSmallImgUrl());
			jt.setTitle(gssi.getImgName());
			jt.setLink(gssi.getBigImgUrl());
			list.add(jt);
		}
		return list;
	}
	/**
	 * 获取游戏轮播图
	 * @param gameFK
	 * @return
	 */
	public static List<GameScrollPicVo> getScrollPic(long gameFK){
		List<GameScrollPicVo> list=new ArrayList<GameScrollPicVo>();
		GameImg gameImg=new GameImg();
		gameImg.setAlreadyDelete(false);//未删除
		gameImg.setGameFK(gameFK);//游戏主键
		gameImg.setImgType("LoopImg");//轮播图
		gameImg.setToPublishDate(sdf1.format(new Date()));
		List<GameImg>  gilist=FacadeFactory.INSTANCE.getGameImgBo().findGameImg(gameImg, 1, 5);
		for(GameImg gi:gilist){
			GameScrollPicVo scpv=new GameScrollPicVo();
			scpv.setImgUrl(gi.getImgUrl());
			scpv.setLink(gi.getJumpUrl());
			scpv.setTitle(gi.getImgName());
			list.add(scpv);
		}
		return list;
	}
	public static List<GameFenquVo> getAllFenQu(long gameFK){
		List<GameFenquVo> list=new ArrayList<GameFenquVo>();
		Games games=FacadeFactory.INSTANCE.getGamesBo().findGamesById(gameFK);
		GameServers gameServer= new GameServers();
		gameServer.setOpenStatus("1");//开区状态 已开区
		gameServer.setGameId(games.getGameId());	
		List<GameServers> gsList=FacadeFactory.INSTANCE.getGameServersBo().findGameServers(gameServer, 0, 0);
		for(GameServers gs:gsList){
			GameFenquVo fenqu=new GameFenquVo();
			fenqu.setGameNo(games.getGameNo());
			fenqu.setFenQuName(gs.getFenQuName());
			fenqu.setFenQuNum(gs.getFenQuNum());
			fenqu.setOpenTime(gs.getOpenTime());
			fenqu.setGameId(gs.getGameId());
			fenqu.setFenQuNickName((gs.getFenQuNickName()==null||"".equals(gs.getFenQuNickName()))?gs.getFenQuName():gs.getFenQuNickName());
			list.add(fenqu);
		}
		return list;
	}
	/**
	 * 获取推荐的游戏
	 * @param gameFK
	 * @return
	 */
	public static List<GameInfoVo> getTuiJianGameList(long gameFK){
		List<GameInfoVo>  list=new ArrayList<GameInfoVo>();
		GameExpand gameExpand=new GameExpand();
		gameExpand.setAlreadyDelete(false);
		gameExpand.setGameFK(gameFK);
		List<GameExpand> gelist=FacadeFactory.INSTANCE.getGameExpandBo().findGameExpand(gameExpand, 1, 4);
		for(GameExpand ge:gelist){
			
			Games games=FacadeFactory.INSTANCE.getGamesBo().findGamesById(ge.getRecommendGameFK());
			GameImg queryLog=new GameImg();
			queryLog.setAlreadyDelete(false);
			queryLog.setGameFK(ge.getRecommendGameFK());
			queryLog.setImgType("Logo");
			List<GameImg> logList=FacadeFactory.INSTANCE.getGameImgBo().findGameImg(queryLog, 1, 1);
			if(games==null){
				logger.error("seqid="+ge.getGameFK()+"对应的游戏不存在");
				continue;
			}
			GameInfoVo gi=new GameInfoVo();
			gi.setGameDesc(games.getGameDesc());
			gi.setGameName(games.getGameName());
			gi.setGameNo(games.getGameNo());
			gi.setGameOffical(games.getOfficialWebSite());
			gi.setLunTangUrl(games.getForumUrl());
			gi.setRunStatus(games.getRunStatus());
			gi.setRed(ge.getRed());
			gi.setBold(ge.getBold());
			if(logList!=null&&logList.size()>0){
				GameImg gimg=logList.get(0);
				gi.setLogoUrl(gimg.getImgUrl());
			}
			list.add(gi);
		}
		return list;
	}
	/**
	 * 获取所有的游戏信息
	 * @return
	 */
	public static List<GameInfoVo> getAllGameList(){
		List<GameInfoVo> list=new ArrayList<GameInfoVo>();
		Games g=new Games();
		g.setStatus("1");//游戏已经接入
		List<Games> gamesList=FacadeFactory.INSTANCE.getGamesBo().findGames(g, 0, 0);
		for(Games games:gamesList){
			GameInfoVo gi=new GameInfoVo();
			gi.setGameDesc(games.getGameDesc());
			gi.setGameName(games.getGameName());
			gi.setGameNo(games.getGameNo());
			gi.setGameOffical(games.getOfficialWebSite());
			gi.setLunTangUrl(games.getForumUrl());
			gi.setRunStatus(games.getRunStatus());
			gi.setGameId(games.getGameId());
			gi.setClientType(games.getClientType());
			list.add(gi);
		}
		return list;
	}
	/**
	 * 获取游戏信息
	 * @param gameFK
	 * @return
	 */
	public static GameInfoVo getGameInfo(long gameFK){
		Games games=FacadeFactory.INSTANCE.getGamesBo().findGamesById(gameFK);
		GameInfoVo gi=new GameInfoVo();
		gi.setGameDesc(games.getGameDesc());
		gi.setGameName(games.getGameName());
		gi.setGameNo(games.getGameNo());
		gi.setGameOffical(games.getOfficialWebSite());
		gi.setLunTangUrl(games.getForumUrl());
		gi.setRunStatus(games.getRunStatus());
		gi.setSeqId(games.getSeqId());
		gi.setGameId(games.getGameId());
        gi.setClientType(games.getClientType()); 
        gi.setLoadClientType(games.getLoadClientType());
		String gameOff=games.getOfficialWebSite();
		gameOff=gameOff==null?"":gameOff.replaceAll("http://", "");
		String payUrlStr=payUrl+"/";
		if(gameOff.indexOf(".")>0){
			payUrlStr=payUrlStr+gameOff.substring(0, gameOff.indexOf("."));
		}
		gi.setPayUrl(payUrlStr);
		
		GameServers gameServers=new GameServers();
		gameServers.setGameId(games.getGameId());
		gameServers.setOpenStatus("1");//已开区
		List<GameServers>  gsList=FacadeFactory.INSTANCE.getGameServersBo().findGameServers(gameServers, 1, 1);
		if(gsList!=null&&gsList.size()>0){
			GameServers gs=gsList.get(0);//获取最新区
			GameFenquVo latestFenqu=new GameFenquVo();
			latestFenqu.setGameNo(games.getGameNo());
			latestFenqu.setFenQuName(gs.getFenQuName());
			latestFenqu.setFenQuNum(gs.getFenQuNum());
			latestFenqu.setOpenTime(gs.getOpenTime());
			latestFenqu.setGameId(gs.getGameId());
			latestFenqu.setFenQuNickName((gs.getFenQuNickName()==null||"".equals(gs.getFenQuNickName()))?gs.getFenQuName():gs.getFenQuNickName());
			gi.setLastestfenqu(latestFenqu);
			gi.setLatestFenQuNum(String.valueOf(latestFenqu.getFenQuNum()));
			gi.setLatestFenQuName(latestFenqu.getFenQuName());
		}
		return gi;
	}
	/**
	 * 根据seqid获取公告
	 * @param seqId
	 * @return
	 */
	public static GameGongGaoVo getGameGongGao(long seqId){
		GameContent gc=FacadeFactory.INSTANCE.getGameContentBo().findGameContentById(seqId);
		if(gc==null){
			return null;
		}
		GameGongGaoVo gggv=new GameGongGaoVo();
		gggv.setBold(gc.getBold());
		gggv.setContent(gc.getContent());
		gggv.setLink(gc.getJumpUrl());
		gggv.setPublishDate(parseDate(sdf1,gc.getPublishDate()));
		gggv.setPublishDateStr(gc.getPublishDate());
		gggv.setRed(gc.getRed());
		gggv.setTitle(gc.getTitle());
		gggv.setType("公告");
		return gggv;
	}
	/**
	 * 获取游戏公告
	 * @param gameFK 游戏主键
	 * @return
	 */
	public static List<GameGongGaoVo> getGongGaoList(long gameFK){
		List<GameGongGaoVo> list=new ArrayList<GameGongGaoVo>();
		
		GameContent gameContent=new GameContent();
		gameContent.setAlreadyDelete(false);//未删除
		gameContent.setGameFK(gameFK);//游戏主键
		gameContent.setContentType("LastNotice");//最近的公告
		gameContent.setToPublishDate(sdf1.format(new Date()));//已发布的时间
		List<GameContent> gclist=FacadeFactory.INSTANCE.getGameContentBo().findGameContent(gameContent, 1, 7);
		for(GameContent gc:gclist){
			GameGongGaoVo gggv=new GameGongGaoVo();
			gggv.setBold(gc.getBold());
			gggv.setContent(gc.getContent());
			gggv.setLink(gc.getJumpUrl());
			gggv.setPublishDate(parseDate(sdf1,gc.getPublishDate()));
			gggv.setPublishDateStr(gc.getPublishDate());
			gggv.setRed(gc.getRed());
			gggv.setTitle(gc.getTitle());
			gggv.setType("公告");
			list.add(gggv);
		}
		return list;
	}
	/**
	 * 获取游戏资料
	 * @param gameFK
	 * @return
	 */
	public static List<GameZiLiaoVo> getZiLiaoList(long gameFK){
		List<GameZiLiaoVo> list=new ArrayList<GameZiLiaoVo>();
		
		GameContent gameContent=new GameContent();
		gameContent.setAlreadyDelete(false);//未删除
		gameContent.setGameFK(gameFK);//游戏主键
		gameContent.setContentType("GameMaterial");//游戏资料
		gameContent.setToPublishDate(sdf1.format(new Date()));//已发布的时间
		List<GameContent> gclist=FacadeFactory.INSTANCE.getGameContentBo().findGameContent(gameContent,1, 30);
		for(GameContent gc:gclist){
			GameZiLiaoVo zl=new GameZiLiaoVo();
			zl.setLink(gc.getJumpUrl());
			zl.setTitle(gc.getTitle());
			zl.setBold(gc.getBold());
			zl.setRed(gc.getRed());
			list.add(zl);
		}
		return list;
	}
	/**
	 * 获取游戏特色
	 * @param gameFK
	 * @return
	 */
	public static List<GameTeSeVo> getTeSeList(long gameFK){
		List<GameTeSeVo> list=new ArrayList<GameTeSeVo>();
		GameContent gameContent=new GameContent();
		gameContent.setAlreadyDelete(false);//未删除
		gameContent.setGameFK(gameFK);//游戏主键
		gameContent.setContentType("GameCharacter");//游戏特色
		gameContent.setToPublishDate(sdf1.format(new Date()));//已发布的时间
		List<GameContent> gclist=FacadeFactory.INSTANCE.getGameContentBo().findGameContent(gameContent,1, 30);
		for(GameContent gc:gclist){
			GameTeSeVo tese=new GameTeSeVo();
			tese.setLink(gc.getJumpUrl());
			tese.setTitle(gc.getTitle());
			tese.setBold(gc.getBold());
			tese.setRed(gc.getRed());
			list.add(tese);
		}
		return list;
	}
	/**
	 * 查询游戏攻略
	 * @param gameFK
	 * @return
	 */
	public static List<GameGongLueVo>  getGongLueList(long gameFK){
		List<GameGongLueVo> list=new ArrayList<GameGongLueVo>();
		GameContent gameContent=new GameContent();
		gameContent.setAlreadyDelete(false);//未删除
		gameContent.setGameFK(gameFK);//游戏主键
		gameContent.setContentType("GameStrategy");//游戏攻略
		gameContent.setToPublishDate(sdf1.format(new Date()));//已发布的时间
		List<GameContent> gclist=FacadeFactory.INSTANCE.getGameContentBo().findGameContent(gameContent, 1, 20);
		for(GameContent gc:gclist){
			GameGongLueVo gl=new GameGongLueVo();
			gl.setLink(gc.getJumpUrl());
			gl.setPublishDate(parseDate(sdf1,gc.getPublishDate()));
			gl.setRed(gc.getRed());
			gl.setTitle(gc.getTitle());
			gl.setBold(gc.getBold());
			list.add(gl);
		}
		return list;
	}
	/**
	 * 获取游戏论坛数据
	 * @param gameFK
	 * @return
	 */
	public static List<GameLunTangVo> getLunTangList(long gameFK){
		List<GameLunTangVo> list=new ArrayList<GameLunTangVo>();
		GameContent gameContent=new GameContent();
		gameContent.setAlreadyDelete(false);//未删除
		gameContent.setGameFK(gameFK);//游戏主键
		gameContent.setContentType("GameForum");//游戏攻略
		gameContent.setToPublishDate(sdf1.format(new Date()));//已发布的时间
		List<GameContent> gclist=FacadeFactory.INSTANCE.getGameContentBo().findGameContent(gameContent, 1, 10);
		for(GameContent gc:gclist){
			GameLunTangVo lt=new GameLunTangVo();
			System.out.println(gc.getSeqId());
			lt.setBold(gc.getBold());
			lt.setLink(gc.getJumpUrl());
			lt.setPublishDate(parseDate(sdf2, gc.getPublishDate()));
			lt.setPublisher("");
			lt.setRed(gc.getRed());
			lt.setTitle(gc.getTitle());
			lt.setType("论坛");
			list.add(lt);
		}
		return list;
	}
	
	/**
	 * 时间转化
	 * @param sdf
	 * @param dateStr
	 * @return
	 */
	private static Date parseDate(SimpleDateFormat sdf,String dateStr){
		if(dateStr==null||"".equals(dateStr)){
			return null;
		}
		try {
			return sdf.parse(dateStr);
		} catch (ParseException e) {
			throw new RuntimeException(dateStr+"转化为时间出现异常",e);
		}
	}
	
	/**
	 * 根据gameid获得游戏的统计编码
	 * @param gameId
	 * @return
	 */
//	public static String getStatisticsJsNo(String gameId){
//		PageStatisticsJs psjs=new PageStatisticsJs();
//		psjs.setGameId(gameId);
//		List<PageStatisticsJs> list=FacadeFactory.INSTANCE.getPageStatisticsJsBo().findPageStatisticsJss(psjs, 1, 1);
//		if(list==null||list.size()==0){
//			return "";
//		}
//		PageStatisticsJs psjstemp=list.get(0);
//		return psjstemp==null?"":psjstemp.getStatisticsId();
//	}
	public static PageStatisticsJs getStatisticsJsNo(String gameId){
		PageStatisticsJs psjs=new PageStatisticsJs();
		psjs.setGameId(gameId);
		List<PageStatisticsJs> list=FacadeFactory.INSTANCE.getPageStatisticsJsBo().findPageStatisticsJss(psjs, 1, 1);
		if(list==null||list.size()==0){
			return null;
		}
		return list.get(0);
	}
}
