package com.xunlei.niux.gameoffical.template.v2.builder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import com.xunlei.niux.easyutils.propertyutils.EnvPropertyUtil;

import com.xunlei.niux.data.vipgame.vo.GameServers;
import com.xunlei.niux.gameoffical.template.v2.vo.GameFenquVo;
import com.xunlei.niux.gameoffical.template.v2.vo.GameInfoVo;
import com.xunlei.niux.gameoffical.template.v2.vo.GameLunTangVo;
import com.xunlei.niux.manager.web.util.FreemarkerUtil;
import com.xunlei.niux.manager.web.util.StringUtil;

/**
 * 生成左侧边栏
 * @author lin
 * @date 2012-9-11
 * @Descripter:
 */
public class SideBuilder {
	private String tempName="side.ftl";
	private String tempPath=EnvPropertyUtil.loadProperty("GameOfficalTemplateV2","temppath").trim();
	private String htmlName="side.html";
	private String htmlPath=EnvPropertyUtil.loadProperty("GameOfficalTemplateV2","htmlpath").trim()+"/tv2/offical/";
	private String rootPath=EnvPropertyUtil.loadProperty("GameOfficalTemplateV2","rootpath").trim();

	/**
	 * 
	 * @param luntanglist
	 * @param tuijianList
	 * @param gameInfo
	 */
	public void builder(List<GameLunTangVo> luntanglist,List<GameInfoVo> tuijianList,List<GameFenquVo> fenquList,GameInfoVo gameInfo){
		htmlPath=htmlPath+gameInfo.getGameNo();
		Map<String,Object> root=new HashMap<String,Object>();
		root.put("tuijiangame_data_side",buildTuiJianGameSide(tuijianList));
		root.put("gameluntang_data_1", buildeGameLunTang(luntanglist));
		root.put("gamefenqu_data_option_list", getGameFenQuDataOptions(gameInfo.getGameId(), gameInfo.getGameNo()));
		root.put("gameinfo",buildGameInfo(gameInfo));
		root.put("root", rootPath);
		FreemarkerUtil.buildHtml(tempPath, tempName, root, htmlPath, htmlName);
	}
	public static List<Map<String,String>> getGameFenQuDataOptions(String gameId,String gameNo){
		List<Map<String,String>> list=new ArrayList<Map<String,String>>();
		List<GameServers> rslist=DataUtil.getAllGameServers(gameId);
		for(GameServers gs:rslist){
			if("0".equals(gs.getOpenStatus())||"2".equals(gs.getOpenStatus())){
				continue;
			}
			Map<String,String> map=new HashMap<String,String>();
			map.put("fenQuNum",String.valueOf(gs.getFenQuNum()));
			String fenQuNickName="";
			if("1".equals(gs.getOpenStatus())){
				fenQuNickName=(gs.getFenQuNickName()==null||"".equals(gs.getFenQuNickName())?gs.getFenQuName():gs.getFenQuNickName());
			}else{
				fenQuNickName=gs.getFenQuNum()+"区(维护中)";
			}
			map.put("fenQuNickName",fenQuNickName);
			map.put("gameNo", gameNo);
			map.put("openStatus", gs.getOpenStatus());
			list.add(map);
		}
		return list;
	}
	/**
	 * 生成游戏信息
	 * @return
	 */
	public static GameInfoVo buildGameInfo(GameInfoVo giv){
		GameInfoVo gameinfo=new GameInfoVo();
		gameinfo.setGameDesc(StringUtil.formatHtml(giv.getGameDesc()));
		gameinfo.setLunTangUrl(StringUtil.formatHtml(giv.getLunTangUrl()));
		gameinfo.setGameName(StringUtil.formatHtml(giv.getGameName()));
		gameinfo.setGameOffical(giv.getGameOffical());
		gameinfo.setGameNo(StringUtil.formatHtml(giv.getGameNo()));
		gameinfo.setGameId(giv.getGameId());
		gameinfo.setSeqId(giv.getSeqId());
		gameinfo.setPayUrl(giv.getPayUrl());
		if(giv.getLatestFenQuName()==null){
			gameinfo.setLatestFenQuName("");
		}else{
			gameinfo.setLatestFenQuName(giv.getLatestFenQuName());
		}
		if(giv.getLatestFenQuNum()==null){
			gameinfo.setLatestFenQuNum("");
		}else{
			gameinfo.setLatestFenQuNum(giv.getLatestFenQuNum());
		}
		
		return gameinfo;
	}
//	/**
//	 *  生成分区下拉列表
//	 * @return
//	 */
//	private static String buildFenQuOption(List<GameFenquVo> list){
//		StringBuilder sb=new StringBuilder();
//		if(list==null){
//			return sb.toString();
//		}
//		for(int i=0;i<list.size();i++){
//			GameFenquVo fenqu=list.get(i);
//			if(fenqu==null){
//				continue;
//			}
//			sb.append("<option value=\"").append(fenqu.getGameNo()+"_"+fenqu.getFenQuNum()).append("\">").append(fenqu.getFenQuNickName()).append("</option>");
//		}
//		return sb.toString();
//	}
	/**
	 * 生成推荐游戏(左侧栏的)
	 * @return
	 */
	public static String buildTuiJianGameSide(List<GameInfoVo> list){
		int titleMaxLen=10;
		StringBuilder sb=new StringBuilder();
		if(list==null){
			return sb.toString();
		}
		for(int i=0;i<4&&i<list.size();i++){
			GameInfoVo giv=list.get(i);
			sb.append("<a href=\"")
			.append(giv.getGameOffical()).append("\" target=\"_blank\" title=\"").append(StringUtil.formatHtml(giv.getGameName())).append("\" >")
			.append(StringUtil.formatHtml(giv.getGameName(), titleMaxLen)).append("</a>");
		}
		return sb.toString();
	}
	/**
	 * 生成游戏论坛(不需要日期)
	 * @return
	 */
	public static String buildeGameLunTang(List<GameLunTangVo> list){
		int titleMaxLen=14;
		StringBuilder sb=new StringBuilder();
		if(list==null){
			return sb.toString();
		}
		for(GameLunTangVo luntang:list){
			if(luntang==null){
				continue;
			}
			int typeandnamelen=0;
			if(luntang.getType()!=null){
				typeandnamelen=typeandnamelen+luntang.getType().length();
			}
			if(luntang.getPublisher()!=null){
				typeandnamelen=typeandnamelen+luntang.getPublisher().length();
			}
			sb.append("<li ");
			if(luntang.isBold()||luntang.isRed()){
				String classStr="";	
				classStr=classStr+" class=\"";
				if(luntang.isBold()){
					classStr=classStr+"fb ";
				}
				if(luntang.isRed()){
					classStr=classStr+"fco ";
				}
				classStr=classStr.substring(0,classStr.length());
				classStr=classStr+"\"";
				sb.append(classStr);
			}
			sb.append(">");
			sb.append("<a href=\"").append(luntang.getLink()).append("\" target=\"_blank\" title=\"").append(StringUtil.formatHtml(luntang.getTitle()))
			  .append("\">[").append(StringUtil.formatHtml(luntang.getType())).append("] ").append(StringUtil.formatHtml(luntang.getTitle(), titleMaxLen-typeandnamelen))
			  .append(" ").append(StringUtil.formatHtml(luntang.getPublisher())).append("</a>");
			sb.append("</li>");
		}
		System.out.println(sb.toString());
		return sb.toString();
	}
}
