package com.xunlei.niux.gameoffical.template.v2.builder;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import com.xunlei.niux.easyutils.propertyutils.EnvPropertyUtil;

import com.xunlei.niux.gameoffical.template.v2.vo.GameBgVo;
import com.xunlei.niux.gameoffical.template.v2.vo.GameFenquVo;
import com.xunlei.niux.gameoffical.template.v2.vo.GameInfoVo;
import com.xunlei.niux.gameoffical.template.v2.vo.GameLunTangVo;
import com.xunlei.niux.manager.web.util.FreemarkerUtil;

/**
 * 公告列表生成
 * @author lin
 * @date 2012-9-11
 * @Descripter:
 */
public class NoticeListBuilder {
	private String tempName="noticelist.ftl";
	private String tempPath=EnvPropertyUtil.loadProperty("GameOfficalTemplateV2","temppath").trim();
	//private String htmlName="noticelist.shtml";
	private String htmlPath=EnvPropertyUtil.loadProperty("GameOfficalTemplateV2","htmlpath").trim()+"/tv2/offical/";
	private String rootPath=EnvPropertyUtil.loadProperty("GameOfficalTemplateV2","rootpath").trim();
	/**
	 * 生成
	 * @param luntanglist 论坛
	 * @param tuijianList 推荐游戏
	 * @param fenquList 所有分区
	 * @param gameInfo 游戏信息
	 */
	public void builder(List<GameLunTangVo> luntanglist,List<GameInfoVo> tuijianList,List<GameFenquVo> fenquList,GameInfoVo gameInfo,GameBgVo gameBg){
		htmlPath=htmlPath+gameInfo.getGameNo();//html保存路径
		Map<String,Object> root=new HashMap<String,Object>();
		root.put("tuijiangame_data_header", HeaderBuilder.buildTeJianGameHeader(tuijianList));
		root.put("tuijiangame_data_side",SideBuilder.buildTuiJianGameSide(tuijianList));
		root.put("gameluntang_data_1", SideBuilder.buildeGameLunTang(luntanglist));
		root.put("gamefenqu_data_option_list", SideBuilder.getGameFenQuDataOptions(gameInfo.getGameId(), gameInfo.getGameNo()));
//		root.put("gamefenqu_data_option", SideBuilder.buildFenQuOption(fenquList));
		root.put("gameinfo",SideBuilder.buildGameInfo(gameInfo));
		root.put("gamebg",gameBg);
		root.put("root", rootPath);
		root.put("pageType", "LastNotice");
		root.put("pageName","公告");
		root.put("flashurl", TempDataBuilder.getFlashUrl(gameInfo.getGameId()));
		FreemarkerUtil.buildHtml(tempPath, tempName,root, htmlPath, "LastNoticeList.shtml");
		root.put("pageType", "GameMaterial");
		root.put("pageName","资料");
		FreemarkerUtil.buildHtml(tempPath, tempName,root, htmlPath, "GameMaterialList.shtml");
		root.put("pageType", "GameCharacter");
		root.put("pageName","特色");
		FreemarkerUtil.buildHtml(tempPath, tempName,root, htmlPath, "GameCharacterList.shtml");
		root.put("pageType", "GameStrategy");
		root.put("pageName","攻略");
		
		FreemarkerUtil.buildHtml(tempPath, tempName,root, htmlPath, "GameStrategyList.shtml");
	}
}
