package com.xunlei.niux.gameoffical.template.v2.builder;

import java.util.HashMap;
import java.util.Map;
import com.xunlei.niux.easyutils.propertyutils.EnvPropertyUtil;

import com.xunlei.niux.data.vipgame.vo.GameContent;
import com.xunlei.niux.gameoffical.template.v2.vo.GameBgVo;

import com.xunlei.niux.gameoffical.template.v2.vo.GameInfoVo;
import com.xunlei.niux.manager.web.util.Base64Util;
import com.xunlei.niux.manager.web.util.FreemarkerUtil;

/**
 * 创建公告
 * @author lin
 * @date 2012-9-11
 * @Descripter:
 */
public class NoticeContentBuilder {
	private String tempName="noticecontent.ftl";
	private String tempPath=EnvPropertyUtil.loadProperty("GameOfficalTemplateV2","temppath").trim();
	private String htmlName=System.currentTimeMillis()+".shtml";
	private String htmlPath="";
	private String url="";
	private String rootPath=EnvPropertyUtil.loadProperty("GameOfficalTemplateV2","rootpath").trim();
	private static String IMG_DOMAIN=EnvPropertyUtil.loadProperty("GameOfficalTemplateV2","img_domain").trim();
	private static String EDIT_IMG_BEGIN=EnvPropertyUtil.loadProperty("GameOfficalTemplateV2","edit_img_begin").trim();
	private static String EDIT_IMG_BEGIN1=EnvPropertyUtil.loadProperty("GameOfficalTemplateV2","edit_img_begin1").trim();
	/**
	 *  创建公告
	 * @param gonggao
	 * @return 返回公告的url
	 */
	public String builder(GameContent gameContent,GameInfoVo gameinfo,GameBgVo gameBg){
		if(gameContent==null){
			throw new RuntimeException("内容为空");
		}
		Map<String,Object> root=new HashMap<String,Object>();
		if(gameContent!=null&&gameContent.getPublishDate()!=null&&gameContent.getPublishDate().length()>19){
			gameContent.setPublishDate(gameContent.getPublishDate().substring(0, 19));
		}
		String content=Base64Util.decode(gameContent.getContent());
		content=content.replaceAll(EDIT_IMG_BEGIN1, IMG_DOMAIN+"/upload");
		content=content.replaceAll(EDIT_IMG_BEGIN, IMG_DOMAIN+"/upload");
		if(gameContent!=null){
			gameContent.setContent(content);
		}
		root.put("gonggao",gameContent);
		root.put("gameinfo", SideBuilder.buildGameInfo(gameinfo));
		root.put("gamebg",gameBg);
		//root.put("bgurl", IMG_DOMAIN+"/"+bgUrl);
		root.put("root", rootPath);
		String pageName="";
		String pageType="";
		if(gameContent.getContentType().equals("LastNotice")){
			pageType="LastNotice";
			pageName="公告";
		}else if(gameContent.getContentType().equals("GameMaterial")){
			pageType="GameMaterial";
			pageName="资料";
		}else if(gameContent.getContentType().equals("GameCharacter")){
			pageType="GameCharacter";
			pageName="特色";
		}
		else if(gameContent.getContentType().equals("GameStrategy")){
			pageType="GameStrategy";
			pageName="攻略";
		}
		root.put("pageType", pageType);
		root.put("pageName", pageName);
		htmlPath=EnvPropertyUtil.loadProperty("GameOfficalTemplateV2","htmlpath").trim()+"/tv2/offical/"+gameinfo.getGameNo()+"/"+gameContent.getContentType();
		String tempUrl=gameContent.getJumpUrl();
		if(tempUrl!=null&&tempUrl.contains("/tv2/offical/")){
			int lastindex=tempUrl.lastIndexOf("/");
			htmlName=tempUrl.substring(lastindex+1);
		}
		url=gameinfo.getGameOffical()+"/tv2/offical/"+gameinfo.getGameNo()+"/"+gameContent.getContentType()+"/"+htmlName;
		FreemarkerUtil.buildHtml(tempPath, tempName, root, htmlPath, htmlName);
		FreemarkerUtil.buildHtml(tempPath, "boxnoticecontent.ftl", root,EnvPropertyUtil.loadProperty("GameOfficalTemplateV2","htmlpath").trim()+"/tv2/offical/"+gameinfo.getGameNo()+"/gamebox", htmlName);
		return url;
	}
}
