package com.xunlei.niux.gameoffical.template.v2.builder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import com.xunlei.niux.easyutils.propertyutils.EnvPropertyUtil;

import com.xunlei.niux.gameoffical.template.v2.vo.GameInfoVo;
import com.xunlei.niux.manager.web.util.FreemarkerUtil;
import com.xunlei.niux.manager.web.util.StringUtil;

/**
 * 头部所有游戏生成
 * @author lin
 * @date 2012-9-11
 * @Descripter:
 */
public class HeaderAllGamesBuilder {
	private String tempName="header_allgames.ftl";
	private String tempPath=EnvPropertyUtil.loadProperty("GameOfficalTemplateV2","temppath").trim();
	private String htmlName="header_allgames.html";
	private String htmlPath=EnvPropertyUtil.loadProperty("GameOfficalTemplateV2","htmlpath").trim()+"/tv2/commondata";

	public  void  builder(List<GameInfoVo> list){
		Map<String,Object> root=new HashMap<String,Object>();
		root.put("allgames_data", buildAllGameList(list));
		FreemarkerUtil.buildHtml(tempPath, tempName, root, htmlPath, htmlName);
	}
	/**
	 * 生成所有游戏列表
	 * @return
	 */
	private String buildAllGameList(List<GameInfoVo> list){
		int titleMaxLen=10;
		StringBuilder sb=new StringBuilder();
		if(list==null){
			return sb.toString();
		}
		int liindex=1;//每行显示5个（li）
		int linesize=5;
		int j=0;
		boolean liendflag=true;//已结束
		for(GameInfoVo giv:list){
			if(giv==null){
				continue;
			}
			if(giv.getClientType()==3){
				continue;
			}
			j++;
			if(liindex==1){
				sb.append("<li>");
				liendflag=false;
			}
			String classname="";
			if(giv.getRunStatus()==null){
				giv.setRunStatus("");
			}
			if(giv.getRunStatus().equals("new")){
				classname=classname+" new";//新游戏
			}
			if(giv.getRunStatus().equals("hot")){
				classname=classname+" hot";//热门游戏
			}
			if(liindex==linesize){
				classname=classname+" last";
			}
			//添加span内容
			sb.append("<span class=\"").append(classname);
			sb.append("\"><a href=\"")
			.append(giv.getGameOffical()).append("\" target=\"_blank\"");
			if(j>0&&j<6){
				sb.append(" class=\"fco\"");
			}
			sb.append(" title=\"")
			.append(StringUtil.formatHtml(giv.getGameName())).append("\">").append(StringUtil.formatHtml(giv.getGameName(),titleMaxLen)).append("<b></b></a></span>");
			if(liindex==linesize){
				sb.append("</li>");
				liindex=1;//设置为1表示li重头开始
				liendflag=true;
				continue;
			}
			liindex++;
		}
		//判断是否li没有结束
		if(!liendflag){
			sb.append("</li>");
		}
		return sb.toString();
	}
	/**
	 * 测试
	 * @param args
	 */
	public static void main(String[] args){
		List<GameInfoVo> list=new ArrayList<GameInfoVo>();
		GameInfoVo g1=new GameInfoVo();
		g1.setGameName("龙将");
		g1.setGameNo("lj");
		g1.setGameOffical("http://lj.youxi.xunlei.com");
		g1.setRunStatus("new");//新游戏
		list.add(g1);
		GameInfoVo g2=new GameInfoVo();
		g2.setGameName("神仙道");
		g2.setGameNo("sxd");
		g2.setGameOffical("http://sxd.youxi.xunlei.com");
		g2.setRunStatus("hot");//新游戏
		list.add(g2);
		GameInfoVo g3=new GameInfoVo();
		g3.setGameName("大侠传");
		g3.setGameNo("dxz");
		g3.setGameOffical("http://dxz.youxi.xunlei.com");
		//g3.setRunStatus("hot");//新游戏
		list.add(g3);
		GameInfoVo g4=new GameInfoVo();
		g4.setGameName("醉西游");
		g4.setGameNo("zxy");
		g4.setGameOffical("http://zxy.youxi.xunlei.com");
		g4.setRunStatus("hot");//新游戏
		list.add(g4);
		GameInfoVo g5=new GameInfoVo();
		g5.setGameName("傲视天地");
		g5.setGameNo("astd");
		g5.setGameOffical("http://astd.youxi.xunlei.com");
		g5.setRunStatus("hot");//新游戏
		list.add(g5);
		GameInfoVo g6=new GameInfoVo();
		g6.setGameName("傲世遮天");
		g6.setGameNo("aszt");
		g6.setGameOffical("http://aszt.youxi.xunlei.com");
		g6.setRunStatus("hot");//新游戏
		list.add(g6);
		GameInfoVo g7=new GameInfoVo();
		g7.setGameName("十年一剑");
		g7.setGameNo("snyj");
		g7.setGameOffical("http://snyj.youxi.xunlei.com");
		g7.setRunStatus("hot");//新游戏
		list.add(g7);
		new HeaderAllGamesBuilder().builder(list);
	}
}
