package com.xunlei.niux.gameoffical.template.v2.builder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import com.xunlei.niux.easyutils.propertyutils.EnvPropertyUtil;

import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.easyutils.propertyutils.EnvPropertyUtil;
import com.xunlei.niux.gameoffical.template.v2.vo.GameInfoVo;
import com.xunlei.niux.manager.web.cache.GameCache;
import com.xunlei.niux.manager.web.util.FreemarkerUtil;

/**
 * 所有游戏信息设置
 * @author lin
 * @date 2012-9-16
 * @Descripter:
 */
public class AllGameInfoBuilder {
	private String tempName="allgameinfo.ftl";
	private String tempPath= EnvPropertyUtil.loadProperty("GameOfficalTemplateV2", "temppath").trim();
	private String htmlName="niuallgameinfo.js";
	private String htmlPath=EnvPropertyUtil.loadProperty("GameOfficalTemplateV2", "htmlpath").trim()+"/tv2/js/";
	public  void  builder(List<GameInfoVo> list){
		Map<String,Object> root=new HashMap<String,Object>();
		root.put("allgameinfo", buildAllGameList(list));
		FreemarkerUtil.buildHtml(tempPath, tempName, root, htmlPath, htmlName);
	}
	private String buildAllGameList(List<GameInfoVo> list){
		Map<String,List<String>> map=new HashMap<String,List<String>>();
		List<Games> glist=GameCache.getInstance().getAllGames();
		for(Games gameinfo:glist){
			List<String> tlist=new ArrayList<String>();
			tlist.add(replaceNull(gameinfo.getGameName()));
			tlist.add(replaceNull(gameinfo.getOfficialWebSite()));
			tlist.add("");
			tlist.add(replaceNull(gameinfo.getGameId()));
			tlist.add(replaceNull(gameinfo.getForumUrl()));
			map.put(gameinfo.getGameNo(), tlist);
		}
//		for(GameInfoVo gameinfo:list){
//			List<String> tlist=new ArrayList<String>();
//			tlist.add(replaceNull(gameinfo.getGameName()));
//			tlist.add(replaceNull(gameinfo.getGameOffical()));
//			tlist.add("");
//			tlist.add(replaceNull(gameinfo.getGameId()));
//			tlist.add(replaceNull(gameinfo.getLunTangUrl()));
//			map.put(gameinfo.getGameNo(), tlist);
//		}
		String str=JsonObjectUtil.getDataJsonObject(map);
		return str;
	}
	private String replaceNull(String value){
		if(value==null){
			return "";
		}
		return value;
	}
}
