package com.xunlei.niux.gameoffical.model;

import java.util.ArrayList;
import java.util.List;

import org.apache.log4j.Logger;

import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.GameContent;
import com.xunlei.niux.manager.web.model.BaseManagedBean;
import com.xunlei.niux.manager.web.util.NiUxFunctionConstant;

/**
 * 
 * @author lin
 * @date 2012-9-17
 * @Descripter:
 */
@FunRef(NiUxFunctionConstant.NIUX_FUNCTION_GAMECONTENT)
public class GameContentManagedBean extends BaseManagedBean{
	private static final Logger logger = Logger.getLogger(GameContentManagedBean.class.getName());
	public String getGameContentList(){
		GameContent gc=this.findBean(GameContent.class, "niux_gamecontent");
		PagedFliper pagedFliper =this.getFliper();
		GameContent gc1=new GameContent();
		gc1.setGameFK(gc.getGameFK());
		gc1.setSeqId(gc.getSeqId());
		gc1.setJump(false);
		if(gc.getContentType()==null||"".equals(gc.getContentType())){
			Sheet<GameContent> sheet=Sheet.EMPTY;
			this.mergePagedDataModel(sheet, pagedFliper);
			return "";
		}
		if(gc!=null&&gc.getGameFK()!=null&&gc.getGameFK()==0){
			gc1.setGameFK(null);
		}
		if(gc!=null&&gc.getSeqId()!=null&&gc.getSeqId()==0){
			gc1.setSeqId(null);
		}
		gc1.setContentType(gc.getContentType());
		
		int count=FacadeFactory.INSTANCE.getGameContentBo().count(gc1);
		pagedFliper.setRecordCount(count);
		List<GameContent> list=new ArrayList<GameContent>();
		if(count>0){
			list=FacadeFactory.INSTANCE.getGameContentBo().findGameContent(gc1,pagedFliper.getPageNo(), pagedFliper.getPageSize());
		}
		Sheet<GameContent> sheet=new Sheet<GameContent>(count,list);
		this.mergePagedDataModel(sheet, pagedFliper);
		return "";
	}
}
