/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mock.web.portlet;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.mock.web.portlet.MockActionRequest;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.portlet.multipart.MultipartActionRequest;

public class MockMultipartActionRequest
extends MockActionRequest
implements MultipartActionRequest {
    private final Map multipartFiles = new LinkedHashMap(4);

    public void addFile(MultipartFile file) {
        Assert.notNull(file, "MultipartFile must not be null");
        this.multipartFiles.put(file.getName(), file);
    }

    public Iterator getFileNames() {
        return this.getFileMap().keySet().iterator();
    }

    public MultipartFile getFile(String name) {
        return (MultipartFile)this.multipartFiles.get(name);
    }

    public Map getFileMap() {
        return Collections.unmodifiableMap(this.multipartFiles);
    }
}

