/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mock.web;

import java.util.Enumeration;
import java.util.Properties;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import org.springframework.mock.web.MockServletContext;
import org.springframework.util.Assert;

public class MockFilterConfig
implements FilterConfig {
    private final ServletContext servletContext;
    private final String filterName;
    private final Properties initParameters = new Properties();

    public MockFilterConfig() {
        this(null, "");
    }

    public MockFilterConfig(String filterName) {
        this(null, filterName);
    }

    public MockFilterConfig(ServletContext servletContext) {
        this(servletContext, "");
    }

    public MockFilterConfig(ServletContext servletContext, String filterName) {
        this.servletContext = servletContext != null ? servletContext : new MockServletContext();
        this.filterName = filterName;
    }

    public String getFilterName() {
        return this.filterName;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public void addInitParameter(String name, String value) {
        Assert.notNull(name, "Parameter name must not be null");
        this.initParameters.setProperty(name, value);
    }

    public String getInitParameter(String name) {
        Assert.notNull(name, "Parameter name must not be null");
        return this.initParameters.getProperty(name);
    }

    public Enumeration getInitParameterNames() {
        return this.initParameters.keys();
    }
}

