/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mock.jndi;

import java.util.Map;
import javax.naming.NamingException;
import org.springframework.core.CollectionFactory;
import org.springframework.jndi.JndiTemplate;

public class ExpectedLookupTemplate
extends JndiTemplate {
    private final Map jndiObjects = CollectionFactory.createConcurrentMapIfPossible(16);

    public ExpectedLookupTemplate() {
    }

    public ExpectedLookupTemplate(String name, Object object) {
        this.addObject(name, object);
    }

    public void addObject(String name, Object object) {
        this.jndiObjects.put(name, object);
    }

    public Object lookup(String name) throws NamingException {
        Object object = this.jndiObjects.get(name);
        if (object == null) {
            throw new NamingException("Unexpected JNDI name '" + name + "': expecting " + this.jndiObjects.keySet());
        }
        return object;
    }
}

