/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.velocity;

import com.xunlei.util.CharsetTools;
import com.xunlei.util.MapUtil;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;

public class VelocityUtil {
    private static String defaultCharSet = CharsetTools.GBK.name();

    public static void mergeToFile(VelocityContext context, Template template, String distFilePath, String charsetName) throws Exception {
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(distFilePath), charsetName);
        try {
            template.merge((Context)context, (Writer)writer);
        }
        finally {
            writer.close();
        }
    }

    public static String mergeToString(VelocityContext context, Template template) throws Exception {
        StringWriter writer = new StringWriter();
        try {
            template.merge((Context)context, (Writer)writer);
        }
        finally {
            writer.close();
        }
        return writer.toString();
    }

    public static String mergeToStringFromClasspath(VelocityContext context, String templateName, Class<?> clazz, String charSetName) throws ParseErrorException, MethodInvocationException, ResourceNotFoundException, IOException {
        InputStream is = null;
        if (clazz == null) {
            is = ClassLoader.getSystemResourceAsStream(templateName);
        } else {
            String path = String.valueOf(clazz.getPackage().getName().replace(".", "/")) + "/";
            is = clazz.getClassLoader().getResourceAsStream(String.valueOf(path) + templateName);
        }
        StringWriter writer = new StringWriter();
        try {
            Velocity.evaluate((Context)context, (Writer)writer, (String)"", (Reader)new InputStreamReader(is, charSetName));
        }
        finally {
            writer.close();
        }
        return writer.toString();
    }

    public static String mergeToStringFromClasspath(VelocityContext context, String templateName, Class<?> clazz) throws ParseErrorException, MethodInvocationException, ResourceNotFoundException, IOException {
        return VelocityUtil.mergeToStringFromClasspath(context, templateName, clazz, defaultCharSet);
    }

    public static String mergeToStringFromClasspath(VelocityContext context, String templateName) throws ParseErrorException, MethodInvocationException, ResourceNotFoundException, IOException {
        return VelocityUtil.mergeToStringFromClasspath(context, templateName, null, defaultCharSet);
    }

    public static VelocityContext buildContext(Object ... keyvalue) {
        MapUtil.checkKeyValueLength(keyvalue);
        VelocityContext ctx = new VelocityContext();
        int i = 0;
        while (i < keyvalue.length) {
            ctx.put(keyvalue[i++].toString(), keyvalue[i]);
            ++i;
        }
        return ctx;
    }
}

