/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.util.codec;

import com.xunlei.util.Log;
import com.xunlei.util.codec.Base64InputStream;
import com.xunlei.util.codec.Base64OutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.slf4j.Logger;

public class Base64Util {
    private static final Logger log = Log.getLogger();

    public static String encode(String str) throws RuntimeException {
        byte[] bytes = str.getBytes();
        byte[] encoded = Base64Util.encode(bytes);
        try {
            return new String(encoded, "ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("ASCII is not supported!", e);
        }
    }

    public static String encode(String str, String charset) throws RuntimeException {
        byte[] bytes;
        try {
            bytes = str.getBytes(charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Unsupported charset: " + charset, e);
        }
        byte[] encoded = Base64Util.encode(bytes);
        try {
            return new String(encoded, "ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("ASCII is not supported!", e);
        }
    }

    public static byte[] decodeFromString(String str) throws RuntimeException {
        return Base64Util.decode(str.getBytes());
    }

    public static String decode(String str) throws RuntimeException {
        byte[] bytes;
        try {
            bytes = str.getBytes("ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("ASCII is not supported!", e);
        }
        byte[] decoded = Base64Util.decode(bytes);
        return new String(decoded);
    }

    public static String decode(String str, String charset) throws RuntimeException {
        byte[] bytes;
        try {
            bytes = str.getBytes("ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("ASCII is not supported!", e);
        }
        byte[] decoded = Base64Util.decode(bytes);
        try {
            return new String(decoded, charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Unsupported charset: " + charset, e);
        }
    }

    public static String encodeAsString(byte[] bytes) throws RuntimeException {
        return new String(Base64Util.encode(bytes, 0));
    }

    public static byte[] encode(byte[] bytes) throws RuntimeException {
        return Base64Util.encode(bytes, 0);
    }

    public static byte[] encode(byte[] bytes, int wrapAt) throws RuntimeException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            try {
                Base64Util.encode(inputStream, outputStream, wrapAt);
            }
            catch (IOException e) {
                throw new RuntimeException("Unexpected I/O error", e);
            }
        }
        finally {
            try {
                inputStream.close();
            }
            catch (Throwable t) {
                log.error("", t);
            }
            try {
                outputStream.close();
            }
            catch (Throwable t) {
                log.error("", t);
            }
        }
        return outputStream.toByteArray();
    }

    public static byte[] decode(byte[] bytes) throws RuntimeException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            try {
                Base64Util.decode(inputStream, outputStream);
            }
            catch (IOException e) {
                throw new RuntimeException("Unexpected I/O error", e);
            }
        }
        finally {
            try {
                inputStream.close();
            }
            catch (Throwable t) {
                log.error("", t);
            }
            try {
                outputStream.close();
            }
            catch (Throwable t) {
                log.error("", t);
            }
        }
        return outputStream.toByteArray();
    }

    public static void encode(InputStream inputStream, OutputStream outputStream) throws IOException {
        Base64Util.encode(inputStream, outputStream, 0);
    }

    public static void encode(InputStream inputStream, OutputStream outputStream, int wrapAt) throws IOException {
        Base64OutputStream aux = new Base64OutputStream(outputStream, wrapAt);
        Base64Util.copy(inputStream, aux);
        aux.commit();
    }

    public static void decode(InputStream inputStream, OutputStream outputStream) throws IOException {
        Base64Util.copy(new Base64InputStream(inputStream), outputStream);
    }

    public static void encode(File source, File target, int wrapAt) throws IOException {
        FileInputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            inputStream = new FileInputStream(source);
            outputStream = new FileOutputStream(target);
            Base64Util.encode(inputStream, outputStream, wrapAt);
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (Throwable t) {
                    log.error("", t);
                }
            }
            if (inputStream != null) {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (Throwable t) {
                    log.error("", t);
                }
            }
        }
    }

    public static void encode(File source, File target) throws IOException {
        FileInputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            inputStream = new FileInputStream(source);
            outputStream = new FileOutputStream(target);
            Base64Util.encode(inputStream, outputStream);
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (Throwable t) {
                    log.error("", t);
                }
            }
            if (inputStream != null) {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (Throwable t) {
                    log.error("", t);
                }
            }
        }
    }

    public static void decode(File source, File target) throws IOException {
        FileInputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            inputStream = new FileInputStream(source);
            outputStream = new FileOutputStream(target);
            Base64Util.decode(inputStream, outputStream);
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (Throwable t) {
                    log.error("", t);
                }
            }
            if (inputStream != null) {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (Throwable t) {
                    log.error("", t);
                }
            }
        }
    }

    private static void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int len;
        byte[] b = new byte[1024];
        while ((len = inputStream.read(b)) != -1) {
            outputStream.write(b, 0, len);
        }
    }
}

