/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.util;

import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.Nullable;
import com.xunlei.util.Log;
import com.xunlei.util.StringHelper;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.CharBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;

public final class FileUtil {
    private static final Logger log = Log.getLogger();
    private static final int MEGABYTE = 0x100000;
    private static final String OS_VERSION = System.getProperty("os.version").toLowerCase();
    private static final String OS_NAME = System.getProperty("os.name").toLowerCase();
    public static final String PATH_SEGMENT_CURRENT = ".";
    public static final String PATH_SEGMENT_PARENT = "..";
    public static final String PROPERTY_USER_HOME = "user.home";
    public static final String PROPERTY_TMP_DIR = "java.io.tmpdir";
    public static final File[] NO_FILES = new File[0];
    public static final boolean isWindows = OS_NAME.startsWith("windows");
    public static final boolean isOS2 = OS_NAME.startsWith("os/2") || OS_NAME.startsWith("os2");
    public static final boolean isMac = OS_NAME.startsWith("mac");
    public static final boolean isLinux = OS_NAME.startsWith("linux");
    public static final boolean isFileSystemCaseSensitive = !isWindows && !isOS2 && !isMac;
    public static final boolean FILE_CHANNEL_TRANSFER_BROKEN = isLinux && OS_VERSION.startsWith("2.6");
    public static FileFilter defaultCopyFromFileAcceptFilter = null;
    public static FileFilter defaultCopyToFileExistAcceptFilter = null;
    public static boolean defaultCopySyncTimestamp = true;
    private static final long CHANNELS_COPYING_LIMIT = 0x500000L;
    private static final ThreadLocal<byte[]> BUFFER = new ThreadLocal<byte[]>(){

        @Override
        protected byte[] initialValue() {
            return new byte[20480];
        }
    };
    public static long READ_FILE_LENGTH_LIMIT = 0x6400000L;
    private static final byte[] LINE_SEPARATOR = System.getProperty("line.separator").getBytes();
    private static int ATTEMPTS_COUNT = 10;
    private static int ATTEMPTS_INITAL_SLEEP = 10;
    private static int ATTEMPTS_MAX_SLEEP = 1000;
    public static final FileFilter toFileIgnoreWhenExistFilter = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            return !pathname.exists();
        }
    };
    public static final FileFilter toFileErrorWhenExistFilter = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            if (pathname.exists()) {
                throw new IllegalAccessError("Target file already exists: " + pathname);
            }
            return true;
        }
    };
    public static final FileFilter fromFileIngoreSystemFileFilter = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            return !pathname.getName().startsWith(FileUtil.PATH_SEGMENT_CURRENT);
        }
    };

    public static RandomAccessFile getRandomAccessFile(File file, String mode) throws FileNotFoundException {
        if (file == null) {
            return null;
        }
        if (isWindows) {
            long sleep = ATTEMPTS_INITAL_SLEEP;
            int i = 0;
            while (i < ATTEMPTS_INITAL_SLEEP) {
                try {
                    return new RandomAccessFile(file, mode);
                }
                catch (FileNotFoundException e) {
                    try {
                        Thread.sleep(sleep);
                    }
                    catch (InterruptedException e1) {
                        return null;
                    }
                    if (sleep < (long)ATTEMPTS_MAX_SLEEP) {
                        sleep *= 2L;
                    }
                    ++i;
                }
            }
        }
        return new RandomAccessFile(file, mode);
    }

    public static BufferedReader getReader(File file, Charset encoding) throws IOException {
        if (file == null) {
            return null;
        }
        FileInputStream inf = new FileInputStream(file);
        InputStreamReader in = new InputStreamReader((InputStream)inf, encoding);
        BufferedReader result = new BufferedReader(in);
        return result;
    }

    public static BufferedWriter getWriter(File file, Charset encoding) throws IOException {
        if (file == null) {
            return null;
        }
        FileOutputStream outf = new FileOutputStream(file);
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)outf, encoding);
        BufferedWriter result = new BufferedWriter(out);
        return result;
    }

    @Nullable
    public static URL getURL(File file) {
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    @Nullable
    public static File getParentFile(File file) {
        int skipCount = 0;
        File parentFile = file;
        while (true) {
            if ((parentFile = parentFile.getParentFile()) == null) {
                return null;
            }
            if (PATH_SEGMENT_CURRENT.equals(parentFile.getName())) continue;
            if (PATH_SEGMENT_PARENT.equals(parentFile.getName())) {
                ++skipCount;
                continue;
            }
            if (skipCount <= 0) break;
            --skipCount;
        }
        return parentFile;
    }

    public static int getDirDepth(File file) {
        if (file == null || !file.exists()) {
            return -1;
        }
        if (file.isFile()) {
            return 0;
        }
        File[] files = file.listFiles();
        int max = 0;
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            int res;
            File f = fileArray[n2];
            if (f.isDirectory() && (res = FileUtil.getDirDepth(f)) > max) {
                max = res;
            }
            ++n2;
        }
        return max + 1;
    }

    public static long getFileSize(String fileLocation) {
        long fileSize = 0L;
        File file = new File(fileLocation);
        if (file.isFile()) {
            fileSize = file.length();
        } else {
            try {
                URL fileUrl = new URL(fileLocation);
                URLConnection urlConn = fileUrl.openConnection();
                urlConn.setUseCaches(false);
                fileSize = urlConn.getContentLength();
            }
            catch (IOException e) {
                fileSize = -1L;
            }
        }
        return fileSize;
    }

    public static File getCanonicalOrAbsoluteFile(File file) {
        if (file.exists()) {
            try {
                return file.getCanonicalFile();
            }
            catch (IOException e) {
                return file.getAbsoluteFile();
            }
        }
        return file;
    }

    public static String getCanonicalOrAbsolutePath(File file) {
        if (file.exists()) {
            try {
                return file.getCanonicalPath();
            }
            catch (IOException e) {
                return file.getAbsolutePath();
            }
        }
        return file.getPath();
    }

    private static String _sanitizeSeparatorChar(@Nullable String aFileName, char separator) {
        if (separator == '/') {
            return aFileName.replace('\\', separator);
        }
        return aFileName.replace('/', separator);
    }

    @Nullable
    public static String getSystemDependentName(@Nullable String aFileName) {
        return FileUtil._sanitizeSeparatorChar(aFileName, File.separatorChar);
    }

    @Nullable
    public static String getSystemIndependentName(@Nullable String aFileName) {
        return aFileName.replace('\\', '/');
    }

    public static String getBaseName(File file) {
        if (file != null) {
            return FileUtil.getBaseName(file.getPath());
        }
        return "";
    }

    public static String getBaseName(String filename) {
        int len = filename.length();
        if (len == 0) {
            return filename;
        }
        int end = len - 1;
        char last = filename.charAt(end);
        while (last == '/' || last == '\\') {
            if (--end < 0) {
                return Character.toString(last);
            }
            last = filename.charAt(end);
        }
        int start = filename.lastIndexOf(47, end);
        if (start < 0) {
            start = filename.lastIndexOf(92, end);
        }
        if (last == ':' && start < 0) {
            return "";
        }
        return filename.substring(start + 1, end + 1);
    }

    public static String getFileName(String filePath) {
        if (filePath == null) {
            return "";
        }
        int i = filePath.lastIndexOf(File.separatorChar);
        if (File.separatorChar != '/') {
            i = Math.max(i, filePath.lastIndexOf(47));
        }
        return i >= 0 ? filePath.substring(i + 1) : filePath;
    }

    public static String getFileName(File file) {
        if (file != null) {
            return FileUtil.getFileName(file.getPath());
        }
        return "";
    }

    public static String getDirName(File file) {
        if (file != null) {
            return FileUtil.getDirName(file.getPath());
        }
        return "";
    }

    public static String getDirName(String filename) {
        int len = filename.length();
        if (len == 0) {
            return PATH_SEGMENT_CURRENT;
        }
        int pathEnd = len - 1;
        char last = filename.charAt(pathEnd);
        while (last == '/' || last == '\\') {
            if (--pathEnd < 0) {
                return Character.toString(last);
            }
            last = filename.charAt(pathEnd);
        }
        char c = '/';
        int dirEnd = filename.lastIndexOf(c, pathEnd);
        if (dirEnd < 0) {
            c = '\\';
            dirEnd = filename.lastIndexOf(c, pathEnd);
        }
        if (dirEnd >= 0) {
            int lastDirSlash = dirEnd;
            while (c == '/' || c == '\\') {
                if (--dirEnd < 0) {
                    return Character.toString(c);
                }
                c = filename.charAt(dirEnd);
            }
            if (c == ':' && filename.lastIndexOf(47, dirEnd) < 0 && filename.lastIndexOf(47, dirEnd) < 0) {
                dirEnd = lastDirSlash;
            }
            return filename.substring(0, dirEnd + 1);
        }
        if (last == ':') {
            return filename;
        }
        return PATH_SEGMENT_CURRENT;
    }

    @Nullable
    public static String getExtension(@Nullable File file) {
        if (file != null) {
            return FileUtil.getExtension(file.getName());
        }
        return "";
    }

    @Nullable
    public static String getExtension(@Nullable String fileName) {
        int index = fileName.lastIndexOf(46);
        int end = fileName.length() - 1;
        if (index < 0 || index == end) {
            return "";
        }
        if (fileName.lastIndexOf("\\") == end || fileName.lastIndexOf("/") == end) {
            return "";
        }
        return fileName.substring(index + 1).toLowerCase();
    }

    public static String getNameWithoutExtension(File file) {
        return FileUtil.getNameWithoutExtension(file.getName());
    }

    public static String getNameWithoutExtension(String fileName) {
        int extIndex = fileName.lastIndexOf(46);
        int end = fileName.length() - 1;
        if (fileName.lastIndexOf("\\") == end || fileName.lastIndexOf("/") == end) {
            return fileName;
        }
        return fileName.substring(0, extIndex);
    }

    public static boolean hasExtension(String filename, String ext) {
        if (filename == null || filename.length() <= 0) {
            return false;
        }
        return filename.endsWith(ext);
    }

    public static boolean hasExtension(File f, String ext) {
        if (f == null || !f.exists()) {
            return false;
        }
        return f.getName().endsWith(ext);
    }

    public static boolean hasExtensionIgnoreCase(String filename, String ext) {
        if (filename == null || filename.length() <= 0) {
            return false;
        }
        return filename.toLowerCase().endsWith(ext.toLowerCase());
    }

    public static boolean hasExtensionIgnoreCase(File f, String ext) {
        if (f == null || !f.exists()) {
            return false;
        }
        return f.getName().toLowerCase().endsWith(ext.toLowerCase());
    }

    public static boolean isAcceptable(File file, @Nullable FileFilter fileFilter) {
        return fileFilter == null || fileFilter.accept(file);
    }

    public static boolean isAcceptableAll(File file, @Nullable FileFilter fileFilter) {
        if (fileFilter == null) {
            return true;
        }
        do {
            if (fileFilter.accept(file)) continue;
            return false;
        } while ((file = file.getParentFile()) != null);
        return true;
    }

    public static boolean isDir(String s) {
        return FileUtil.isDir(new File(s));
    }

    public static boolean isDir(File f) {
        return f != null && f.exists() && f.isDirectory();
    }

    public static boolean isDirExactly(String s) {
        return FileUtil.isDirExactly(new File(s));
    }

    public static boolean isDirExactly(File f) {
        String absolute;
        if (!FileUtil.isDir(f)) {
            return false;
        }
        String canonical = FileUtil.getCanonicalOrAbsolutePath(f);
        if (canonical.equals(absolute = f.getAbsolutePath())) {
            return true;
        }
        return isWindows && canonical.equalsIgnoreCase(absolute);
    }

    public static boolean isDirEmpty(File file) {
        if (file.isFile()) {
            return false;
        }
        String[] list = file.list();
        return list == null || list.length == 0;
    }

    public static boolean isAbsolute(String path) {
        return new File(path).isAbsolute();
    }

    public static boolean isStartWith(String path, String start) {
        return FileUtil.isStartWith(path, start, isFileSystemCaseSensitive);
    }

    public static boolean isStartWith(String path, String start, boolean caseSensitive) {
        int length1 = path.length();
        int length2 = start.length();
        if (length2 == 0) {
            return true;
        }
        if (length2 > length1) {
            return false;
        }
        if (!path.regionMatches(!caseSensitive, 0, start, 0, length2)) {
            return false;
        }
        if (length1 == length2) {
            return true;
        }
        char last2 = start.charAt(length2 - 1);
        char next1 = last2 == '/' || last2 == File.separatorChar ? path.charAt(length2 - 1) : path.charAt(length2);
        return next1 == '/' || next1 == File.separatorChar;
    }

    public static boolean isNewer(File file, long timeMillis) {
        return file.lastModified() > timeMillis;
    }

    public static boolean isNewer(File f1, File f2) {
        boolean result = f1.lastModified() > f2.lastModified();
        return result;
    }

    public static String getRelativePath(File base, File file, char separator, boolean caseSensitive) {
        String fromPath = FileUtil.getSystemIndependentName(FileUtil.getCanonicalOrAbsolutePath(base));
        String toPath = FileUtil.getSystemIndependentName(FileUtil.getCanonicalOrAbsolutePath(file));
        if (caseSensitive) {
            fromPath = fromPath.toLowerCase();
            toPath = toPath.toLowerCase();
        }
        String[] fromPathStack = fromPath.split("/");
        Object[] toPathStack = toPath.split("/");
        String separtorStr = String.valueOf(separator);
        if (toPathStack.length > 0 && fromPathStack.length > 0) {
            if (!fromPathStack[0].equals(toPathStack[0])) {
                return StringHelper.concateWithSplit(separtorStr, toPathStack);
            }
        } else {
            return StringHelper.concateWithSplit(separtorStr, toPathStack);
        }
        int minLength = Math.min(fromPathStack.length, toPathStack.length);
        int same = 1;
        while (same < minLength && fromPathStack[same].equals(toPathStack[same])) {
            ++same;
        }
        ArrayList<String> relativePathStack = new ArrayList<String>();
        int i = same;
        while (i < fromPathStack.length) {
            relativePathStack.add(PATH_SEGMENT_PARENT);
            ++i;
        }
        i = same;
        while (i < toPathStack.length) {
            relativePathStack.add((String)toPathStack[i]);
            ++i;
        }
        return StringHelper.concateWithSplit(separtorStr, relativePathStack.toArray());
    }

    public static boolean isAncestor(File ancestor, File file, boolean strict) throws IOException {
        File parent;
        File file2 = parent = strict ? FileUtil.getParentFile(file) : file;
        while (parent != null) {
            if (parent.equals(ancestor)) {
                return true;
            }
            parent = FileUtil.getParentFile(parent);
        }
        return false;
    }

    private static void checkFileLength(File file) throws IOException {
        long len = file.length();
        if (len < 0L) {
            throw new IOException("File length reported negative, probably doesn't exist");
        }
        if (len > READ_FILE_LENGTH_LIMIT) {
            throw new IOException("Attempt to load '" + file + "' in memory buffer, file length is " + len + " bytes.");
        }
    }

    public static LinkedList<String> readLines(File file, Charset encoding) throws IOException {
        FileUtil.checkFileLength(file);
        LinkedList<String> lines = new LinkedList<String>();
        BufferedReader reader = FileUtil.getReader(file, encoding);
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                lines.add(line);
            }
        }
        finally {
            reader.close();
        }
        return lines;
    }

    @Nullable
    public static String readString(File file, Charset encoding) throws IOException {
        return new String(FileUtil.readChars(file, encoding));
    }

    @Nullable
    public static String readStringAdaptive(File file, Charset encoding) throws IOException {
        FileUtil.checkFileLength(file);
        BufferedReader reader = FileUtil.getReader(file, encoding);
        try {
            String string = new String(FileUtil.readCharsAdaptive(reader));
            return string;
        }
        finally {
            reader.close();
        }
    }

    @Nullable
    public static char[] readChars(File file, Charset encoding) throws IOException {
        FileUtil.checkFileLength(file);
        BufferedReader reader = FileUtil.getReader(file, encoding);
        try {
            char[] cArray = FileUtil.readChars(reader, (int)file.length());
            return cArray;
        }
        finally {
            reader.close();
        }
    }

    @Nullable
    public static char[] readChars(Reader reader, int length) throws IOException {
        char[] chars = new char[length];
        int count = 0;
        while (count < chars.length) {
            int n = reader.read(chars, count, chars.length - count);
            if (n <= 0) break;
            count += n;
        }
        if (count == chars.length) {
            return chars;
        }
        char[] newChars = new char[count];
        System.arraycopy(chars, 0, newChars, 0, count);
        return newChars;
    }

    @Nullable
    public static char[] readCharsAdaptive(Reader reader) throws IOException {
        int n;
        char[] chars = new char[4096];
        ArrayList<char[]> buffers = null;
        int count = 0;
        int total = 0;
        while ((n = reader.read(chars, count, chars.length - count)) > 0) {
            count += n;
            if ((long)total > READ_FILE_LENGTH_LIMIT) {
                throw new IOException("File too big " + reader);
            }
            total += n;
            if (count != chars.length) continue;
            if (buffers == null) {
                buffers = new ArrayList<char[]>();
            }
            buffers.add(chars);
            int newLength = Math.min(0x100000, chars.length * 2);
            chars = new char[newLength];
            count = 0;
        }
        char[] result = new char[total];
        if (buffers != null) {
            for (char[] buffer : buffers) {
                System.arraycopy(buffer, 0, result, result.length - total, buffer.length);
                total -= buffer.length;
            }
        }
        System.arraycopy(chars, 0, result, result.length - total, total);
        return result;
    }

    @Nullable
    public static byte[] readBytes(File file) throws IOException {
        FileUtil.checkFileLength(file);
        FileInputStream stream = new FileInputStream(file);
        try {
            byte[] byArray = FileUtil.readBytes(stream, (int)file.length());
            return byArray;
        }
        finally {
            ((InputStream)stream).close();
        }
    }

    @Nullable
    public static byte[] readBytesAdaptive(File file) throws IOException {
        FileUtil.checkFileLength(file);
        FileInputStream stream = new FileInputStream(file);
        try {
            byte[] byArray = FileUtil.readBytesAdaptive(stream);
            return byArray;
        }
        finally {
            ((InputStream)stream).close();
        }
    }

    @Nullable
    public static byte[] readBytes(InputStream stream) throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        try {
            int n;
            byte[] bytes = BUFFER.get();
            while ((n = stream.read(bytes, 0, bytes.length)) > 0) {
                buffer.write(bytes, 0, n);
            }
        }
        finally {
            buffer.close();
        }
        return buffer.toByteArray();
    }

    @Nullable
    public static byte[] readBytes(InputStream stream, int length) throws IOException {
        byte[] bytes = new byte[length];
        int count = 0;
        while (count < length) {
            int n = stream.read(bytes, count, length - count);
            if (n <= 0) break;
            count += n;
        }
        return bytes;
    }

    @Nullable
    public static byte[] readBytesAdaptive(InputStream stream) throws IOException {
        int n;
        byte[] bytes = new byte[4096];
        ArrayList<byte[]> buffers = null;
        int count = 0;
        int total = 0;
        while ((n = stream.read(bytes, count, bytes.length - count)) > 0) {
            count += n;
            if ((long)total > READ_FILE_LENGTH_LIMIT) {
                throw new IOException("File too big " + stream);
            }
            total += n;
            if (count != bytes.length) continue;
            if (buffers == null) {
                buffers = new ArrayList<byte[]>();
            }
            buffers.add(bytes);
            int newLength = Math.min(0x100000, bytes.length * 2);
            bytes = new byte[newLength];
            count = 0;
        }
        byte[] result = new byte[total];
        if (buffers != null) {
            for (byte[] buffer : buffers) {
                System.arraycopy(buffer, 0, result, result.length - total, buffer.length);
                total -= buffer.length;
            }
        }
        System.arraycopy(bytes, 0, result, result.length - total, total);
        return result;
    }

    private static File _write(File file, byte[] bytes, boolean append) throws IOException {
        return FileUtil._write(file, bytes, 0, bytes.length, append);
    }

    private static File _write(File file, byte[] text, int off, int len, boolean append) throws IOException {
        FileUtil.ensureDirExists(file);
        BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(file, append));
        try {
            ((OutputStream)stream).write(text, off, len);
        }
        finally {
            ((OutputStream)stream).close();
        }
        return file;
    }

    public static File appendBytes(File file, byte[] bytes) throws IOException {
        return FileUtil._write(file, bytes, true);
    }

    public static File appendString(File file, String String2, Charset encoding) throws IOException {
        return FileUtil._write(file, String2.getBytes(encoding), true);
    }

    public static File appendLines(File file, List<String> lines, Charset encoding) throws IOException {
        FileUtil.ensureDirExists(file);
        RandomAccessFile rf = FileUtil.getRandomAccessFile(file, "rw");
        try {
            rf.seek(rf.getFilePointer() + rf.length());
            for (String line : lines) {
                rf.write(line.getBytes(encoding));
                rf.write(LINE_SEPARATOR);
            }
        }
        finally {
            rf.close();
        }
        return file;
    }

    public static File writeBytes(File file, byte[] bytes) throws IOException {
        return FileUtil._write(file, bytes, false);
    }

    public static File writeString(File file, String String2, Charset encoding) throws IOException {
        return FileUtil._write(file, String2.getBytes(encoding), false);
    }

    public static void writeLines(File file, List<String> lines, Charset encoding) throws IOException {
        BufferedWriter output = FileUtil.getWriter(file, encoding);
        try {
            for (String line : lines) {
                output.write(line);
                output.newLine();
            }
        }
        finally {
            output.close();
        }
    }

    public static boolean delete(File file) {
        String type = file.isDirectory() ? "Dir" : "File";
        long sleep = ATTEMPTS_INITAL_SLEEP;
        int i = 0;
        while (i < ATTEMPTS_COUNT) {
            if (file.delete()) {
                log.debug("delete{}:[{}] OK", (Object)type, (Object)file);
                return true;
            }
            if (file.isDirectory() && file.listFiles().length > 0) {
                log.warn("delete{}:[{}] FOUND IT NONEMPTY", (Object)type, (Object)file);
                return false;
            }
            if (!file.exists()) {
                log.warn("delete{}:[{}] FOUND IT NONEXIST", (Object)type, (Object)file);
                return true;
            }
            try {
                Thread.sleep(sleep);
            }
            catch (InterruptedException e) {
                return false;
            }
            if (sleep < (long)ATTEMPTS_MAX_SLEEP) {
                sleep *= 2L;
            }
            ++i;
        }
        log.error("delete{}:[{}] ERROR", (Object)type, (Object)file);
        return false;
    }

    public static int deleteForce(File file) {
        return FileUtil.deleteRecursively(file, null, true, true);
    }

    public static int deleteRecursively(File rootFile, FileFilter filter, boolean deleteSelf, boolean deleteEmptyDirs) {
        int count = 0;
        File[] files = rootFile.listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (filter == null || filter.accept(file)) {
                    if (file.isDirectory()) {
                        count += FileUtil.deleteRecursively(rootFile, filter, deleteSelf, deleteEmptyDirs);
                        if (deleteEmptyDirs && file.list().length == 0 && FileUtil.delete(file)) {
                            ++count;
                        }
                    } else if (FileUtil.delete(file)) {
                        ++count;
                    }
                }
                ++n2;
            }
        }
        if (deleteSelf && (filter == null || filter.accept(rootFile)) && FileUtil.delete(rootFile)) {
            ++count;
        }
        return count;
    }

    public static boolean ensureDirExists(File file) {
        File parentFile;
        if (!file.exists() && (parentFile = file.getParentFile()) != null) {
            return parentFile.isDirectory() || parentFile.mkdirs();
        }
        return true;
    }

    public static boolean ensureFileExists(File file) {
        block4: {
            if (file.exists()) {
                return true;
            }
            try {
                if (FileUtil.ensureDirExists(file)) break block4;
                return false;
            }
            catch (IOException e) {
                return false;
            }
        }
        return file.createNewFile();
    }

    public static boolean ensuerFileWritable(File file) {
        if (file.exists()) {
            return file.canWrite();
        }
        if (!FileUtil.ensureFileExists(file)) {
            return false;
        }
        return FileUtil.delete(file);
    }

    public static void transfer(InputStream inputStream, OutputStream outputStream) throws IOException {
        int read;
        byte[] buffer = BUFFER.get();
        while ((read = inputStream.read(buffer)) >= 0) {
            outputStream.write(buffer, 0, read);
        }
    }

    public static void transfer(InputStream inputStream, OutputStream outputStream, int size) throws IOException {
        byte[] buffer = BUFFER.get();
        int toRead = size;
        while (toRead > 0) {
            int read = inputStream.read(buffer, 0, Math.min(buffer.length, toRead));
            if (read < 0) break;
            toRead -= read;
            outputStream.write(buffer, 0, read);
        }
    }

    public static void copy(File fromFile, File toFile) throws FileNotFoundException, IOException {
        FileUtil.copy(fromFile, toFile, defaultCopyFromFileAcceptFilter, defaultCopyToFileExistAcceptFilter, defaultCopySyncTimestamp);
    }

    public static void copy(File fromFile, File toFile, FileFilter fromFileAcceptFilter, FileFilter toFileExistFilter, boolean syncTimestamp) throws FileNotFoundException, IOException {
        if (!fromFile.exists()) {
            throw new FileNotFoundException("cant find sourceFile:" + fromFile);
        }
        if (fromFile.isFile()) {
            FileUtil.copyFile(fromFile, toFile, fromFileAcceptFilter, toFileExistFilter, syncTimestamp);
        } else {
            FileUtil.copyDir(fromFile, toFile, fromFileAcceptFilter, toFileExistFilter, syncTimestamp);
        }
    }

    public static void copyFile(File fromFile, File toFile) throws IOException {
        FileUtil.copyFile(fromFile, toFile, defaultCopyFromFileAcceptFilter, defaultCopyToFileExistAcceptFilter, defaultCopySyncTimestamp);
    }

    public static void copyFile(File fromFile, File toFile, FileFilter fromFileAcceptFilter, FileFilter toFileExistFilter, boolean syncTimestamp) throws IOException {
        if (fromFileAcceptFilter != null && !fromFileAcceptFilter.accept(fromFile)) {
            log.debug("copyFile{}:[{}]->[{}] ignore fromFile", new Object[]{syncTimestamp ? "(syncTimestamp)" : "", fromFile, toFile});
            return;
        }
        if (toFileExistFilter != null && !toFileExistFilter.accept(toFile)) {
            log.debug("copyFile{}:[{}]->[{}] ignore toFile", new Object[]{syncTimestamp ? "(syncTimestamp)" : "", fromFile, toFile});
            return;
        }
        if (toFile.isDirectory()) {
            toFile = new File(toFile, fromFile.getName());
            FileUtil.copyFile(fromFile, toFile, fromFileAcceptFilter, toFileExistFilter, syncTimestamp);
        }
        FileInputStream fis = new FileInputStream(fromFile);
        FileOutputStream fos = null;
        boolean success = false;
        IOException error = null;
        try {
            fos = new FileOutputStream(toFile);
        }
        catch (FileNotFoundException e) {
            File parentFile = toFile.getParentFile();
            if (parentFile == null) {
                IOException ioException = new IOException("parent file is null for " + toFile.getPath());
                ioException.initCause(e);
                throw ioException;
            }
            FileUtil.ensureDirExists(toFile);
            fos = new FileOutputStream(toFile);
        }
        try {
            try {
                if (FILE_CHANNEL_TRANSFER_BROKEN || fromFile.length() > 0x500000L) {
                    try {
                        FileUtil.transfer(fis, fos);
                        success = true;
                    }
                    finally {
                        fis.close();
                        fos.close();
                    }
                }
                FileChannel fromChannel = fis.getChannel();
                FileChannel toChannel = fos.getChannel();
                try {
                    fromChannel.transferTo(0L, Long.MAX_VALUE, toChannel);
                    success = true;
                }
                finally {
                    fromChannel.close();
                    toChannel.close();
                }
                if (syncTimestamp) {
                    toFile.setLastModified(fromFile.lastModified());
                }
            }
            catch (IOException e) {
                error = e;
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (success) {
                log.debug("copyFile{}:[{}]->[{}] OK", new Object[]{syncTimestamp ? "(syncTimestamp)" : "", fromFile, toFile});
            } else {
                log.debug("copyFile{}:[{}]->[{}] ERROR", new Object[]{syncTimestamp ? "(syncTimestamp)" : "", fromFile, toFile, error});
            }
            throw throwable;
        }
        if (success) {
            log.debug("copyFile{}:[{}]->[{}] OK", new Object[]{syncTimestamp ? "(syncTimestamp)" : "", fromFile, toFile});
        } else {
            log.debug("copyFile{}:[{}]->[{}] ERROR", new Object[]{syncTimestamp ? "(syncTimestamp)" : "", fromFile, toFile, error});
        }
    }

    public static void copyDir(File fromDir, File toDir) throws IOException {
        FileUtil.copyDir(fromDir, toDir, defaultCopyFromFileAcceptFilter, defaultCopyToFileExistAcceptFilter, defaultCopySyncTimestamp);
    }

    public static void copyDir(@NotNull File fromDir, @NotNull File toDir, @Nullable FileFilter fromFileAcceptFilter, @Nullable FileFilter toFileExistFilter, boolean syncTimestamp) throws IOException {
        if (fromFileAcceptFilter != null && !fromFileAcceptFilter.accept(fromDir)) {
            return;
        }
        if (toDir.isFile()) {
            throw new IllegalAccessError("sourceFile isDir[" + fromDir + "],while targetFile existed and isFile[" + toDir + "]");
        }
        toDir.mkdirs();
        if (syncTimestamp) {
            toDir.setLastModified(fromDir.lastModified());
        }
        if (FileUtil.isAncestor(fromDir, toDir, true)) {
            log.error("{} is ancestor of {}. Can't copy to itself.", new Object[]{fromDir.getAbsolutePath(), toDir.getAbsolutePath()});
            return;
        }
        File[] files = fromDir.listFiles();
        if (files == null) {
            throw new IOException("directory is invalid:" + fromDir.getPath());
        }
        if (!fromDir.canRead()) {
            throw new IOException("directory is not readable:" + fromDir.getPath());
        }
        log.debug("copyDir{}:[{}]->[{}] begin", new Object[]{syncTimestamp ? "(syncTimestamp)" : "", fromDir, toDir});
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                FileUtil.copyDir(file, new File(toDir, file.getName()), fromFileAcceptFilter, toFileExistFilter, syncTimestamp);
            } else {
                FileUtil.copyFile(file, new File(toDir, file.getName()), fromFileAcceptFilter, toFileExistFilter, syncTimestamp);
            }
            ++n2;
        }
    }

    public static void move(File source, File target) throws IOException {
        FileUtil.move(source, target, defaultCopyFromFileAcceptFilter, defaultCopyToFileExistAcceptFilter);
    }

    public static void move(File source, File target, FileFilter fromFileAcceptFilter, FileFilter toFileExistFilter) throws IOException {
        String info = "";
        if (source.renameTo(target)) {
            log.debug("move:[{}]->[{}] By renameTo OK", new Object[]{source, target});
        } else if (!source.exists()) {
            log.warn("move:[{}]->[{}] FOUND SOURCE NONEXIST", new Object[]{source, target});
        } else {
            log.debug("move:[{}]->[{}] by copy-delete BEGIN", new Object[]{source, target});
            FileUtil.copy(source, target, fromFileAcceptFilter, toFileExistFilter, true);
            FileUtil.deleteForce(source);
            log.debug("move:[{}]->[{}] by copy-delete END", new Object[]{source, target});
        }
    }

    public static File createTempDirectory(String prefix, String suffix, File tmpdir) throws IOException {
        if (tmpdir == null) {
            tmpdir = new File(System.getProperty(PROPERTY_TMP_DIR));
        }
        File result = new File(tmpdir, String.valueOf(prefix) + System.currentTimeMillis() + suffix);
        while (result.exists()) {
            result = new File(tmpdir, String.valueOf(prefix) + System.currentTimeMillis() + suffix);
        }
        if (!result.mkdirs()) {
            throw new IOException("Can't create temporary directory: " + result);
        }
        return result;
    }

    public static File createTempDir(File dir, String prefix) {
        File tmpDir = new File(dir, prefix);
        int suffixNum = 1;
        while (tmpDir.exists()) {
            tmpDir = new File(dir, String.valueOf(prefix) + suffixNum++);
        }
        tmpDir.mkdirs();
        return tmpDir;
    }

    public static File createTempFile(File dir, String prefix, String suffix) throws IOException {
        return File.createTempFile(prefix, suffix, dir);
    }

    public static File createTempFile(String prefix, String suffix) throws IOException {
        File file = File.createTempFile(prefix, suffix);
        file.deleteOnExit();
        return file;
    }

    public static Collection<File> listFiles(File dir) {
        return FileUtil.listFiles(dir, new ArrayList<File>(), null);
    }

    public static Collection<File> listFiles(File file, Collection<File> list, FileFilter acceptFilter) {
        if (acceptFilter == null || acceptFilter.accept(file)) {
            File[] files;
            if (file.exists()) {
                list.add(file);
            }
            if ((files = file.listFiles()) != null) {
                File[] fileArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    File f = fileArray[n2];
                    FileUtil.listFiles(file, list, acceptFilter);
                    ++n2;
                }
            }
        }
        return list;
    }

    public static List<CharSequence> grep(String regex, CharBuffer cb) {
        ArrayList<String> linesList = null;
        Pattern pattern = Pattern.compile(regex);
        Pattern linePattern = Pattern.compile(".*\r?\n");
        Matcher lm = linePattern.matcher(cb);
        Matcher pm = null;
        while (lm.find()) {
            String cs = lm.group();
            if (pm == null) {
                pm = pattern.matcher(cs);
            } else {
                pm.reset(cs);
            }
            if (pm.find()) {
                if (linesList == null) {
                    linesList = new ArrayList<String>();
                }
                linesList.add(cs);
            }
            if (lm.end() == cb.limit()) break;
        }
        return linesList;
    }

    public static List<CharSequence> grep(String searchRegex, File f, String encoding) throws IOException {
        List<CharSequence> lines = null;
        FileInputStream fis = null;
        AbstractInterruptibleChannel fc = null;
        try {
            fis = new FileInputStream(f);
            fc = fis.getChannel();
            int sz = (int)((FileChannel)fc).size();
            MappedByteBuffer bb = ((FileChannel)fc).map(FileChannel.MapMode.READ_ONLY, 0L, sz);
            Charset charset = Charset.forName(encoding);
            CharsetDecoder decoder = charset.newDecoder();
            CharBuffer cb = decoder.decode(bb);
            lines = FileUtil.grep(searchRegex, cb);
        }
        finally {
            if (fc != null) {
                fc.close();
            }
            if (fis != null) {
                fis.close();
            }
        }
        return lines;
    }

    public static void sed(String searchRegex, String replace, File file, String encoding) throws IOException {
        Pattern pattern = Pattern.compile(searchRegex);
        FileInputStream fis = null;
        String outString = null;
        try {
            fis = new FileInputStream(file);
            FileChannel fc = fis.getChannel();
            int sz = (int)fc.size();
            MappedByteBuffer bb = fc.map(FileChannel.MapMode.READ_ONLY, 0L, sz);
            Charset charset = Charset.forName(encoding);
            CharsetDecoder decoder = charset.newDecoder();
            CharBuffer cb = decoder.decode(bb);
            Matcher matcher = pattern.matcher(cb);
            outString = matcher.replaceAll(replace);
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
        if (outString != null) {
            PrintStream ps = null;
            try {
                ps = new PrintStream(new FileOutputStream(file));
                ps.print(outString);
                ps.close();
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
    }

    private FileUtil() {
    }

    public static void main(String[] args) throws IOException {
        System.out.println(FileUtil.ensureFileExists(new File("c://xcvxc/asdfasd.file")));
        System.out.println(new File("c:\\", "d:/a/../b"));
    }
}

