/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.util;

import com.xunlei.util.DateUtil;
import com.xunlei.util.DateUtils;
import com.xunlei.util.Log;
import com.xunlei.util.UnitConverter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;

public class DateStringUtil {
    private static final int DEFAULT_GETBETWEEN_ERROR_RESULT = Integer.MAX_VALUE;
    private static final Logger log = Log.getLogger();
    private static final ConcurrentHashMap<String, DateStringUtil> allDateStringUtil = new ConcurrentHashMap(2);
    public static final DateStringUtil DEFAULT_DATE_STRING_UTIL;
    public static final DateStringUtil DEFAULT;
    public static final DateStringUtil DEFAULT_DATE_STRING_UTIL_DAY;
    public static final DateStringUtil DEFAULT_DAY;
    private final String dateForamtPattern;
    private final ThreadLocal<DateFormat> dateFormatFactory;
    private final DateFormat dateFormatUnsafe;

    static {
        DEFAULT = DEFAULT_DATE_STRING_UTIL = DateStringUtil.getInstance("yyyy-MM-dd HH:mm:ss");
        DEFAULT_DAY = DEFAULT_DATE_STRING_UTIL_DAY = DateStringUtil.getInstance("yyyy-MM-dd");
    }

    public String add(Date date, int calendarField, int amount) {
        if (amount == 0) {
            return this.getDateFormat().format(date);
        }
        return this.getDateFormat().format(DateUtils.add(date, calendarField, amount));
    }

    public String add(String date, int calendarField, int amount) {
        try {
            if (amount == 0) {
                return date;
            }
            DateFormat df = this.getDateFormat();
            return df.format(DateUtils.add(df.parse(date), calendarField, amount));
        }
        catch (Exception e) {
            log.error(this.dateForamtPattern, e);
            return date;
        }
    }

    public String addYears(int year) {
        return this.addYears(new Date(), year);
    }

    public String addYears(Date date, int year) {
        return this.add(date, 1, year);
    }

    public String addYears(String date, int year) {
        return this.add(date, 1, year);
    }

    public String addMonths(int month) {
        return this.addMonths(new Date(), month);
    }

    public String addMonths(Date date, int month) {
        return this.add(date, 2, month);
    }

    public String addMonths(String date, int month) {
        return this.add(date, 2, month);
    }

    public String addWeeks(int week) {
        return this.addWeeks(new Date(), week);
    }

    public String addWeeks(Date date, int week) {
        return this.add(date, 3, week);
    }

    public String addWeeks(String date, int week) {
        return this.add(date, 3, week);
    }

    public String addDays(int day) {
        return this.addDays(new Date(), day);
    }

    public String addDays(Date date, int day) {
        return this.add(date, 5, day);
    }

    public String addDays(String date, int day) {
        return this.add(date, 5, day);
    }

    public String addHours(int hour) {
        return this.addHours(new Date(), hour);
    }

    public String addHours(Date date, int hour) {
        return this.add(date, 11, hour);
    }

    public String addHours(String date, int hour) {
        return this.add(date, 11, hour);
    }

    public String addMiniutes(int miniute) {
        return this.addMiniutes(new Date(), miniute);
    }

    public String addMiniutes(Date date, int miniute) {
        return this.add(date, 12, miniute);
    }

    public String addMiniutes(String date, int miniute) {
        return this.add(date, 12, miniute);
    }

    public String addSeconds(int second) {
        return this.addSeconds(new Date(), second);
    }

    public String addSeconds(Date date, int second) {
        return this.add(date, 13, second);
    }

    public String addSeconds(String date, int second) {
        return this.add(date, 13, second);
    }

    public static long getYearsBetween(Date date1, Date date2) {
        return DateStringUtil.getInterval(date1, date2, UnitConverter.TimeUnit.year, false);
    }

    public long getYearsBetween(String date1, String date2) {
        return this.getInterval(date1, date2, UnitConverter.TimeUnit.year, false);
    }

    public static long getYearsBetweenCeil(Date date1, Date date2) {
        return DateStringUtil.getInterval(date1, date2, UnitConverter.TimeUnit.year, true);
    }

    public long getYearsBetweenCeil(String date1, String date2) {
        return this.getInterval(date1, date2, UnitConverter.TimeUnit.year, true);
    }

    public static long getYears365Between(Date date1, Date date2) {
        return DateStringUtil.getInterval(date1, date2, UnitConverter.TimeUnit.year365, false);
    }

    public long getYears365Between(String date1, String date2) {
        return this.getInterval(date1, date2, UnitConverter.TimeUnit.year365, false);
    }

    public static long getYears365BetweenCeil(Date date1, Date date2) {
        return DateStringUtil.getInterval(date1, date2, UnitConverter.TimeUnit.year365, true);
    }

    public long getYears365BetweenCeil(String date1, String date2) {
        return this.getInterval(date1, date2, UnitConverter.TimeUnit.year365, true);
    }

    public static long getMonthsBetween(Date date1, Date date2) {
        return DateStringUtil.getInterval(date1, date2, UnitConverter.TimeUnit.month, false);
    }

    public long getMonthsBetween(String date1, String date2) {
        return this.getInterval(date1, date2, UnitConverter.TimeUnit.month, false);
    }

    public static long getMonthsBetweenCeil(Date date1, Date date2) {
        return DateStringUtil.getInterval(date1, date2, UnitConverter.TimeUnit.month, true);
    }

    public long getMonthsBetweenCeil(String date1, String date2) {
        return this.getInterval(date1, date2, UnitConverter.TimeUnit.month, true);
    }

    public static long getMonths31Between(Date date1, Date date2) {
        return DateStringUtil.getInterval(date1, date2, UnitConverter.TimeUnit.month31, false);
    }

    public long getMonths31Between(String date1, String date2) {
        return this.getInterval(date1, date2, UnitConverter.TimeUnit.month31, false);
    }

    public static long getMonths31BetweenCeil(Date date1, Date date2) {
        return DateStringUtil.getInterval(date1, date2, UnitConverter.TimeUnit.month31, true);
    }

    public long getMonths31BetweenCeil(String date1, String date2) {
        return this.getInterval(date1, date2, UnitConverter.TimeUnit.month31, true);
    }

    public static long getMonths30Between(Date date1, Date date2) {
        return DateStringUtil.getInterval(date1, date2, UnitConverter.TimeUnit.month30, false);
    }

    public long getMonths30Between(String date1, String date2) {
        return this.getInterval(date1, date2, UnitConverter.TimeUnit.month30, false);
    }

    public static long getMonths30BetweenCeil(Date date1, Date date2) {
        return DateStringUtil.getInterval(date1, date2, UnitConverter.TimeUnit.month30, true);
    }

    public long getMonths30BetweenCeil(String date1, String date2) {
        return this.getInterval(date1, date2, UnitConverter.TimeUnit.month30, true);
    }

    public static long getWeeksBetween(Date date1, Date date2) {
        return DateStringUtil.getInterval(date1, date2, UnitConverter.TimeUnit.week, false);
    }

    public long getWeeksBetween(String date1, String date2) {
        return this.getInterval(date1, date2, UnitConverter.TimeUnit.week, false);
    }

    public static long getWeeksBetweenCeil(Date date1, Date date2) {
        return DateStringUtil.getInterval(date1, date2, UnitConverter.TimeUnit.week, true);
    }

    public long getWeeksBetweenCeil(String date1, String date2) {
        return this.getInterval(date1, date2, UnitConverter.TimeUnit.week, true);
    }

    public static long getDaysBetween(Date date1, Date date2) {
        return DateStringUtil.getInterval(date1, date2, UnitConverter.TimeUnit.day, false);
    }

    public long getDaysBetween(String date1, String date2) {
        return this.getInterval(date1, date2, UnitConverter.TimeUnit.day, false);
    }

    public static long getDaysBetweenCeil(Date date1, Date date2) {
        return DateStringUtil.getInterval(date1, date2, UnitConverter.TimeUnit.day, true);
    }

    public long getDaysBetweenCeil(String date1, String date2) {
        return this.getInterval(date1, date2, UnitConverter.TimeUnit.day, true);
    }

    public static long getHoursBetween(Date date1, Date date2) {
        return DateStringUtil.getInterval(date1, date2, UnitConverter.TimeUnit.hour, false);
    }

    public long getHoursBetween(String date1, String date2) {
        return this.getInterval(date1, date2, UnitConverter.TimeUnit.hour, false);
    }

    public static long getHoursBetweenCeil(Date date1, Date date2) {
        return DateStringUtil.getInterval(date1, date2, UnitConverter.TimeUnit.hour, true);
    }

    public long getHoursBetweenCeil(String date1, String date2) {
        return this.getInterval(date1, date2, UnitConverter.TimeUnit.hour, true);
    }

    public static long getMinutesBetween(Date date1, Date date2) {
        return DateStringUtil.getInterval(date1, date2, UnitConverter.TimeUnit.minute, false);
    }

    public long getMinutesBetween(String date1, String date2) {
        return this.getInterval(date1, date2, UnitConverter.TimeUnit.minute, false);
    }

    public static long getMinutesBetweenCeil(Date date1, Date date2) {
        return DateStringUtil.getInterval(date1, date2, UnitConverter.TimeUnit.minute, true);
    }

    public long getMinutesBetweenCeil(String date1, String date2) {
        return this.getInterval(date1, date2, UnitConverter.TimeUnit.minute, true);
    }

    public static long getSecondsBetween(Date date1, Date date2) {
        return DateStringUtil.getInterval(date1, date2, UnitConverter.TimeUnit.second, false);
    }

    public long getSecondsBetween(String date1, String date2) {
        return this.getInterval(date1, date2, UnitConverter.TimeUnit.second, false);
    }

    public static long getSecondsBetweenCeil(Date date1, Date date2) {
        return DateStringUtil.getInterval(date1, date2, UnitConverter.TimeUnit.second, true);
    }

    public long getSecondsBetweenCeil(String date1, String date2) {
        return this.getInterval(date1, date2, UnitConverter.TimeUnit.second, true);
    }

    public static long getMillisecondsBetween(Date date1, Date date2) {
        return date1.getTime() - date2.getTime();
    }

    public long getMillisecondsBetween(String date1, String date2) {
        return this.getInterval(date1, date2, UnitConverter.TimeUnit.millisecond, false);
    }

    public String lastMonthToday() {
        return this.addMonths(-1);
    }

    public String lastWeekToday() {
        return this.addWeeks(-1);
    }

    public String nextMonthToday() {
        return this.addMonths(1);
    }

    public String nextWeekToday() {
        return this.addWeeks(1);
    }

    public String tomorrow() {
        return this.addDays(1);
    }

    public String yesterday() {
        return this.addDays(-1);
    }

    public String now() {
        return this.dateFormatUnsafe.format(System.currentTimeMillis());
    }

    public String afterNow(long second) {
        return this.getDateFormat().format(System.currentTimeMillis() + second * 1000L);
    }

    public String beforeNow(long second) {
        return this.afterNow(-second);
    }

    public String format(Date date) {
        return this.getDateFormat().format(date);
    }

    public Date parse(String dateStr) {
        try {
            return this.getDateFormat().parse(dateStr);
        }
        catch (Exception e) {
            log.error(this.dateForamtPattern, e);
            return null;
        }
    }

    public String oper(Calendar calendar, long ... opers) {
        return this.format(DateUtil.oper(calendar, opers).getTime());
    }

    public String oper(Date date, long ... opers) {
        return this.format(DateUtil.oper(date, opers));
    }

    public String oper(String dateStr, long ... opers) {
        try {
            DateFormat df = this.getDateFormat();
            Date d = DateUtil.oper(df.parse(dateStr), opers);
            return df.format(d);
        }
        catch (Exception e) {
            log.error(this.dateForamtPattern, e);
            return dateStr;
        }
    }

    private DateStringUtil(String dateForamtPattern) {
        this.dateForamtPattern = dateForamtPattern;
        this.dateFormatFactory = DateUtil.makeDateFormatPerThread(dateForamtPattern);
        this.dateFormatUnsafe = new SimpleDateFormat(dateForamtPattern);
    }

    public DateFormat getDateFormat() {
        return this.dateFormatFactory.get();
    }

    public String getDateForamtPattern() {
        return this.dateForamtPattern;
    }

    public long getInterval(String date1, String date2, UnitConverter.TimeUnit timeUnit, boolean ceil) {
        DateFormat df = this.getDateFormat();
        try {
            return DateUtil.getInterval(df.parse(date1), df.parse(date2), timeUnit, ceil);
        }
        catch (Exception e) {
            log.error(this.dateForamtPattern, e);
            return Integer.MAX_VALUE;
        }
    }

    public static long getInterval(Date date1, Date date2, UnitConverter.TimeUnit timeUnit, boolean ceil) {
        return DateUtil.getInterval(date1, date2, timeUnit, ceil);
    }

    public static DateStringUtil getInstance(String dateForamtPattern) {
        DateStringUtil dsu = allDateStringUtil.get(dateForamtPattern);
        if (dsu == null) {
            dsu = new DateStringUtil(dateForamtPattern);
            allDateStringUtil.putIfAbsent(dateForamtPattern, dsu);
        }
        return dsu;
    }
}

