/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.server.usercentre.vo;

import com.xunlei.common.tool.DateUtils;
import com.xunlei.server.register.vo.Userinfo;
import com.xunlei.server.usercentre.exception.DbTableIndexOutOfBoundsException;
import com.xunlei.servlet.util.StringTools;
import java.lang.reflect.Field;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;

public class GameUserInfo {
    private long seqid;
    private long xlinternalno;
    private String gameinternalno;
    private String oldusername = "";
    private String digitusername = "";
    private byte sex = (byte)-1;
    private String password;
    private String email = "";
    private String truename = "";
    private String idcardno = "";
    private Date firstlogintime;
    private Date lastlogintime;
    private byte inuse = 1;

    public GameUserInfo() {
    }

    public GameUserInfo(Userinfo userinfo) {
        if (null != userinfo) {
            this.xlinternalno = userinfo.getReferId();
            this.gameinternalno = userinfo.getUserId().trim();
            this.sex = userinfo.getSex();
            if (StringTools.isNotEmpty((String)userinfo.getUserAccount())) {
                this.oldusername = userinfo.getUserAccount().trim();
            }
            if (StringTools.isNotEmpty((String)userinfo.getDigitAccount())) {
                this.digitusername = userinfo.getDigitAccount().trim();
            }
            this.password = userinfo.getPassword().trim();
            if (StringTools.isNotEmpty((String)userinfo.getEmail())) {
                this.email = userinfo.getEmail().trim();
            }
            if (StringTools.isNotEmpty((String)userinfo.getTruename())) {
                this.truename = userinfo.getTruename().trim();
            }
            if (StringTools.isNotEmpty((String)userinfo.getIdcardno())) {
                this.idcardno = userinfo.getIdcardno().trim();
            }
            if (StringTools.isNotEmpty((String)userinfo.getFirstLoginTime())) {
                this.firstlogintime = DateUtils.parseDatetime((String)userinfo.getFirstLoginTime());
                if (null == this.firstlogintime) {
                    this.firstlogintime = DateUtils.getDateNow();
                }
            }
            if (StringTools.isNotEmpty((String)userinfo.getLastLoginTime())) {
                this.lastlogintime = DateUtils.parseDatetime((String)userinfo.getLastLoginTime());
                if (null == this.lastlogintime) {
                    this.lastlogintime = DateUtils.getDateNow();
                }
            }
        }
    }

    public long getSeqid() {
        return this.seqid;
    }

    public void setSeqid(long seqid) {
        this.seqid = seqid;
    }

    public long getXlinternalno() {
        return this.xlinternalno;
    }

    public void setXlinternalno(long xlinternalno) {
        this.xlinternalno = xlinternalno;
    }

    public String getGameinternalno() {
        return this.gameinternalno;
    }

    public void setGameinternalno(String gameinternalno) {
        this.gameinternalno = gameinternalno;
    }

    public String getOldusername() {
        return this.oldusername;
    }

    public void setOldusername(String oldusername) {
        this.oldusername = oldusername;
    }

    public byte getSex() {
        return this.sex;
    }

    public void setSex(byte sex) {
        this.sex = sex;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getTruename() {
        return this.truename;
    }

    public void setTruename(String truename) {
        this.truename = truename;
    }

    public String getIdcardno() {
        return this.idcardno;
    }

    public void setIdcardno(String idcardno) {
        this.idcardno = idcardno;
    }

    public Date getFirstlogintime() {
        return this.firstlogintime;
    }

    public void setFirstlogintime(Date firstlogintime) {
        this.firstlogintime = firstlogintime;
    }

    public Date getLastlogintime() {
        return this.lastlogintime;
    }

    public void setLastlogintime(Date lastlogintime) {
        this.lastlogintime = lastlogintime;
    }

    public int getTableIdx() {
        return GameUserInfo.getTableIdx(this.xlinternalno);
    }

    public static int getTableIdx(long xlinternalno) {
        if (xlinternalno <= 0L) {
            throw new DbTableIndexOutOfBoundsException("Find the index of table \"GameUserInfo\" is error. The xlinternalno is " + xlinternalno);
        }
        return (int)(xlinternalno % 500L);
    }

    public byte getInuse() {
        return this.inuse;
    }

    public void setInuse(byte inuse) {
        this.inuse = inuse;
    }

    public String toString() {
        Field[] fields = this.getClass().getDeclaredFields();
        StringBuilder str = new StringBuilder();
        for (Field field : fields) {
            try {
                if (field.getType() == Byte.TYPE || field.getType() == Byte.class) {
                    str.append(field.getName()).append(":").append(field.getByte(this)).append("\t");
                    continue;
                }
                if (field.getType() == Long.TYPE || field.getType() == Long.class) {
                    str.append(field.getName()).append(":").append(field.getLong(this)).append("\t");
                    continue;
                }
                if (field.getType() == String.class) {
                    str.append(field.getName()).append(":").append(field.get(this)).append("\t");
                    continue;
                }
                if (field.getType() == Date.class) {
                    Date date = (Date)field.get(this);
                    String time = "";
                    if (date != null) {
                        String format = "yyyy-MM-dd HH:mm:ss";
                        SimpleDateFormat simpleDateF = new SimpleDateFormat(format);
                        time = simpleDateF.format(date);
                    }
                    str.append(field.getName()).append(":").append(time).append("\t");
                    continue;
                }
                str.append(field.getName()).append(":").append(field.get(this)).append("\t");
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return str.toString();
    }

    public String getDigitusername() {
        return this.digitusername;
    }

    public void setDigitusername(String digitusername) {
        this.digitusername = digitusername;
    }

    public void setGameUserInfo(String info) {
        Field[] fields;
        if (info == null || info.equals("")) {
            return;
        }
        String[] values = info.split("\t");
        HashMap<String, String> map = new HashMap<String, String>();
        block10: for (int i = 0; i < values.length; ++i) {
            String[] kv = values[i].split(":");
            switch (kv.length) {
                case 0: {
                    continue block10;
                }
                case 1: {
                    map.put(kv[0], null);
                    continue block10;
                }
                case 2: {
                    map.put(kv[0], kv[1]);
                    continue block10;
                }
                default: {
                    map.put(kv[0], values[i].substring(values[i].indexOf(":") + 1));
                }
            }
        }
        for (Field field : fields = this.getClass().getDeclaredFields()) {
            try {
                String value = (String)map.get(field.getName());
                if (value == null) continue;
                if (field.getType() == Byte.TYPE || field.getType() == Byte.class) {
                    field.setByte(this, Byte.parseByte(value));
                    continue;
                }
                if (field.getType() == Long.TYPE || field.getType() == Long.class) {
                    field.setLong(this, Long.parseLong(value));
                    continue;
                }
                if (field.getType() == String.class) {
                    if (value.equals("null")) continue;
                    field.set(this, value);
                    continue;
                }
                if (field.getType() == Date.class) {
                    if (value.equals("")) continue;
                    String format = "yyyy-MM-dd HH:mm:ss";
                    SimpleDateFormat simpleDateF = new SimpleDateFormat(format);
                    Date date = null;
                    try {
                        date = simpleDateF.parse(value);
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                    field.set(this, date);
                    continue;
                }
                field.set(this, value);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    public static void main(String[] args) {
        GameUserInfo user1 = new GameUserInfo();
        user1.setDigitusername("13548795");
        user1.setSeqid(45687L);
        user1.setFirstlogintime(new Date());
        System.out.println("\u7528\u62371:" + user1);
        GameUserInfo user2 = new GameUserInfo();
        System.out.println("\u7528\u62372:" + user2);
        System.out.println("\u8bbe\u7f6e\u7528\u62372\u4e0e\u7528\u62371\u76f8\u540c");
        user2.setGameUserInfo(user1.toString());
        System.out.println("\u7528\u62372:" + user2);
        System.out.println("\u8bbe\u7f6e\u540e\u7528\u62372\u4e0e\u7528\u62371\u76f8\u540c:" + user2.equals(user1));
    }
}

