/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.server.common.util;

import com.xunlei.server.common.util.BigArrayList;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.math.RandomUtils;

public class BigArrayListTest {
    public static void main(String[] args) throws IOException {
        new BigArrayListTest().testOneElement();
    }

    public void testOneElement() {
        BigArrayList<String> array = new BigArrayList<String>(2);
        array.add("1");
        ArrayList<String> toRemove = new ArrayList<String>();
        toRemove.add("2");
        toRemove.add("1");
        array.removeSequenceList(toRemove);
        System.out.println("array:");
        for (String v : array) {
            System.out.println(v);
        }
    }

    public void testCopy() {
        BigArrayList<String> array = new BigArrayList<String>(5);
        for (int i = 0; i < 13; ++i) {
            String str = RandomStringUtils.randomAlphabetic(20);
            array.add(str);
        }
        BigArrayList copy = array.duplicate();
        System.out.println("array:");
        for (String v : array) {
            System.out.println(v);
        }
        System.out.println("copy:");
        for (String v : copy) {
            System.out.println(v);
        }
    }

    public void testPerformance() throws IOException {
        PrintStream writer = System.out;
        BigArrayList<String> array = new BigArrayList<String>(10000);
        ArrayList<String> toRemove = new ArrayList<String>();
        for (int i = 0; i < 51361; ++i) {
            String str = RandomStringUtils.randomAlphabetic(20);
            array.add(str);
            int r = RandomUtils.nextInt(10);
            if (r != 1 && r != 8) continue;
            toRemove.add(str);
        }
        writer.println("Data: " + array.size());
        writer.println("To removed: " + toRemove.size());
        BigArrayList copy = array.duplicate();
        long start = System.currentTimeMillis();
        List removed = array.removeRandomList(toRemove);
        int i = removed.size();
        writer.println("Random Removed: \t " + i);
        writer.println("left: \t " + array.size());
        writer.println("Random Removed Time: " + (System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        removed = copy.removeSequenceList(toRemove);
        i = removed.size();
        writer.println("Sequence Removed: \t " + i);
        writer.println("left: \t " + copy.size());
        writer.println("Sequence Removed Time: " + (System.currentTimeMillis() - start));
        writer.flush();
        writer.close();
    }

    public void testRemove() {
        BigArrayList<Integer> array = new BigArrayList<Integer>(2);
        array.add(1);
        array.add(2);
        array.add(3);
        array.add(4);
        array.add(5);
        array.add(6);
        array.add(7);
        ArrayList removed = array.removeHeaderList();
        System.out.println("Removed:");
        for (Integer v : removed) {
            System.out.println(v);
        }
        System.out.println("size=" + array.size());
        System.out.println("Left:");
        for (Integer v : array) {
            System.out.println(v);
        }
        array.add(1);
        System.out.println("size=" + array.size());
        System.out.println("Left:");
        for (Integer v : array) {
            System.out.println(v);
        }
        ArrayList<Integer> toRemove = new ArrayList<Integer>();
        toRemove.add(3);
        toRemove.add(6);
        array.removeRandomList(toRemove);
        System.out.println("After remove random (3, 6), size=" + array.size());
        for (Integer v : array) {
            System.out.println(v);
        }
        array.add(2);
        System.out.println("After add 2, size=" + array.size());
        for (Integer v : array) {
            System.out.println(v);
        }
        toRemove.clear();
        toRemove.add(1);
        toRemove.add(2);
        array.removeRandomList(toRemove);
        System.out.println("After remove random (1, 2) again, size=" + array.size());
        for (Integer v : array) {
            System.out.println(v);
        }
        array.add(4);
        array.add(2);
        System.out.println("After add 4, size=" + array.size());
        for (Integer v : array) {
            System.out.println(v);
        }
    }
}

