/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.server.common.util;

import com.xunlei.server.common.util.BigArrayList;
import java.util.ArrayList;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BigArrayListIterator<T>
implements Iterator<T> {
    private ArrayList<T[]> data;
    private T[] currentArray;
    private int currentArraySize;
    private int position;
    private int size;
    private int rowNo = 0;
    private int left;

    public BigArrayListIterator(BigArrayList<T> initData) {
        BigArrayList<T> clone = initData.duplicate();
        this.data = clone.getData();
        this.data.add(clone.getCurrentArray());
        this.currentArray = this.data.get(this.rowNo);
        this.currentArraySize = this.currentArray.length;
        this.size = initData.size();
        this.position = -1;
        this.left = this.size;
    }

    @Override
    public boolean hasNext() {
        return this.left > 0;
    }

    @Override
    public T next() {
        ++this.position;
        if (this.position >= this.currentArraySize) {
            if (this.rowNo >= this.data.size() - 1) {
                return null;
            }
            this.currentArray = this.data.get(++this.rowNo);
            this.currentArraySize = this.currentArray.length;
            this.position = 0;
        }
        --this.left;
        return this.currentArray[this.position];
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

