/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.server.common.util;

import com.xunlei.server.common.exception.AESException;
import com.xunlei.server.common.util.AESAlgorithm;
import com.xunlei.server.common.util.CommonUtil;
import java.io.IOException;
import java.net.UnknownHostException;
import java.security.InvalidKeyException;
import java.util.ArrayList;

public class AESUtil {
    public static Object makeKey(byte[] keyBytes) throws AESException {
        try {
            return AESAlgorithm.makeKey(keyBytes);
        }
        catch (InvalidKeyException e) {
            throw new AESException(e);
        }
    }

    public static byte[] encrypt(byte[] in, Object key) throws AESException {
        return AESUtil.encrypt(in, key, 0);
    }

    public static byte[] encrypt(byte[] in, Object key, int offset) throws AESException {
        try {
            int k;
            int length = in.length - offset;
            int blocks = length / 16;
            int left = length % 16;
            byte[] result = new byte[16 * (blocks + (left == 0 ? 0 : 1)) + 4];
            int cur = 4;
            for (int i = 0; i < blocks; ++i) {
                byte[] encodedData = AESAlgorithm.blockEncrypt(in, offset + i * 16, key);
                for (k = 0; k < 16; ++k) {
                    result[cur++] = encodedData[k];
                }
            }
            if (left != 0) {
                int k2;
                byte[] tmp = new byte[16];
                for (k2 = 0; k2 < left; ++k2) {
                    tmp[k2] = in[blocks * 16 + k2 + offset];
                }
                for (k2 = left; k2 < 16; ++k2) {
                    tmp[k2] = 0;
                }
                byte[] encodedData = AESAlgorithm.blockEncrypt(tmp, 0, key);
                for (k = 0; k < 16; ++k) {
                    result[cur++] = encodedData[k];
                }
            }
            byte[] lengthBytes = CommonUtil.intToByteArray(cur - 4);
            result[0] = lengthBytes[0];
            result[1] = lengthBytes[1];
            result[2] = lengthBytes[2];
            result[3] = lengthBytes[3];
            return result;
        }
        catch (Exception e) {
            throw new AESException(e);
        }
    }

    public static byte[] decrypt(byte[] in, Object key) throws AESException {
        return AESUtil.decrypt(in, key, 0);
    }

    public static byte[] decrypt(byte[] in, Object key, int offset) throws AESException {
        try {
            int len = CommonUtil.byteArrayToInt(in, offset);
            int blocks = len / 16;
            ArrayList<byte[]> list = new ArrayList<byte[]>(blocks);
            int size = 0;
            for (int i = 0; i < blocks; ++i) {
                byte[] decodedData = AESAlgorithm.blockDecrypt(in, offset + i * 16 + 4, key);
                list.add(decodedData);
                size += decodedData.length;
            }
            byte[] ret = new byte[size];
            int index = 0;
            for (int i = 0; i < list.size(); ++i) {
                byte[] d = (byte[])list.get(i);
                for (int j = 0; j < d.length && index != size; ++j, ++index) {
                    ret[index] = d[j];
                }
            }
            return ret;
        }
        catch (Exception e) {
            throw new AESException(e);
        }
    }

    public static byte[] encryptNoLen(byte[] in, Object key) throws AESException {
        return AESUtil.encryptNoLen(in, key, 0);
    }

    public static byte[] encryptNoLen(byte[] in, Object key, int offset) throws AESException {
        try {
            int k;
            int length = in.length - offset;
            int blocks = length / 16;
            int left = length % 16;
            byte[] result = new byte[16 * (blocks + (left == 0 ? 0 : 1))];
            int cur = 0;
            for (int i = 0; i < blocks; ++i) {
                byte[] encodedData = AESAlgorithm.blockEncrypt(in, offset + i * 16, key);
                for (k = 0; k < 16; ++k) {
                    result[cur++] = encodedData[k];
                }
            }
            if (left != 0) {
                int k2;
                byte[] tmp = new byte[16];
                for (k2 = 0; k2 < left; ++k2) {
                    tmp[k2] = in[blocks * 16 + k2 + offset];
                }
                for (k2 = left; k2 < 16; ++k2) {
                    tmp[k2] = 0;
                }
                byte[] encodedData = AESAlgorithm.blockEncrypt(tmp, 0, key);
                for (k = 0; k < 16; ++k) {
                    result[cur++] = encodedData[k];
                }
            }
            return result;
        }
        catch (Exception e) {
            throw new AESException(e);
        }
    }

    public static byte[] decryptNoLen(byte[] in, Object key) throws AESException {
        return AESUtil.decryptNoLen(in, key, 0);
    }

    public static byte[] decryptNoLen(byte[] in, Object key, int offset) throws AESException {
        try {
            int len = in.length;
            int blocks = len / 16;
            ArrayList<byte[]> list = new ArrayList<byte[]>(blocks);
            int size = 0;
            for (int i = 0; i < blocks; ++i) {
                byte[] decodedData = AESAlgorithm.blockDecrypt(in, offset + i * 16, key);
                list.add(decodedData);
                size += decodedData.length;
            }
            byte[] ret = new byte[size];
            int index = 0;
            for (int i = 0; i < list.size(); ++i) {
                byte[] d = (byte[])list.get(i);
                for (int j = 0; j < d.length && index != size; ++j, ++index) {
                    ret[index] = d[j];
                }
            }
            return ret;
        }
        catch (Exception e) {
            throw new AESException(e);
        }
    }

    public static void main(String[] args) throws AESException, UnknownHostException, IOException {
    }
}

