/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.proxy.socket.std;

import com.xunlei.proxy.socket.std.XLDecoderHelper;
import com.xunlei.proxy.socket.std.XLEncoderHelper;
import com.xunlei.proxy.socket.std.XLStandardCodecConfig;
import com.xunlei.proxy.socket.std.msg.XLMessage;
import com.xunlei.proxy.socket.std.msg.XLMessageHeader;
import com.xunlei.util.Log;
import com.xunlei.util.StringHelper;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.Socket;
import java.nio.ByteOrder;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.slf4j.Logger;

public class XLStandardCodecProxy {
    private static final Logger log = Log.getLogger();
    private String host;
    private int port;
    private int timeout;
    private XLStandardCodecConfig config = XLStandardCodecConfig.DEFAULT;

    public XLStandardCodecProxy(String host, int port, int timeout) {
        this.host = host;
        this.port = port;
        this.timeout = timeout;
    }

    public XLStandardCodecProxy(String host, int port, int timeout, ByteOrder endian, int commondHeaderLength, boolean lixianCodec) {
        this.host = host;
        this.port = port;
        this.timeout = timeout;
        this.config = new XLStandardCodecConfig(endian, commondHeaderLength, lixianCodec);
    }

    private ChannelBuffer buildChannelBuffer(DataInputStream in, int length) throws IOException {
        byte[] bytes = new byte[length];
        in.readFully(bytes);
        ChannelBuffer cb = ChannelBuffers.wrappedBuffer(this.config.getEndian(), bytes);
        return cb;
    }

    public XLMessage send(XLMessage req, Class<? extends XLMessageHeader> respHeaderClazz, int respHeaderLength) {
        XLMessage resp;
        block11: {
            Socket client = null;
            DataInputStream in = null;
            OutputStream out = null;
            Throwable ex = null;
            resp = null;
            boolean result = false;
            byte[] reqBytes = null;
            try {
                try {
                    client = new Socket(this.host, this.port);
                    client.setSoTimeout(this.timeout);
                    out = client.getOutputStream();
                    reqBytes = XLEncoderHelper.encodeToBytes(req, this.config);
                    out.write(reqBytes);
                    out.flush();
                    in = new DataInputStream(client.getInputStream());
                    ChannelBuffer headerCb = this.buildChannelBuffer(in, respHeaderLength);
                    int state = 0;
                    Field[] fields = respHeaderClazz.getDeclaredFields();
                    XLMessageHeader mh = respHeaderClazz.newInstance();
                    state = XLDecoderHelper.decodeHeader(state, fields, mh, headerCb, this.config);
                    int contentLen = XLDecoderHelper.getContentLength(mh, this.config);
                    ChannelBuffer content = this.buildChannelBuffer(in, contentLen);
                    content = XLDecoderHelper.decodeContentByAes(mh, content, this.config);
                    resp = XLDecoderHelper.decodeContent(state, fields, mh, content, this.config);
                    result = true;
                }
                catch (Throwable e) {
                    ex = e;
                    if (result) {
                        log.debug("[{}:{},{}]->sendXlMessage[OK],req:{},resp:{}", new Object[]{this.host, this.port, this.timeout, req, resp});
                    } else {
                        log.error("[{}:{},{}]->sendXlMessage[FAIL],req:{}\n{}resp:{}", new Object[]{this.host, this.port, this.timeout, req, StringHelper.printHexString(reqBytes), resp, ex});
                    }
                    break block11;
                }
            }
            catch (Throwable throwable) {
                if (result) {
                    log.debug("[{}:{},{}]->sendXlMessage[OK],req:{},resp:{}", new Object[]{this.host, this.port, this.timeout, req, resp});
                } else {
                    log.error("[{}:{},{}]->sendXlMessage[FAIL],req:{}\n{}resp:{}", new Object[]{this.host, this.port, this.timeout, req, StringHelper.printHexString(reqBytes), resp, ex});
                }
                throw throwable;
            }
            if (result) {
                log.debug("[{}:{},{}]->sendXlMessage[OK],req:{},resp:{}", new Object[]{this.host, this.port, this.timeout, req, resp});
            } else {
                log.error("[{}:{},{}]->sendXlMessage[FAIL],req:{}\n{}resp:{}", new Object[]{this.host, this.port, this.timeout, req, StringHelper.printHexString(reqBytes), resp, ex});
            }
        }
        return resp;
    }
}

