/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.proxy.socket.cbin;

import com.xunlei.proxy.socket.cbin.XLCbinRecordCodec;
import com.xunlei.proxy.socket.cbin.msg.AbstractDecodeMessage;
import com.xunlei.proxy.socket.std.XLDecoderHelper;
import com.xunlei.proxy.socket.std.XLStandardCodecConfig;
import com.xunlei.util.Log;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.lang.reflect.InvocationTargetException;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.frame.FrameDecoder;
import org.slf4j.Logger;

public abstract class BaseXLCBinDecoder
extends FrameDecoder {
    private static final Logger log = Log.getLogger();

    public abstract Class<? extends AbstractDecodeMessage> getDecodeClazz(DataInputStream var1) throws Exception;

    @Override
    protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer cb) throws Exception {
        try {
            XLDecoderHelper.checkReadableBytes(cb, 4);
            int recordLen = cb.getInt(cb.readerIndex());
            ChannelBuffer content = XLDecoderHelper.readBytes(cb, recordLen);
            DataInputStream dis = new DataInputStream(new ByteArrayInputStream(content.array()));
            Class<? extends AbstractDecodeMessage> decodeClazz = this.getDecodeClazz(dis);
            AbstractDecodeMessage r = XLCbinRecordCodec.decode(dis, decodeClazz.newInstance());
            log.debug("decode:{},channel:{}", r, (Object)channel);
            return r;
        }
        catch (XLStandardCodecConfig.ReplayError e) {
            return null;
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException("XLCBinDecode fail!", e.getTargetException());
        }
    }
}

