/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.proxy.socket;

import com.xunlei.proxy.socket.bin.req.Req_getusrinfor;
import com.xunlei.proxy.socket.bin.req.Req_register;
import com.xunlei.proxy.socket.bin.resp.Resp_getusrinfor;
import com.xunlei.proxy.socket.bin.resp.Resp_register;
import com.xunlei.proxy.socket.cbin.XLCbinRecordCodec;
import com.xunlei.spring.Config;
import com.xunlei.util.CloseableHelper;
import com.xunlei.util.Log;
import com.xunlei.util.ValueUtil;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class LoginProxy {
    private static final Logger log = Log.getLogger();
    private static final int sessionIdLen = 128;
    @Config(value="login.host")
    private String host;
    @Config(value="login.port")
    private int port;
    @Config(value="login.timeout")
    private int timeout;
    @Config(value="login.txt.host")
    private String[] txtHost;
    @Config(value="login.txt.port")
    private int[] txtPort;

    public Resp_getusrinfor getusrinfor(String sessionid) {
        if (sessionid == null || sessionid.length() < 128) {
            return new Resp_getusrinfor();
        }
        if (sessionid.length() > 128) {
            sessionid = sessionid.substring(0, 128);
        }
        Resp_getusrinfor resp = new Resp_getusrinfor();
        XLCbinRecordCodec.send(this.host, this.port, this.timeout, new Req_getusrinfor(sessionid), resp);
        return resp;
    }

    public Resp_register register(long userId) {
        Resp_register resp = new Resp_register();
        XLCbinRecordCodec.send(this.host, this.port, this.timeout, new Req_register(userId), resp);
        return resp;
    }

    public LoginInfo validateSessionId(String sessionid) {
        if (sessionid == null || sessionid.length() < 128) {
            return new LoginInfo();
        }
        if (sessionid.length() > 128) {
            sessionid = sessionid.substring(0, 128);
        }
        Socket client = null;
        BufferedReader in = null;
        PrintWriter out = null;
        String resultCode = null;
        boolean resultOk = false;
        int i = 0;
        while (i < this.txtHost.length) {
            block18: {
                Exception ex;
                block15: {
                    LoginInfo loginInfo;
                    block20: {
                        block16: {
                            block13: {
                                block19: {
                                    block14: {
                                        ex = null;
                                        client = new Socket(this.txtHost[i], this.txtPort[i]);
                                        client.setSoTimeout(this.timeout);
                                        out = new PrintWriter(client.getOutputStream());
                                        out.write("getusrinfor\n");
                                        out.write(sessionid);
                                        out.flush();
                                        in = new BufferedReader(new InputStreamReader(client.getInputStream(), "GBK"));
                                        resultCode = in.readLine();
                                        if (!resultCode.startsWith("result:500")) break block13;
                                        if (!resultOk) break block14;
                                        log.debug("getusrinfor[{}:{}],sessionid:{},result:{}", new Object[]{this.txtHost[i], this.txtPort[i], sessionid, resultCode, ex});
                                        break block19;
                                    }
                                    log.error("getusrinfor[{}:{}],sessionid:{},result:{}", new Object[]{this.txtHost[i], this.txtPort[i], sessionid, resultCode, ex});
                                }
                                CloseableHelper.closeSilently(client);
                                break block18;
                            }
                            try {
                                if (!resultCode.equals("200")) break block15;
                                resultOk = true;
                                HashMap<String, String> result = new HashMap<String, String>();
                                StringBuilder sb = new StringBuilder();
                                String line = null;
                                while ((line = in.readLine()) != null) {
                                    sb.append(line).append("\n");
                                    int idx = line.indexOf(61);
                                    if (idx <= 0) continue;
                                    result.put(line.substring(0, idx), line.substring(idx + 1));
                                }
                                loginInfo = new LoginInfo(sb.toString(), result);
                                if (!resultOk) break block16;
                            }
                            catch (Exception e) {
                                block21: {
                                    block17: {
                                        try {
                                            ex = e;
                                            if (!resultOk) break block17;
                                        }
                                        catch (Throwable throwable) {
                                            if (resultOk) {
                                                log.debug("getusrinfor[{}:{}],sessionid:{},result:{}", new Object[]{this.txtHost[i], this.txtPort[i], sessionid, resultCode, ex});
                                            } else {
                                                log.error("getusrinfor[{}:{}],sessionid:{},result:{}", new Object[]{this.txtHost[i], this.txtPort[i], sessionid, resultCode, ex});
                                            }
                                            CloseableHelper.closeSilently(client);
                                            throw throwable;
                                        }
                                        log.debug("getusrinfor[{}:{}],sessionid:{},result:{}", new Object[]{this.txtHost[i], this.txtPort[i], sessionid, resultCode, ex});
                                        break block21;
                                    }
                                    log.error("getusrinfor[{}:{}],sessionid:{},result:{}", new Object[]{this.txtHost[i], this.txtPort[i], sessionid, resultCode, ex});
                                }
                                CloseableHelper.closeSilently(client);
                                break block18;
                            }
                            log.debug("getusrinfor[{}:{}],sessionid:{},result:{}", new Object[]{this.txtHost[i], this.txtPort[i], sessionid, resultCode, ex});
                            break block20;
                        }
                        log.error("getusrinfor[{}:{}],sessionid:{},result:{}", new Object[]{this.txtHost[i], this.txtPort[i], sessionid, resultCode, ex});
                    }
                    CloseableHelper.closeSilently(client);
                    return loginInfo;
                }
                if (resultOk) {
                    log.debug("getusrinfor[{}:{}],sessionid:{},result:{}", new Object[]{this.txtHost[i], this.txtPort[i], sessionid, resultCode, ex});
                } else {
                    log.error("getusrinfor[{}:{}],sessionid:{},result:{}", new Object[]{this.txtHost[i], this.txtPort[i], sessionid, resultCode, ex});
                }
                CloseableHelper.closeSilently(client);
            }
            ++i;
        }
        return new LoginInfo();
    }

    public static enum Key {
        account("account"),
        blogresult("blogresult"),
        checkans("checkans"),
        checkpwd("checkpwd"),
        deadlink("deadlink"),
        dlbytes("dlbytes"),
        dlfilenum("dlfilenum"),
        isvip("isvip"),
        logintype("logintype"),
        nickname("nickname"),
        onlinetime("onlinetime"),
        order("order"),
        savetime("savetime"),
        score("score"),
        sessionid("sessionid"),
        sex("sex"),
        totalorder("totalorder"),
        upgrade("upgrade"),
        usertype("usertype"),
        usrid("usrid"),
        usrname("usrname"),
        usrnewno("usrnewno");

        private String name;

        private Key(String keyName) {
            this.name = keyName;
        }

        public String getName() {
            return this.name;
        }
    }

    public class LoginInfo {
        private boolean loginSuccess;
        private Map<String, String> map;
        private String orimsg;
        private long userId;

        public LoginInfo() {
            this.loginSuccess = false;
            this.map = Collections.emptyMap();
        }

        private LoginInfo(String orimsg, Map<String, String> map) {
            this.loginSuccess = true;
            this.orimsg = orimsg;
            this.map = map;
        }

        public String getOrimsg() {
            return this.orimsg;
        }

        public long getUserId() {
            if (this.userId == 0L) {
                this.userId = ValueUtil.getLong(this.getValue(Key.usrid), -1L);
            }
            return this.userId;
        }

        public String getValue(Key key) {
            return this.map.get(key.getName());
        }

        public String getValue(String key) {
            return this.map.get(key);
        }

        public boolean isOk() {
            return this.loginSuccess;
        }

        public String toString() {
            return "LoginInfo [loginSuccess=" + this.loginSuccess + ", map=" + this.map + ", orimsg=" + this.orimsg + "]";
        }
    }
}

