/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.proxy.http;

import com.xunlei.proxy.HttpClientUtil;
import com.xunlei.spring.Config;
import com.xunlei.util.Log;
import com.xunlei.util.StringTools;
import com.xunlei.util.XmlUtil;
import java.net.URI;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.util.EntityUtils;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FriendProxy {
    private static final Logger log = Log.getLogger();
    @Autowired
    private HttpClient httpClient;
    @Config(value="friend.host")
    private String host;
    private int port;
    private static final int GID = 0;
    private static final int START = 0;
    private static final int NUMBER = 9999;

    public String get_friend_string(String sessionid) {
        try {
            URI uri = URIUtils.createURI("http", this.host, this.port, "/get_friend", "sessionid=" + sessionid + "&type=3&gid=" + 0 + "&start=" + 0 + "&number=" + 9999, null);
            log.debug("httpget url:{}", uri);
            return HttpClientUtil.httpGet(uri.toString());
        }
        catch (Exception e) {
            log.error("", e);
            return null;
        }
    }

    public FriendInfo get_friend_vo(String sessionid) {
        String xmlResult = this.get_friend_string(sessionid);
        if (!StringTools.isEmpty(xmlResult)) {
            return null;
        }
        Element root = XmlUtil.getRootNode(xmlResult);
        FriendInfo friendInfo = new FriendInfo();
        if (root != null) {
            friendInfo.setUid(Long.parseLong(root.attribute("uid").getText()));
            friendInfo.setGroup_num(Integer.parseInt(root.attribute("group_num").getText()));
            friendInfo.setFriend_number(Integer.parseInt(root.attributeValue("friend_number")));
            friendInfo.setGid(Integer.parseInt(root.attributeValue("gid")));
            friendInfo.setGroup_name(root.attributeValue("group_name"));
            friendInfo.setGid_friendnumber(Integer.parseInt(root.attributeValue("gid_friendnumber")));
            friendInfo.setStart(Integer.parseInt(root.attributeValue("start")));
            friendInfo.setNumber(Integer.parseInt(root.attributeValue("number")));
            List<Element> elements = XmlUtil.parseXml(root, "friend");
            ArrayList<FriendInfo.Friend> friends = new ArrayList<FriendInfo.Friend>();
            if (elements != null) {
                FriendInfo.Friend f = null;
                for (Element element : elements) {
                    FriendInfo friendInfo2 = friendInfo;
                    friendInfo2.getClass();
                    f = friendInfo2.new FriendInfo.Friend(Long.parseLong(element.attributeValue("uid")), element.attributeValue("remark"));
                    friends.add(f);
                }
            }
            friendInfo.setFriends(friends);
        }
        return friendInfo;
    }

    public String addFriend(String sessionid, String userid, String remark, String message) {
        URI uri = null;
        HttpRequestBase httpget = null;
        int gid = 0;
        try {
            Element root;
            StringBuilder params = new StringBuilder().append("sessionid=").append(sessionid).append("&gid=").append(gid).append("&uid=").append(userid).append("&remark=").append(URLEncoder.encode(remark, "UTF-8")).append("&message=").append(URLEncoder.encode(message.toString(), "UTF-8"));
            uri = URIUtils.createURI("http", this.host, this.port, "/add_friend", params.toString(), null);
            log.debug("httpget url:{}", uri);
            httpget = new HttpGet(uri);
            httpget.addHeader("Cookie", "sessionid=" + sessionid);
            HttpResponse response = this.httpClient.execute(httpget);
            HttpEntity entity = response.getEntity();
            String result = EntityUtils.toString(entity, "utf-8");
            log.debug("content:{}", (Object)result);
            if (StringTools.isEmpty(result) && (root = XmlUtil.getRootNode(result)) != null) {
                String string = "code : " + root.attributeValue("code") + ",errmsg : " + root.attributeValue("errmsg");
                return string;
            }
            return null;
        }
        catch (Exception e) {
            log.error("httpget -ERROR- " + uri, e);
        }
        finally {
            httpget.abort();
        }
        return null;
    }

    public String addFriendDirectly(String mid, String uid) {
        URI uri = null;
        try {
            Element root;
            uri = URIUtils.createURI("http", this.host, this.port, "/friend_lixian_opr", "myid=" + mid + "&uid=" + uid, null);
            String result = HttpClientUtil.httpGet(uri.toString());
            if (!StringTools.isEmpty(result) && (root = XmlUtil.getRootNode(result)) != null) {
                return "code : " + root.attributeValue("code") + ",errmsg : " + root.attributeValue("errmsg");
            }
        }
        catch (Exception e) {
            log.error("", e);
        }
        return null;
    }

    public class FriendInfo {
        private long uid;
        private int group_num;
        private int friend_number;
        private int gid;
        private String group_name;
        private int gid_friendnumber;
        private int start;
        private int number;
        private List<Friend> friends;

        public long getUid() {
            return this.uid;
        }

        public void setUid(long uid) {
            this.uid = uid;
        }

        public int getGroup_num() {
            return this.group_num;
        }

        public void setGroup_num(int groupNum) {
            this.group_num = groupNum;
        }

        public int getFriend_number() {
            return this.friend_number;
        }

        public void setFriend_number(int friendNumber) {
            this.friend_number = friendNumber;
        }

        public int getGid() {
            return this.gid;
        }

        public void setGid(int gid) {
            this.gid = gid;
        }

        public String getGroup_name() {
            return this.group_name;
        }

        public void setGroup_name(String groupName) {
            this.group_name = groupName;
        }

        public int getGid_friendnumber() {
            return this.gid_friendnumber;
        }

        public void setGid_friendnumber(int gidFriendnumber) {
            this.gid_friendnumber = gidFriendnumber;
        }

        public int getStart() {
            return this.start;
        }

        public void setStart(int start) {
            this.start = start;
        }

        public int getNumber() {
            return this.number;
        }

        public void setNumber(int number) {
            this.number = number;
        }

        public List<Friend> getFriends() {
            return this.friends;
        }

        public void setFriends(List<Friend> friends) {
            this.friends = friends;
        }

        public class Friend {
            private long uid;
            private String remark;

            public Friend(long uid, String remark) {
                this.uid = uid;
                this.remark = remark;
            }

            public long getUid() {
                return this.uid;
            }

            public String getRemark() {
                return this.remark;
            }

            public String toString() {
                return "uid : " + this.getUid() + ",remark : " + this.getRemark();
            }
        }
    }
}

