/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.jinzuan.util;

import com.xunlei.util.StringTools;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DateUtil {
    private static final String PATTERN_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final String PATTERN_FORMAT_SHORT = "yyyy-MM-dd";
    private static ThreadLocal<DateFormat> thread = new ThreadLocal<DateFormat>(){

        @Override
        protected synchronized DateFormat initialValue() {
            return new SimpleDateFormat(DateUtil.PATTERN_FORMAT);
        }
    };
    private static ThreadLocal<DateFormat> threadShort = new ThreadLocal<DateFormat>(){

        @Override
        protected synchronized DateFormat initialValue() {
            return new SimpleDateFormat(DateUtil.PATTERN_FORMAT_SHORT);
        }
    };

    public static DateFormat getDateFormatShort() {
        return threadShort.get();
    }

    public static DateFormat getDateFormat() {
        return thread.get();
    }

    public static String newNow() {
        return DateUtil.getDateFormat().format(new Date());
    }

    public static String newDayTime() {
        return DateUtil.getDateFormat().format(new Date()).substring(0, 10);
    }

    public static long newParse(String time) throws ParseException {
        return DateUtil.getDateFormat().parse(time).getTime();
    }

    public static Date getNowDate() {
        Calendar cal = Calendar.getInstance();
        return cal.getTime();
    }

    public static String getNowTime() {
        return DateUtil.newNow();
    }

    public static String getNowDay() {
        return DateUtil.getNowTime().substring(0, 10);
    }

    public static boolean compareTime(String time1, String time2) throws Exception {
        if (StringTools.isEmpty(time1)) {
            return false;
        }
        if (StringTools.isEmpty(time2)) {
            return true;
        }
        SimpleDateFormat sdf = null;
        sdf = time1.length() == 10 ? new SimpleDateFormat(PATTERN_FORMAT_SHORT) : new SimpleDateFormat(PATTERN_FORMAT);
        Date date1 = sdf.parse(time1);
        Date date2 = sdf.parse(time2);
        return date1.getTime() - date2.getTime() >= 0L;
    }

    public static boolean compareTime(String time1, String time2, long time) throws Exception {
        if (StringTools.isEmpty(time1)) {
            return false;
        }
        if (StringTools.isEmpty(time2)) {
            return true;
        }
        SimpleDateFormat sdf = null;
        sdf = time1.length() == 10 ? new SimpleDateFormat(PATTERN_FORMAT_SHORT) : new SimpleDateFormat(PATTERN_FORMAT);
        Date date1 = sdf.parse(time1);
        Date date2 = sdf.parse(time2);
        return (date1.getTime() - date2.getTime()) / time >= 1L;
    }
}

