/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.jinzuan.task;

import com.xunlei.niux.jinzuan.task.AbstractTimeTask;
import com.xunlei.niux.jinzuan.task.ConnUtil;
import com.xunlei.niux.jinzuan.task.TimeTaskLog;
import com.xunlei.niux.jinzuan.util.HttpClientUtil;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Logger;
import org.json.JSONObject;

public class DayPrivilegeTask
extends AbstractTimeTask {
    private static final Logger logger = Logger.getLogger(DayPrivilegeTask.class.getName());
    private static final String url = "http://jinzuan.niu.xunlei.com:9090/privilege/updatePrivilege.do?";

    public static void main(String[] args) {
        DayPrivilegeTask.info("========DayPrivilegeTask start========");
        DayPrivilegeTask.task();
        DayPrivilegeTask.info("========DayPrivilegeTask  end========");
    }

    private static void info(String info) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        logger.info("nowtime:" + sdf.format(new Date()) + "," + info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void task() {
        Connection conn = null;
        Connection sconn = null;
        Statement stmt = null;
        Statement pstmt = null;
        ResultSet rs = null;
        String uid = null;
        String startTime = sdf.format(new Date());
        long timestamp = System.currentTimeMillis() / 1000L;
        try {
            conn = ConnUtil.getConn();
            sconn = ConnUtil.getConn();
            stmt = conn.createStatement();
            String querysql = "SELECT userid FROM jinzuan_payorder WHERE finishTime >= DATE_SUB(CURDATE(),INTERVAL 1 DAY) and finishTime < CURDATE()   GROUP BY userid";
            String insertsql = "insert into jinzuan_privilegefailureuser values(null,?,'6',?,'0',?,?)";
            pstmt = sconn.prepareStatement(insertsql);
            rs = stmt.executeQuery(querysql);
            int index = 1;
            String time = sdf.format(new Date());
            while (rs.next()) {
                uid = rs.getString(1);
                String url = DayPrivilegeTask.getUrl(uid);
                DayPrivilegeTask.info("index=" + index + ",daytime=" + time + ",uid=" + uid + ",url=" + url);
                int rtn = -1;
                try {
                    String responseText = HttpClientUtil.get(url);
                    JSONObject data = new JSONObject(responseText);
                    rtn = data.getInt("rtn");
                }
                catch (Exception e) {
                    DayPrivilegeTask.info("error index=" + index + ",daytime=" + time + ",uid=" + uid + ",rtn=" + rtn + ",exception=" + e.getMessage());
                }
                finally {
                    DayPrivilegeTask.info("index=" + index + ",daytime=" + time + ",uid=" + uid + ",rtn=" + rtn);
                    if (rtn != 0) {
                        pstmt.setString(1, uid);
                        pstmt.setString(2, time);
                        pstmt.setString(3, "");
                        pstmt.setInt(4, rtn);
                        pstmt.execute();
                    }
                }
                ++index;
            }
            String endTime = sdf.format(new Date());
            timestamp = System.currentTimeMillis() / 1000L - timestamp;
            TimeTaskLog.getInstance().addLog(startTime, endTime, timestamp, "006", "\u6bcf\u6708\u7b2c\u4e00\u5929\u5206\u914d\u7279\u6743", 1, "");
        }
        catch (Exception e) {
            DayPrivilegeTask.info("DayPrivilegeTask exception uid:" + uid + ",reason:" + e.getMessage());
            String endTime = sdf.format(new Date());
            timestamp = System.currentTimeMillis() / 1000L - timestamp;
            TimeTaskLog.getInstance().addLog(startTime, endTime, timestamp, "006", "\u6bcf\u6708\u7b2c\u4e00\u5929\u5206\u914d\u7279\u6743", 0, e.getMessage());
            e.printStackTrace();
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (sconn != null) {
                    sconn.close();
                    sconn = null;
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (stmt != null) {
                    stmt.close();
                    stmt = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static String getUrl(String uid) {
        StringBuffer sb = new StringBuffer("http://jinzuan.niu.xunlei.com:9090/privilege/updatePrivilege.do?uid=");
        sb.append(uid).append("&type=0");
        return sb.toString();
    }
}

