/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.jinzuan.so;

import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.StringTools;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.jinzuan.bo.BaseSo;
import com.xunlei.niux.data.jinzuan.facade.FacadeFactory;
import com.xunlei.niux.data.jinzuan.vo.GrowHistory;
import com.xunlei.niux.data.jinzuan.vo.MemberShip;
import com.xunlei.niux.jinzuan.so.AbstractGrow;
import com.xunlei.niux.jinzuan.util.DateUtil;
import com.xunlei.util.Log;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;

public class PayRewardImpl
extends AbstractGrow {
    private static Logger logger = Log.getLogger(PayRewardImpl.class.getName());

    @Override
    public void getReward(Map<String, Object> map) throws XLRuntimeException, Exception {
        if (map == null) {
            throw new XLRuntimeException("\u53c2\u6570\u4e3a\u7a7a");
        }
        String sourceId = (String)map.get("sourceId");
        Long uid = (Long)map.get("uid");
        Double money = (Double)map.get("money");
        logger.info("payreward getReward uid=" + uid + ",money=" + money + ",sourceId=" + sourceId);
        try {
            BaseSo baseSo = FacadeFactory.INSTANCE.getBaseSo();
            MemberShip ship = this.getMemberShip(uid);
            Date date = DateUtil.getNowDate();
            String nowDay = Daysdf.format(date);
            if (ship == null) {
                logger.info("payreward getReward error uid=" + uid + ",money=" + money + ",not jinzuan user");
                throw new XLRuntimeException("\u4e0d\u662f\u91d1\u94bb\u7528\u6237");
            }
            String experienceDate = ship.getExperienceDate();
            if (!StringTools.isEmpty(experienceDate) && DateUtil.compareTime(experienceDate, nowDay)) {
                throw new XLRuntimeException("\u4f53\u9a8c\u4f1a\u5458\u4e0d\u589e\u52a0\u6210\u957f\u503c");
            }
            GrowHistory queryHistory = new GrowHistory();
            queryHistory.setUserId(uid);
            queryHistory.setDayTime(nowDay);
            queryHistory.setGrowType(new Integer(3));
            Page page = new Page();
            page.setPageNo(1);
            page.setPageSize(10);
            List<GrowHistory> ghlist = baseSo.findObjects(queryHistory, page);
            long growValue = 0L;
            for (GrowHistory gh : ghlist) {
                growValue += gh.getGrowValue().longValue();
            }
            if (StringTools.isEmpty(sourceId)) {
                sourceId = "";
            }
            GrowHistory gh = this.getGrowHistory(uid, sourceId, 3);
            if (ghlist == null || ghlist.size() == 0) {
                if (money >= 200.0) {
                    gh.setGrowValue(new Long(2L));
                } else {
                    gh.setGrowValue(new Long(1L));
                }
            } else {
                if (growValue >= 10L) {
                    logger.info("payreward getReward error uid=" + uid + ",money=" + money + ",over daily max");
                    throw new XLRuntimeException("\u8d85\u8fc7\u4eca\u65e5\u5956\u52b1\u6700\u5927\u7684\u6210\u957f\u503c");
                }
                if (money >= 200.0) {
                    gh.setGrowValue(new Long(1L));
                } else {
                    logger.info("payreward getReward error uid=" + uid + ",money=" + money + ",not add growhistory");
                    throw new XLRuntimeException("\u4e0d\u9700\u8981\u66f4\u65b0\u6210\u957f\u503c");
                }
            }
            this.updateVipGrade(gh, ship);
            logger.info("payreward getReward success uid=" + uid + ",money=" + money);
        }
        catch (Exception e) {
            logger.info("payreward getReward error uid=" + uid + ",money=" + money + ",reason:" + e.getMessage());
            throw e;
        }
    }
}

