/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.jinzuan.cmd.memeber;

import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.httptool.login.MainParam;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.niux.data.jinzuan.facade.FacadeFactory;
import com.xunlei.niux.data.jinzuan.vo.FirstPayBonusHistory;
import com.xunlei.niux.data.jinzuan.vo.MemberShip;
import com.xunlei.niux.data.jinzuan.vo.PrivilegeReceiveInfo;
import com.xunlei.niux.jinzuan.cache.LevelCache;
import com.xunlei.niux.jinzuan.cmd.DefaultCmd;
import com.xunlei.niux.jinzuan.util.AccountUtil;
import com.xunlei.niux.jinzuan.util.DateUtil;
import com.xunlei.niux.jinzuan.util.IpUtil;
import com.xunlei.util.Log;
import com.xunlei.util.StringTools;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class MemberCmd
extends DefaultCmd {
    private static Logger logger = Log.getLogger(MemberCmd.class.getName());
    private static final int[] memberTypeArray = new int[]{1, 2};
    private static final Page page = new Page();

    @CmdMapper(value={"/member/getmemberinfo.do"})
    public Object getMemberInfo(XLHttpRequest request, XLHttpResponse response) {
        String uid = request.getParameter("uid");
        try {
            logger.info("jinzuan getmemberinfo.do  uid=" + uid);
            response.setInnerContentType(XLHttpResponse.ContentType.plain);
            if (StringTools.isEmpty(uid)) {
                return JsonObjectUtil.getRtnAndDataJsonObject(1, "\u53c2\u6570\u4e3a\u7a7a");
            }
            String ip = request.getRemoteIP();
            if (!IpUtil.getInstance().validateIp(ip, 2)) {
                return JsonObjectUtil.getRtnAndDataJsonObject(2, "\u65e0\u6548ip");
            }
            MemberShip query = new MemberShip();
            query.setUserId(Long.parseLong(uid));
            MemberShip memberShip = FacadeFactory.INSTANCE.getBaseSo().findObject(query);
            if (memberShip == null) {
                return JsonObjectUtil.getRtnAndDataJsonObject(3, "\u8be5\u7528\u6237\u975e\u91d1\u94bb\u7528\u6237");
            }
            boolean ismember = MemberCmd.isMember(memberShip, 1);
            boolean isyear = MemberCmd.isMember(memberShip, 2);
            boolean isExperience = MemberCmd.isMember(memberShip, 3);
            boolean isDuobao = MemberCmd.isMember(memberShip, 4);
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("userId", memberShip.getUserId());
            result.put("growthValue", memberShip.getGrowthValue());
            result.put("levelNum", memberShip.getLevelNum());
            result.put("memberStatus", ismember ? 1 : 0);
            result.put("isAnnualMember", isyear ? 1 : 0);
            result.put("experienceStatus", isExperience ? 1 : 0);
            if (isExperience) {
                result.put("memberStatus", 1);
            }
            result.put("duobaoStatus", isDuobao ? 1 : 0);
            result.put("duobaoExpireDate", memberShip.getDuobaoExpireDate() == null ? "" : memberShip.getDuobaoExpireDate());
            result.put("lastDuobaoTime", memberShip.getLastDuobaoTime() == null ? "" : memberShip.getLastDuobaoTime());
            result.put("experienceDate", memberShip.getExperienceDate() == null ? "" : memberShip.getExperienceDate());
            result.put("lastExperienceTime", memberShip.getLastExperienceTime() == null ? "" : memberShip.getLastExperienceTime());
            result.put("registerTime", MemberCmd.formatTime(memberShip.getRegisterTime()));
            result.put("lastFeeTime", MemberCmd.formatTime(memberShip.getLastFeeTime()));
            result.put("annualMemberExpireDate", memberShip.getAnnualMemberExpireDate() == null ? "" : memberShip.getAnnualMemberExpireDate());
            result.put("memberExpireDate", memberShip.getMemberExpireDate() == null ? "" : memberShip.getMemberExpireDate());
            int level = memberShip.getLevelNum();
            long nextLevelGrowthValue = 0L;
            long rightLevelGrowthValue = 0L;
            if (level >= 0) {
                Map<Integer, Long> levelMap = LevelCache.getInstance().getLevelMap();
                rightLevelGrowthValue = levelMap.get(memberShip.getLevelNum()) == null ? 0L : levelMap.get(memberShip.getLevelNum());
                int maxlevel = levelMap.size();
                nextLevelGrowthValue = maxlevel > memberShip.getLevelNum() ? levelMap.get(memberShip.getLevelNum() + 1).longValue() : levelMap.get(memberShip.getLevelNum()).longValue();
            }
            result.put("levelGrowthValue", rightLevelGrowthValue);
            result.put("nextLevelGrowthValue", nextLevelGrowthValue);
            return JsonObjectUtil.getRtnAndDataJsonObject(0, result);
        }
        catch (Exception e) {
            logger.error("getmemberinfo.do exception.uid=" + uid + ",reason:" + e.getMessage());
            return JsonObjectUtil.getRtnAndDataJsonObject(4, "\u7f51\u7edc\u5f02\u5e38");
        }
    }

    @CmdMapper(value={"/member/getloginmember.do"})
    public Object getLoginMember(XLHttpRequest request, XLHttpResponse response) {
        MainParam param = this.checkMainParam(request, response, true);
        long uid = param.getUserid();
        try {
            MemberShip query = new MemberShip();
            query.setUserId(uid);
            MemberShip memberShip = FacadeFactory.INSTANCE.getBaseSo().findObject(query);
            if (memberShip == null) {
                return JsonObjectUtil.getRtnAndDataJsonObject(1, "\u8be5\u7528\u6237\u975e\u91d1\u94bb\u7528\u6237");
            }
            boolean ismember = MemberCmd.isMember(memberShip, 1);
            boolean isyear = MemberCmd.isMember(memberShip, 2);
            boolean isExperience = MemberCmd.isMember(memberShip, 3);
            boolean isDuobao = MemberCmd.isMember(memberShip, 4);
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("userId", memberShip.getUserId());
            result.put("growthValue", memberShip.getGrowthValue());
            result.put("levelNum", memberShip.getLevelNum());
            result.put("memberStatus", ismember ? 1 : 0);
            result.put("isAnnualMember", isyear ? 1 : 0);
            result.put("experienceStatus", isExperience ? 1 : 0);
            if (isExperience) {
                result.put("memberStatus", 1);
            }
            result.put("duobaoStatus", isDuobao ? 1 : 0);
            result.put("duobaoExpireDate", memberShip.getDuobaoExpireDate() == null ? "" : memberShip.getDuobaoExpireDate());
            result.put("lastDuobaoTime", memberShip.getLastDuobaoTime() == null ? "" : memberShip.getLastDuobaoTime());
            result.put("experienceDate", memberShip.getExperienceDate() == null ? "" : memberShip.getExperienceDate());
            result.put("lastExperienceTime", memberShip.getLastExperienceTime() == null ? "" : memberShip.getLastExperienceTime());
            result.put("registerTime", MemberCmd.formatTime(memberShip.getRegisterTime()));
            result.put("lastFeeTime", MemberCmd.formatTime(memberShip.getLastFeeTime()));
            result.put("annualMemberExpireDate", memberShip.getAnnualMemberExpireDate() == null ? "" : memberShip.getAnnualMemberExpireDate());
            result.put("memberExpireDate", memberShip.getMemberExpireDate() == null ? "" : memberShip.getMemberExpireDate());
            int level = memberShip.getLevelNum();
            long rightLevelGrowthValue = 0L;
            long nextLevelGrowthValue = 0L;
            if (level >= 0) {
                Map<Integer, Long> levelMap = LevelCache.getInstance().getLevelMap();
                rightLevelGrowthValue = levelMap.get(memberShip.getLevelNum()) == null ? 0L : levelMap.get(memberShip.getLevelNum());
                int maxlevel = levelMap.size();
                nextLevelGrowthValue = maxlevel > memberShip.getLevelNum() ? levelMap.get(memberShip.getLevelNum() + 1).longValue() : levelMap.get(memberShip.getLevelNum()).longValue();
            }
            result.put("levelGrowthValue", rightLevelGrowthValue);
            result.put("nextLevelGrowthValue", nextLevelGrowthValue);
            return JsonObjectUtil.getRtnAndDataJsonObject(0, result);
        }
        catch (Exception e) {
            logger.error("getmemberinfo.do exception.uid=" + uid + ",reason:" + e.getMessage());
            return JsonObjectUtil.getRtnAndDataJsonObject(2, "\u7f51\u7edc\u5f02\u5e38");
        }
    }

    @CmdMapper(value={"/member/getmember.do"})
    public Object getMember(XLHttpRequest request, XLHttpResponse response) {
        String uid = request.getParameter("uid");
        try {
            logger.info("jinzuan getmember.do  uid=" + uid);
            response.setInnerContentType(XLHttpResponse.ContentType.plain);
            String ip = request.getRemoteIP();
            if (!IpUtil.getInstance().validateIp(ip, 1)) {
                return JsonObjectUtil.getRtnAndDataJsonObject(4, "\u65e0\u6548ip");
            }
            if (StringTools.isEmpty(uid)) {
                return JsonObjectUtil.getRtnAndDataJsonObject(1, "\u53c2\u6570\u4e3a\u7a7a");
            }
            MemberShip query = new MemberShip();
            query.setUserId(Long.parseLong(uid));
            MemberShip memberShip = FacadeFactory.INSTANCE.getBaseSo().findObject(query);
            HashMap<String, Object> result = new HashMap<String, Object>();
            if (memberShip == null) {
                result.put("memberStatus", 1);
                return JsonObjectUtil.getRtnAndDataJsonObject(0, result);
            }
            boolean ismember = MemberCmd.isMember(memberShip, 1);
            boolean isyear = MemberCmd.isMember(memberShip, 2);
            boolean isExperience = MemberCmd.isMember(memberShip, 3);
            boolean isDuobao = MemberCmd.isMember(memberShip, 4);
            if (!ismember) {
                if (StringTools.isEmpty(memberShip.getMemberExpireDate())) {
                    if (isExperience) {
                        result.put("memberStatus", 2);
                    } else {
                        result.put("memberStatus", 1);
                    }
                } else {
                    result.put("memberStatus", 3);
                }
            } else {
                result.put("memberStatus", 2);
            }
            int level = memberShip.getLevelNum();
            long nextLevelGrowthValue = 0L;
            if (level >= 0) {
                Map<Integer, Long> levelMap = LevelCache.getInstance().getLevelMap();
                long rightLevelGrowthValue = levelMap.get(level) == null ? 0L : levelMap.get(level);
                result.put("levelGrowthValue", rightLevelGrowthValue);
                int maxlevel = levelMap.size();
                nextLevelGrowthValue = maxlevel > memberShip.getLevelNum() ? levelMap.get(memberShip.getLevelNum() + 1).longValue() : levelMap.get(memberShip.getLevelNum()).longValue();
            }
            result.put("duobaoStatus", isDuobao ? 1 : 0);
            result.put("duobaoExpireDate", memberShip.getDuobaoExpireDate() == null ? "" : memberShip.getDuobaoExpireDate());
            result.put("lastDuobaoTime", memberShip.getLastDuobaoTime() == null ? "" : memberShip.getLastDuobaoTime());
            result.put("experienceStatus", isExperience ? 1 : 0);
            result.put("experienceDate", memberShip.getExperienceDate() == null ? "" : memberShip.getExperienceDate());
            result.put("lastExperienceTime", memberShip.getLastExperienceTime() == null ? "" : memberShip.getLastExperienceTime());
            result.put("nextLevelGrowthValue", nextLevelGrowthValue);
            result.put("isAnnualMember", isyear ? 1 : 0);
            result.put("userId", memberShip.getUserId());
            result.put("growthValue", memberShip.getGrowthValue());
            result.put("levelNum", memberShip.getLevelNum());
            result.put("registerTime", MemberCmd.formatTime(memberShip.getRegisterTime()));
            result.put("lastFeeTime", MemberCmd.formatTime(memberShip.getLastFeeTime()));
            result.put("annualMemberExpireDate", memberShip.getAnnualMemberExpireDate() == null ? "" : memberShip.getAnnualMemberExpireDate());
            result.put("memberExpireDate", memberShip.getMemberExpireDate() == null ? "" : memberShip.getMemberExpireDate());
            PrivilegeReceiveInfo info = new PrivilegeReceiveInfo();
            info.setUserId(Long.parseLong(uid));
            String daytime = DateUtil.getNowDay();
            info.setYearMonth(daytime.substring(0, 7));
            List<PrivilegeReceiveInfo> prilist = FacadeFactory.INSTANCE.getBaseSo().findObjects(info, page);
            if (!(ismember || isExperience || isDuobao)) {
                for (PrivilegeReceiveInfo pri : prilist) {
                    pri.setTotalValue(0L);
                    pri.setAvailableValue(0L);
                }
            }
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("memberinfo", result);
            data.put("prilist", prilist);
            logger.info("jinzuan getmember.do success  uid=" + uid + ",data=" + data);
            return JsonObjectUtil.getRtnAndDataJsonObject(0, data);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("getmemberinfo.do exception.uid=" + uid + ",reason:" + e.getMessage());
            return JsonObjectUtil.getRtnAndDataJsonObject(3, "\u7f51\u7edc\u5f02\u5e38");
        }
    }

    @CmdMapper(value={"/member/getmember2.do"})
    public Object getMember2(XLHttpRequest request, XLHttpResponse response) {
        String uid = request.getParameter("uid");
        try {
            logger.info("jinzuan getmember.do  uid=" + uid);
            response.setInnerContentType(XLHttpResponse.ContentType.plain);
            String ip = request.getRemoteIP();
            if (!IpUtil.getInstance().validateIp(ip, 1)) {
                return JsonObjectUtil.getRtnAndDataJsonObject(4, "\u65e0\u6548ip");
            }
            if (StringTools.isEmpty(uid)) {
                return JsonObjectUtil.getRtnAndDataJsonObject(1, "\u53c2\u6570\u4e3a\u7a7a");
            }
            MemberShip query = new MemberShip();
            query.setUserId(Long.parseLong(uid));
            MemberShip memberShip = FacadeFactory.INSTANCE.getBaseSo().findObject(query);
            HashMap<String, Object> result = new HashMap<String, Object>();
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("memberinfo", result);
            if (memberShip == null) {
                result.put("memberStatus", 1);
                return JsonObjectUtil.getRtnAndDataJsonObject(0, data);
            }
            boolean ismember = MemberCmd.isMember(memberShip, 1);
            boolean isyear = MemberCmd.isMember(memberShip, 2);
            boolean isExperience = MemberCmd.isMember(memberShip, 3);
            boolean isDuobao = MemberCmd.isMember(memberShip, 4);
            if (!ismember) {
                if (StringTools.isEmpty(memberShip.getMemberExpireDate())) {
                    if (isExperience) {
                        result.put("memberStatus", 2);
                    } else {
                        result.put("memberStatus", 1);
                    }
                } else {
                    result.put("memberStatus", 3);
                }
            } else {
                result.put("memberStatus", 2);
            }
            int level = memberShip.getLevelNum();
            long nextLevelGrowthValue = 0L;
            if (level >= 0) {
                Map<Integer, Long> levelMap = LevelCache.getInstance().getLevelMap();
                long rightLevelGrowthValue = levelMap.get(level) == null ? 0L : levelMap.get(level);
                result.put("levelGrowthValue", rightLevelGrowthValue);
                int maxlevel = levelMap.size();
                nextLevelGrowthValue = maxlevel > memberShip.getLevelNum() ? levelMap.get(memberShip.getLevelNum() + 1).longValue() : levelMap.get(memberShip.getLevelNum()).longValue();
            }
            result.put("duobaoStatus", isDuobao ? 1 : 0);
            result.put("duobaoExpireDate", memberShip.getDuobaoExpireDate() == null ? "" : memberShip.getDuobaoExpireDate());
            result.put("lastDuobaoTime", memberShip.getLastDuobaoTime() == null ? "" : memberShip.getLastDuobaoTime());
            result.put("experienceStatus", isExperience ? 1 : 0);
            result.put("experienceDate", memberShip.getExperienceDate() == null ? "" : memberShip.getExperienceDate());
            result.put("lastExperienceTime", memberShip.getLastExperienceTime() == null ? "" : memberShip.getLastExperienceTime());
            result.put("nextLevelGrowthValue", nextLevelGrowthValue);
            result.put("isAnnualMember", isyear ? 1 : 0);
            result.put("userId", memberShip.getUserId());
            result.put("growthValue", memberShip.getGrowthValue());
            result.put("levelNum", memberShip.getLevelNum());
            result.put("registerTime", MemberCmd.formatTime(memberShip.getRegisterTime()));
            result.put("lastFeeTime", MemberCmd.formatTime(memberShip.getLastFeeTime()));
            result.put("annualMemberExpireDate", memberShip.getAnnualMemberExpireDate() == null ? "" : memberShip.getAnnualMemberExpireDate());
            result.put("memberExpireDate", memberShip.getMemberExpireDate() == null ? "" : memberShip.getMemberExpireDate());
            PrivilegeReceiveInfo info = new PrivilegeReceiveInfo();
            info.setUserId(Long.parseLong(uid));
            String daytime = DateUtil.getNowDay();
            info.setYearMonth(daytime.substring(0, 7));
            List<PrivilegeReceiveInfo> prilist = FacadeFactory.INSTANCE.getBaseSo().findObjects(info, page);
            if (!ismember && !isExperience) {
                for (PrivilegeReceiveInfo pri : prilist) {
                    pri.setTotalValue(0L);
                    pri.setAvailableValue(0L);
                }
            }
            data.put("prilist", prilist);
            logger.info("jinzuan getmember.do success  uid=" + uid + ",data=" + data);
            return JsonObjectUtil.getRtnAndDataJsonObject(0, data);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("getmemberinfo.do exception.uid=" + uid + ",reason:" + e.getMessage());
            return JsonObjectUtil.getRtnAndDataJsonObject(3, "\u7f51\u7edc\u5f02\u5e38");
        }
    }

    private static String formatTime(String time) {
        if (StringTools.isEmpty(time)) {
            return "";
        }
        if (time.indexOf(".") != -1 && "0000-00-00 00:00:00".equals(time = time.substring(0, time.indexOf(".")))) {
            return "";
        }
        return time;
    }

    @CmdMapper(value={"/member/isJinZuanMember.do"})
    public Object isJinZuanMember(XLHttpRequest request, XLHttpResponse response) {
        String username = request.getParameter("username");
        String callback = request.getParameter("callback");
        String reponseText = "var " + callback + "=";
        response.setInnerContentType(XLHttpResponse.ContentType.plain);
        String userId = null;
        try {
            if (StringTools.isEmpty(username) || StringTools.isEmpty(callback)) {
                return reponseText + "{rtn:1}";
            }
            logger.info("username ==" + username);
            userId = AccountUtil.getUserIdByUserName(username);
            logger.info("username ==" + username + ",userId==" + userId);
            if (StringTools.isEmpty(userId)) {
                return reponseText + "{rtn:2}";
            }
            MemberShip query = new MemberShip();
            query.setUserId(Long.parseLong(userId));
            MemberShip memberShip = FacadeFactory.INSTANCE.getBaseSo().findObject(query);
            if (memberShip == null) {
                return reponseText + "{rtn:3}";
            }
            String memberExpireDate = memberShip.getMemberExpireDate();
            boolean validFlag = DateUtil.compareTime(memberExpireDate, DateUtil.getNowDay());
            if (validFlag) {
                return reponseText + "{rtn:0}";
            }
            return reponseText + "{rtn:3}";
        }
        catch (Exception e) {
            logger.error("username ==" + username + ",userId==" + userId, e);
            return reponseText + "{rtn:4}";
        }
    }

    @CmdMapper(value={"/member/getfirstpaybonushistory.do"})
    public Object getFirstPayBonusHistory(XLHttpRequest request, XLHttpResponse response) {
        String userId = request.getParameter("uid", "");
        Long uid = Long.parseLong(userId);
        try {
            logger.info("jinzuan getfirstpaybonushistory.do  uid=" + uid);
            HashMap<String, Object> result = new HashMap<String, Object>();
            FirstPayBonusHistory firstPayBonusHistory = new FirstPayBonusHistory();
            firstPayBonusHistory.setUserId(uid);
            firstPayBonusHistory = FacadeFactory.INSTANCE.getBaseSo().findObject(firstPayBonusHistory);
            if (firstPayBonusHistory != null) {
                result.put("userId", uid);
                result.put("bonusChargeTime", firstPayBonusHistory.getBonusChargeTime());
                return JsonObjectUtil.getRtnAndDataJsonObject(0, result);
            }
            return JsonObjectUtil.getRtnAndDataJsonObject(1, "\u672a\u9886\u53d6");
        }
        catch (Exception e) {
            logger.error("getmemberinfo.do exception.uid=" + uid + ",reason:" + e.getMessage());
            return JsonObjectUtil.getRtnAndDataJsonObject(4, "\u7f51\u7edc\u5f02\u5e38");
        }
    }

    @CmdMapper(value={"/member/isMember.do"})
    public Object isMember(XLHttpRequest request, XLHttpResponse response) {
        String uid = request.getParameter("uid");
        try {
            String type = request.getParameter("type");
            if (StringTools.isEmpty(type)) {
                return JsonObjectUtil.getRtnAndDataJsonObject(1, "\u53c2\u6570\u4e3a\u7a7a");
            }
            int vtype = Integer.parseInt(type);
            boolean flag = false;
            for (int membertype : memberTypeArray) {
                if (vtype != membertype) continue;
                flag = true;
            }
            if (!flag) {
                return JsonObjectUtil.getRtnAndDataJsonObject(2, "\u91d1\u94bb\u4f1a\u5458\u7c7b\u578b\u4e0d\u6b63\u786e");
            }
            MemberShip query = new MemberShip();
            query.setUserId(Long.parseLong(uid));
            MemberShip memberShip = FacadeFactory.INSTANCE.getBaseSo().findObject(query);
            if (memberShip == null) {
                return JsonObjectUtil.getRtnAndDataJsonObject(3, "\u8be5\u7528\u6237\u975e\u91d1\u94bb\u7528\u6237");
            }
            HashMap<String, Boolean> result = new HashMap<String, Boolean>();
            boolean validFlag = false;
            String nowday = MemberCmd.now().split(" ")[0];
            switch (vtype) {
                case 1: {
                    String memberExpireDate = memberShip.getMemberExpireDate();
                    validFlag = DateUtil.compareTime(memberExpireDate, nowday);
                    break;
                }
                case 2: {
                    String annualMemberExpireDate = memberShip.getAnnualMemberExpireDate();
                    validFlag = DateUtil.compareTime(annualMemberExpireDate, nowday);
                }
            }
            result.put("validFlag", validFlag);
            return JsonObjectUtil.getRtnAndDataJsonObject(0, result);
        }
        catch (Exception e) {
            logger.error("getmemberinfo.do exception.uid=" + uid + ",reason:" + e.getMessage());
            return JsonObjectUtil.getRtnAndDataJsonObject(4, "\u7f51\u7edc\u5f02\u5e38");
        }
    }

    public static boolean isMember(String uid, int vtype) throws Exception {
        MemberShip query = new MemberShip();
        query.setUserId(Long.parseLong(uid));
        MemberShip memberShip = FacadeFactory.INSTANCE.getBaseSo().findObject(query);
        if (memberShip == null) {
            throw new XLRuntimeException("\u8be5\u7528\u6237\u975e\u91d1\u94bb\u7528\u6237");
        }
        boolean validFlag = false;
        String nowday = MemberCmd.now().split(" ")[0];
        switch (vtype) {
            case 1: {
                String memberExpireDate = memberShip.getMemberExpireDate();
                validFlag = DateUtil.compareTime(memberExpireDate, nowday);
                break;
            }
            case 2: {
                String annualMemberExpireDate = memberShip.getAnnualMemberExpireDate();
                validFlag = DateUtil.compareTime(annualMemberExpireDate, nowday);
            }
        }
        return validFlag;
    }

    public static boolean isMember(MemberShip memberShip, int vtype) throws Exception {
        if (memberShip == null) {
            throw new XLRuntimeException("\u8be5\u7528\u6237\u975e\u91d1\u94bb\u7528\u6237");
        }
        boolean validFlag = false;
        String nowday = MemberCmd.now().split(" ")[0];
        switch (vtype) {
            case 1: {
                String memberExpireDate = memberShip.getMemberExpireDate();
                validFlag = DateUtil.compareTime(memberExpireDate, nowday);
                break;
            }
            case 2: {
                String annualMemberExpireDate = memberShip.getAnnualMemberExpireDate();
                validFlag = DateUtil.compareTime(annualMemberExpireDate, nowday);
                break;
            }
            case 3: {
                String experienceDate = memberShip.getExperienceDate();
                validFlag = DateUtil.compareTime(experienceDate, nowday);
                break;
            }
            case 4: {
                String duobaoDate = memberShip.getDuobaoExpireDate();
                validFlag = DateUtil.compareTime(duobaoDate, nowday);
            }
        }
        return validFlag;
    }
}

